/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.core.analysis;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLinkageSpecification;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTUsingDirective;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.analysis.PldtAstVisitor;
import org.eclipse.ptp.pldt.mpi.core.Messages;

public class MpiCPPASTVisitor
extends PldtAstVisitor {
    private static final boolean traceOn = false;
    private static final String PREFIX1 = "MPI_";
    private static final String PREFIX2 = "MPI::";
    private boolean usingNamespaceMPI;

    public MpiCPPASTVisitor(List mpiIncludes, String fileName, ScanReturn msr) {
        super(mpiIncludes, fileName, msr);
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitTranslationUnit = true;
        this.usingNamespaceMPI = false;
        ARTIFACT_CALL = Messages.getString("MpiCPPASTVisitor.mpiCall");
        ARTIFACT_CONSTANT = Messages.getString("MpiCPPASTVisitor.mpiConstant");
    }

    public int visit(IASTDeclaration declaration) {
        CPPASTUsingDirective cppASTUsingDirective;
        if (declaration instanceof CPPASTUsingDirective && "MPI".equals((cppASTUsingDirective = (CPPASTUsingDirective)declaration).getQualifiedName().getRawSignature())) {
            this.usingNamespaceMPI = true;
        }
        if (declaration instanceof CPPASTLinkageSpecification && declaration.getFileLocation() == null) {
            return 3;
        }
        if (declaration.getFileLocation() == null) {
            // empty if block
        }
        return super.visit(declaration);
    }

    public int visit(IASTExpression expression) {
        if (expression instanceof IASTFunctionCallExpression) {
            IASTExpression astExpr = ((IASTFunctionCallExpression)expression).getFunctionNameExpression();
            String signature = astExpr.getRawSignature();
            if (this.usingNamespaceMPI || signature.startsWith(PREFIX1) || signature.startsWith(PREFIX2)) {
                IASTName funcName = null;
                if (astExpr instanceof CPPASTFieldReference) {
                    CPPASTFieldReference cppFieldReference = (CPPASTFieldReference)astExpr;
                    funcName = cppFieldReference.getFieldName();
                } else if (astExpr instanceof IASTIdExpression) {
                    funcName = ((IASTIdExpression)astExpr).getName();
                }
                this.processFuncName(funcName, astExpr);
            }
        } else if (expression instanceof CPPASTIdExpression && !(expression.getParent() instanceof IASTFunctionCallExpression)) {
            this.processIdExprAsLiteral((IASTIdExpression)((CPPASTIdExpression)expression));
        } else if (expression instanceof IASTLiteralExpression) {
            this.processMacroLiteral((IASTLiteralExpression)expression);
        }
        return 3;
    }

    protected String chooseName(String bindingName, String rawSignature) {
        String name = bindingName;
        if (bindingName.length() == 0) {
            name = rawSignature;
        }
        if (rawSignature.startsWith(PREFIX2)) {
            name = rawSignature;
        }
        return name;
    }

    public boolean allowIncludePathAdd() {
        return false;
    }

    public boolean addIncludePath(IPath path, String name, boolean dontAskAgain) {
        return false;
    }
}

