/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.core;

import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.internal.core.RemoteServicesProxy;
import org.osgi.framework.BundleContext;

public class PTPRemoteCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.ptp.remote.core";
    public static final String EXTENSION_POINT_ID = "remoteServices";
    private static PTPRemoteCorePlugin plugin;
    private Map<String, RemoteServicesProxy> allRemoteServicesById;
    private Map<String, RemoteServicesProxy> allRemoteServicesByScheme;
    private IRemoteServices defaultRemoteServices;

    public static Object getAdapter(Object sourceObject, Class adapterType) {
        Object result;
        IAdaptable adaptable;
        Object result2;
        Assert.isNotNull((Object)adapterType);
        if (sourceObject == null) {
            return null;
        }
        if (adapterType.isInstance(sourceObject)) {
            return sourceObject;
        }
        if (sourceObject instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)sourceObject).getAdapter(adapterType)) != null) {
            Assert.isTrue((boolean)adapterType.isInstance(result2));
            return result2;
        }
        if (!(sourceObject instanceof PlatformObject) && (result = Platform.getAdapterManager().getAdapter(sourceObject, adapterType)) != null) {
            return result;
        }
        return null;
    }

    public static PTPRemoteCorePlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        if (PTPRemoteCorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return PTPRemoteCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        PTPRemoteCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(String message) {
        PTPRemoteCorePlugin.log((IStatus)new Status(4, PTPRemoteCorePlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(Throwable e) {
        PTPRemoteCorePlugin.log((IStatus)new Status(4, PTPRemoteCorePlugin.getUniqueIdentifier(), 4, e.getMessage(), e));
    }

    public synchronized IRemoteServices[] getAllRemoteServices() {
        this.retrieveRemoteServices();
        IRemoteServices[] services = this.allRemoteServicesById.values().toArray(new IRemoteServices[this.allRemoteServicesById.size()]);
        Arrays.sort(services, new RemoteServicesSorter());
        return services;
    }

    public IRemoteConnection getConnection(URI uri) {
        String host;
        IRemoteServices services = this.getRemoteServices(uri);
        if (services != null && (host = uri.getHost()) != null) {
            return services.getConnectionManager().getConnection(host);
        }
        return null;
    }

    public synchronized IRemoteServices getDefaultServices() {
        if (this.defaultRemoteServices == null) {
            IRemoteServices[] allServices = this.getAllRemoteServices();
            this.defaultRemoteServices = allServices[allServices.length - 1];
            IRemoteServices[] iRemoteServicesArray = allServices;
            int n = allServices.length;
            int n2 = 0;
            while (n2 < n) {
                IRemoteServices services = iRemoteServicesArray[n2];
                if (services.getId().equals("org.eclipse.ptp.remote.LocalServices")) {
                    this.defaultRemoteServices = services;
                    break;
                }
                ++n2;
            }
        }
        return this.defaultRemoteServices;
    }

    public synchronized IRemoteServices getRemoteServices(String id) {
        this.retrieveRemoteServices();
        return this.allRemoteServicesById.get(id);
    }

    public IRemoteServices getRemoteServices(URI uri) {
        this.retrieveRemoteServices();
        String scheme = uri.getScheme();
        if (scheme != null) {
            return this.allRemoteServicesByScheme.get(uri.getScheme());
        }
        return null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.defaultRemoteServices = null;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    private void retrieveRemoteServices() {
        if (this.allRemoteServicesById == null) {
            IExtension[] extensions;
            this.allRemoteServicesById = new HashMap<String, RemoteServicesProxy>();
            this.allRemoteServicesByScheme = new HashMap<String, RemoteServicesProxy>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID);
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    RemoteServicesProxy proxy = new RemoteServicesProxy(ce);
                    if (proxy.initialize()) {
                        this.allRemoteServicesById.put(proxy.getId(), proxy);
                        this.allRemoteServicesByScheme.put(proxy.getScheme(), proxy);
                    } else {
                        PTPRemoteCorePlugin.log("Failed to initialize remote service: " + proxy.getId() + "(" + proxy.getName() + ")");
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoteServicesSorter
    implements Comparator<IRemoteServices> {
        private RemoteServicesSorter() {
        }

        @Override
        public int compare(IRemoteServices o1, IRemoteServices o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }
}

