/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.core.rtsystem;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.attributes.ArrayAttribute;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.BooleanAttribute;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IAttributeDefinition;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.core.attributes.StringAttribute;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.attributes.JobAttributes;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.rm.core.ToolsRMPlugin;
import org.eclipse.ptp.rm.core.rmsystem.AbstractEffectiveTollRMConfiguration;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.core.rtsystem.IToolRuntimeSystemJob;
import org.eclipse.ptp.rm.core.rtsystem.Messages;
import org.eclipse.ptp.rm.core.utils.DebugUtil;
import org.eclipse.ptp.utils.core.linux.ArgumentParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractToolRuntimeSystemJob
extends Job
implements IToolRuntimeSystemJob {
    protected String jobID;
    protected String queueID;
    protected IRemoteProcess process = null;
    protected AttributeManager attrMgr;
    protected AbstractToolRuntimeSystem rtSystem;
    protected boolean terminateJobFlag = false;
    static final Pattern variablePattern = Pattern.compile("/$/{(/w+)((?:(?:////)|(?:///})|[^/}])*)/}".replace('/', '\\'));
    static final Pattern parameterPattern = Pattern.compile(":((?:(?:////)|(?:///:)|(?:///})|[^:])*)".replace('/', '\\'));

    public AbstractToolRuntimeSystemJob(String jobID, String queueID, String name, AbstractToolRuntimeSystem rtSystem, AttributeManager attrMgr) {
        super(name);
        this.attrMgr = attrMgr;
        this.rtSystem = rtSystem;
        this.jobID = jobID;
        this.queueID = queueID;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IToolRuntimeSystemJob.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public String getQueueID() {
        return this.queueID;
    }

    @Override
    public String getJobID() {
        return this.jobID;
    }

    @Override
    public AbstractToolRuntimeSystem getRtSystem() {
        return this.rtSystem;
    }

    public AttributeManager getAttrMgr() {
        return this.attrMgr;
    }

    protected IStatus run(IProgressMonitor monitor) {
        String directory;
        Map<String, String> environment;
        List<String> command;
        this.changeJobState(JobAttributes.State.STARTED);
        if (DebugUtil.RTS_JOB_TRACING_MORE) {
            System.out.println("Launch attributes:");
            String[] array = this.getAttrMgr().toStringArray();
            int i = 0;
            while (i < array.length) {
                System.out.println(array[i]);
                ++i;
            }
        }
        try {
            DebugUtil.trace(DebugUtil.RTS_JOB_TRACING_MORE, "RTS job #{0}: handle prepare", this.jobID);
            this.doPrepareExecution();
        }
        catch (CoreException e) {
            this.changeJobState(JobAttributes.State.ERROR);
            return new Status(4, ToolsRMPlugin.getDefault().getBundle().getSymbolicName(), Messages.AbstractToolRuntimeSystemJob_Exception_PrepareExecution, (Throwable)e);
        }
        try {
            DebugUtil.trace(DebugUtil.RTS_JOB_TRACING_MORE, "About to run RTS job #{0}.", this.jobID);
            command = null;
            environment = null;
            directory = null;
            try {
                AttributeManager baseSubstitutionAttributeManager = this.retrieveBaseSubstitutionAttributes();
                environment = this.retrieveEnvironment(baseSubstitutionAttributeManager);
                directory = this.retrieveWorkingDirectory(baseSubstitutionAttributeManager);
                AttributeManager commandSubstitutionAttributeManager = this.retrieveCommandSubstitutionAttributes(baseSubstitutionAttributeManager, directory, environment);
                BooleanAttribute debugAttr = (BooleanAttribute)this.attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getDebugFlagAttributeDefinition());
                command = debugAttr != null && debugAttr.getValue() != false ? this.retrieveCreateDebugCommand(commandSubstitutionAttributeManager) : this.retrieveCreateLaunchCommand(commandSubstitutionAttributeManager);
                if (DebugUtil.RTS_JOB_TRACING) {
                    IAttribute attr;
                    System.out.println("Available macros for environment and work directory:");
                    IAttribute[] iAttributeArray = baseSubstitutionAttributeManager.getAttributes();
                    int n = iAttributeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        attr = iAttributeArray[n2];
                        System.out.println(MessageFormat.format("  {0}={1}", ((IAttributeDefinition)((Object)attr.getDefinition())).getId(), attr.getValueAsString()));
                        ++n2;
                    }
                    System.out.println("Available macros for command:");
                    iAttributeArray = commandSubstitutionAttributeManager.getAttributes();
                    n = iAttributeArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        attr = iAttributeArray[n2];
                        System.out.println(MessageFormat.format("  {0}={1}", ((IAttributeDefinition)((Object)attr.getDefinition())).getId(), attr.getValueAsString()));
                        ++n2;
                    }
                    System.out.println("Environment variables:");
                    for (Map.Entry<String, String> env : environment.entrySet()) {
                        System.out.println(MessageFormat.format("  export {0}={1}", env.getKey(), env.getValue()));
                    }
                    System.out.println(MessageFormat.format("Work directory: {0}", directory));
                    ArgumentParser argumentParser = new ArgumentParser(command);
                    System.out.println(MessageFormat.format("Command: {0}", argumentParser.getCommandLine(false)));
                }
            }
            catch (CoreException e) {
                this.changeJobState(JobAttributes.State.ERROR);
                Status status = new Status(4, ToolsRMPlugin.getDefault().getBundle().getSymbolicName(), Messages.AbstractToolRuntimeSystemJob_Exception_CreateCommand, (Throwable)e);
                DebugUtil.trace(DebugUtil.RTS_JOB_TRACING_MORE, "RTS job #{0}: cleanup", this.jobID);
                IPJob ipJob = PTPCorePlugin.getDefault().getUniverse().getResourceManager(this.rtSystem.getRmID()).getQueueById(this.getQueueID()).getJobById(this.getJobID());
                switch (ipJob.getState()) {
                    case TERMINATED: 
                    case ERROR: {
                        break;
                    }
                    case PENDING: 
                    case STARTED: 
                    case RUNNING: 
                    case SUSPENDED: 
                    case UNKNOWN: {
                        this.changeJobState(JobAttributes.State.TERMINATED);
                    }
                }
                this.doExecutionCleanUp();
                return status;
            }
        }
        catch (Throwable throwable) {
            DebugUtil.trace(DebugUtil.RTS_JOB_TRACING_MORE, "RTS job #{0}: cleanup", this.jobID);
            IPJob ipJob = PTPCorePlugin.getDefault().getUniverse().getResourceManager(this.rtSystem.getRmID()).getQueueById(this.getQueueID()).getJobById(this.getJobID());
            switch (ipJob.getState()) {
                case TERMINATED: 
                case ERROR: {
                    break;
                }
                case PENDING: 
                case STARTED: 
                case RUNNING: 
                case SUSPENDED: 
                case UNKNOWN: {
                    this.changeJobState(JobAttributes.State.TERMINATED);
                }
            }
            this.doExecutionCleanUp();
            throw throwable;
        }
        try {
            DebugUtil.trace(DebugUtil.RTS_JOB_TRACING_MORE, "RTS job #{0}: handle before execution", this.jobID);
            this.doBeforeExecution();
        }
        catch (CoreException e) {
            this.changeJobState(JobAttributes.State.ERROR);
            Status status = new Status(4, ToolsRMPlugin.getDefault().getBundle().getSymbolicName(), Messages.AbstractToolRuntimeSystemJob_Exception_BeforeExecution, (Throwable)e);
            DebugUtil.trace(DebugUtil.RTS_JOB_TRACING_MORE, "RTS job #{0}: cleanup", this.jobID);
            IPJob ipJob = PTPCorePlugin.getDefault().getUniverse().getResourceManager(this.rtSystem.getRmID()).getQueueById(this.getQueueID()).getJobById(this.getJobID());
            switch (ipJob.getState()) {
                case TERMINATED: 
                case ERROR: {
                    break;
                }
                case PENDING: 
                case STARTED: 
                case RUNNING: 
                case SUSPENDED: 
                case UNKNOWN: {
                    this.changeJobState(JobAttributes.State.TERMINATED);
                }
            }
            this.doExecutionCleanUp();
            return status;
        }
        try {
            IRemoteProcessBuilder processBuilder = this.rtSystem.createProcessBuilder(command, directory);
            processBuilder.environment().putAll(environment);
            DebugUtil.trace(DebugUtil.RTS_JOB_TRACING_MORE, "RTS job #{0}: start", this.jobID);
            this.process = processBuilder.start();
        }
        catch (IOException e) {
            this.changeJobState(JobAttributes.State.ERROR);
            Status status = new Status(4, ToolsRMPlugin.getDefault().getBundle().getSymbolicName(), Messages.AbstractToolRuntimeSystemJob_Exception_ExecuteCommand, (Throwable)e);
            DebugUtil.trace(DebugUtil.RTS_JOB_TRACING_MORE, "RTS job #{0}: cleanup", this.jobID);
            IPJob ipJob = PTPCorePlugin.getDefault().getUniverse().getResourceManager(this.rtSystem.getRmID()).getQueueById(this.getQueueID()).getJobById(this.getJobID());
            switch (ipJob.getState()) {
                case TERMINATED: 
                case ERROR: {
                    break;
                }
                case PENDING: 
                case STARTED: 
                case RUNNING: 
                case SUSPENDED: 
                case UNKNOWN: {
                    this.changeJobState(JobAttributes.State.TERMINATED);
                }
            }
            this.doExecutionCleanUp();
            return status;
        }
        try {
            DebugUtil.trace(DebugUtil.RTS_JOB_TRACING_MORE, "RTS job #{0}: handle start", this.jobID);
            this.doExecutionStarted();
        }
        catch (CoreException e) {
            this.changeJobState(JobAttributes.State.ERROR);
            Status status = new Status(4, ToolsRMPlugin.getDefault().getBundle().getSymbolicName(), Messages.AbstractToolRuntimeSystemJob_Exception_ExecutionStarted, (Throwable)e);
            DebugUtil.trace(DebugUtil.RTS_JOB_TRACING_MORE, "RTS job #{0}: cleanup", this.jobID);
            IPJob ipJob = PTPCorePlugin.getDefault().getUniverse().getResourceManager(this.rtSystem.getRmID()).getQueueById(this.getQueueID()).getJobById(this.getJobID());
            switch (ipJob.getState()) {
                case TERMINATED: 
                case ERROR: {
                    break;
                }
                case PENDING: 
                case STARTED: 
                case RUNNING: 
                case SUSPENDED: 
                case UNKNOWN: {
                    this.changeJobState(JobAttributes.State.TERMINATED);
                }
            }
            this.doExecutionCleanUp();
            return status;
        }
        this.changeJobState(JobAttributes.State.RUNNING);
        try {
            DebugUtil.trace(DebugUtil.RTS_JOB_TRACING_MORE, "RTS job #{0}: wait to finish", this.jobID);
            this.doWaitExecution();
        }
        catch (CoreException e) {
            this.changeJobState(JobAttributes.State.ERROR);
            Status status = new Status(4, ToolsRMPlugin.getDefault().getBundle().getSymbolicName(), Messages.AbstractToolRuntimeSystemJob_Exception_WaitExecution, (Throwable)e);
            DebugUtil.trace(DebugUtil.RTS_JOB_TRACING_MORE, "RTS job #{0}: cleanup", this.jobID);
            IPJob ipJob = PTPCorePlugin.getDefault().getUniverse().getResourceManager(this.rtSystem.getRmID()).getQueueById(this.getQueueID()).getJobById(this.getJobID());
            switch (ipJob.getState()) {
                case TERMINATED: 
                case ERROR: {
                    break;
                }
                case PENDING: 
                case STARTED: 
                case RUNNING: 
                case SUSPENDED: 
                case UNKNOWN: {
                    this.changeJobState(JobAttributes.State.TERMINATED);
                }
            }
            this.doExecutionCleanUp();
            return status;
        }
        DebugUtil.trace(DebugUtil.RTS_JOB_TRACING, "RTS job #{0}: exit value {1}", this.jobID, this.process.exitValue());
        try {
            DebugUtil.trace(DebugUtil.RTS_JOB_TRACING_MORE, "RTS job #{0}: handle finish", this.jobID);
            this.doExecutionFinished();
        }
        catch (CoreException e) {
            this.changeJobState(JobAttributes.State.ERROR);
            Status status = new Status(4, ToolsRMPlugin.getDefault().getBundle().getSymbolicName(), Messages.AbstractToolRuntimeSystemJob_Exception_ExecutionFinished, (Throwable)e);
            DebugUtil.trace(DebugUtil.RTS_JOB_TRACING_MORE, "RTS job #{0}: cleanup", this.jobID);
            IPJob ipJob = PTPCorePlugin.getDefault().getUniverse().getResourceManager(this.rtSystem.getRmID()).getQueueById(this.getQueueID()).getJobById(this.getJobID());
            switch (ipJob.getState()) {
                case TERMINATED: 
                case ERROR: {
                    break;
                }
                case PENDING: 
                case STARTED: 
                case RUNNING: 
                case SUSPENDED: 
                case UNKNOWN: {
                    this.changeJobState(JobAttributes.State.TERMINATED);
                }
            }
            this.doExecutionCleanUp();
            return status;
        }
        this.changeJobState(JobAttributes.State.TERMINATED);
        Status status = new Status(0, ToolsRMPlugin.getDefault().getBundle().getSymbolicName(), NLS.bind((String)Messages.AbstractToolRuntimeSystemJob_Success, (Object)this.process.exitValue()));
        DebugUtil.trace(DebugUtil.RTS_JOB_TRACING_MORE, "RTS job #{0}: cleanup", this.jobID);
        IPJob ipJob = PTPCorePlugin.getDefault().getUniverse().getResourceManager(this.rtSystem.getRmID()).getQueueById(this.getQueueID()).getJobById(this.getJobID());
        switch (ipJob.getState()) {
            case TERMINATED: 
            case ERROR: {
                break;
            }
            case PENDING: 
            case STARTED: 
            case RUNNING: 
            case SUSPENDED: 
            case UNKNOWN: {
                this.changeJobState(JobAttributes.State.TERMINATED);
            }
        }
        this.doExecutionCleanUp();
        return status;
    }

    protected abstract void doPrepareExecution() throws CoreException;

    protected abstract void doExecutionCleanUp();

    protected abstract void doWaitExecution() throws CoreException;

    protected abstract void doExecutionFinished() throws CoreException;

    protected abstract void doExecutionStarted() throws CoreException;

    protected abstract void doBeforeExecution() throws CoreException;

    protected abstract void doTerminateJob();

    protected void changeJobState(JobAttributes.State newState) {
        EnumeratedAttribute state = JobAttributes.getStateAttributeDefinition().create((Enum)newState);
        AttributeManager attrManager = new AttributeManager();
        attrManager.addAttribute((IAttribute)state);
        this.rtSystem.changeJob(this.jobID, attrManager);
    }

    protected String retrieveWorkingDirectory(AttributeManager baseSubstitutionAttributeManager) {
        String newWorkdir;
        String workdir = ((StringAttribute)this.attrMgr.getAttribute((IAttributeDefinition)JobAttributes.getWorkingDirectoryAttributeDefinition())).getValue();
        if (!workdir.equals(newWorkdir = this.replaceVariables(workdir, baseSubstitutionAttributeManager))) {
            DebugUtil.trace(DebugUtil.RTS_JOB_TRACING_MORE, "Changed work directory from {0} to {1}", workdir, newWorkdir);
            workdir = newWorkdir;
        }
        return workdir;
    }

    protected Map<String, String> retrieveEnvironment(AttributeManager baseSubstitutionAttributeManager) throws CoreException {
        HashMap<String, String> environmentMap = new HashMap<String, String>();
        this.retrieveEnvironmentFromAttrMrg(environmentMap);
        HashMap<String, String> extraEnvironmentMap = this.doRetrieveToolEnvironment();
        if (extraEnvironmentMap != null) {
            environmentMap.putAll(extraEnvironmentMap);
        }
        for (Map.Entry<String, String> env : environmentMap.entrySet()) {
            String newValue;
            String value = env.getValue();
            if (value.equals(newValue = this.replaceVariables(value, baseSubstitutionAttributeManager))) continue;
            DebugUtil.trace(DebugUtil.RTS_JOB_TRACING_MORE, "Changed environment '{0}={1}' to '{0}={2}", env.getKey(), value, newValue);
            env.setValue(newValue);
        }
        return environmentMap;
    }

    protected abstract HashMap<String, String> doRetrieveToolEnvironment() throws CoreException;

    private void retrieveEnvironmentFromAttrMrg(HashMap<String, String> environmentMap) {
        ArrayAttribute environmentAttribute = (ArrayAttribute)this.getAttrMgr().getAttribute((IAttributeDefinition)JobAttributes.getEnvironmentAttributeDefinition());
        if (environmentAttribute != null) {
            List environment = environmentAttribute.getValue();
            for (String entry : environment) {
                int i = entry.indexOf(61);
                String key = entry.substring(0, i);
                String value = entry.substring(i + 1);
                environmentMap.put(key, value);
            }
        }
    }

    protected AttributeManager retrieveBaseSubstitutionAttributes() throws CoreException {
        AttributeManager newAttributeManager = new AttributeManager(this.getAttrMgr().getAttributes());
        IAttributeDefinition<?, ?, ?>[] iAttributeDefinitionArray = this.getDefaultSubstitutionAttributes();
        int n = iAttributeDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttributeDefinition<?, ?, ?> attributeDefinition = iAttributeDefinitionArray[n2];
            IAttribute attribute = newAttributeManager.getAttribute(attributeDefinition.getId());
            if (attribute == null) {
                try {
                    newAttributeManager.addAttribute(attributeDefinition.create());
                }
                catch (IllegalValueException e) {
                    throw new CoreException((IStatus)new Status(4, ToolsRMPlugin.getDefault().getBundle().getSymbolicName(), NLS.bind((String)Messages.AbstractToolRuntimeSystemJob_Exception_DefaultAttributeValue, (Object)attributeDefinition.getName()), (Throwable)e));
                }
            }
            ++n2;
        }
        IAttribute<?, ?, ?>[] extraAttributes = this.doRetrieveToolBaseSubstitutionAttributes();
        if (extraAttributes != null) {
            newAttributeManager.addAttributes(extraAttributes);
        }
        return newAttributeManager;
    }

    protected abstract IAttribute<?, ?, ?>[] doRetrieveToolBaseSubstitutionAttributes() throws CoreException;

    protected IAttributeDefinition<?, ?, ?>[] getDefaultSubstitutionAttributes() {
        return new IAttributeDefinition[]{JobAttributes.getEnvironmentAttributeDefinition(), JobAttributes.getExecutableNameAttributeDefinition(), JobAttributes.getExecutablePathAttributeDefinition(), JobAttributes.getJobIdAttributeDefinition(), JobAttributes.getNumberOfProcessesAttributeDefinition(), JobAttributes.getProgramArgumentsAttributeDefinition(), JobAttributes.getQueueIdAttributeDefinition(), JobAttributes.getSubIdAttributeDefinition(), JobAttributes.getUserIdAttributeDefinition(), JobAttributes.getWorkingDirectoryAttributeDefinition()};
    }

    protected final AttributeManager retrieveCommandSubstitutionAttributes(AttributeManager baseSubstitutionAttributeManager, String directory, Map<String, String> environment) {
        AttributeManager newAttributeManager = new AttributeManager(baseSubstitutionAttributeManager.getAttributes());
        IAttribute<?, ?, ?>[] extraAttributes = this.doRetrieveToolCommandSubstitutionAttributes(baseSubstitutionAttributeManager, directory, environment);
        if (extraAttributes != null) {
            newAttributeManager.addAttributes(extraAttributes);
        }
        return newAttributeManager;
    }

    protected abstract IAttribute<?, ?, ?>[] doRetrieveToolCommandSubstitutionAttributes(AttributeManager var1, String var2, Map<String, String> var3);

    protected List<String> retrieveCreateLaunchCommand(AttributeManager substitutionAttributeManager) throws CoreException {
        AbstractEffectiveTollRMConfiguration effectiveConfiguration = this.getRtSystem().retrieveEffectiveToolRmConfiguration();
        List<String> command = new ArrayList<String>();
        if (!effectiveConfiguration.hasLaunchCmd()) {
            StringAttribute execPath = (StringAttribute)this.getAttrMgr().getAttribute((IAttributeDefinition)JobAttributes.getExecutablePathAttributeDefinition());
            ArrayAttribute arguments = (ArrayAttribute)this.getAttrMgr().getAttribute((IAttributeDefinition)JobAttributes.getProgramArgumentsAttributeDefinition());
            command.add(execPath.getValue());
            command.addAll(arguments.getValue());
        } else {
            String launchCommand = effectiveConfiguration.getLaunchCmd();
            Assert.isNotNull((Object)launchCommand);
            Assert.isTrue((launchCommand.trim().length() > 0 ? 1 : 0) != 0);
            launchCommand = this.replaceVariables(launchCommand, substitutionAttributeManager);
            ArgumentParser argumentParser = new ArgumentParser(launchCommand);
            command = argumentParser.getTokenList();
        }
        return command;
    }

    protected List<String> retrieveCreateDebugCommand(AttributeManager substitutionAttributeManager) throws CoreException {
        AbstractEffectiveTollRMConfiguration effectiveConfiguration = this.getRtSystem().retrieveEffectiveToolRmConfiguration();
        List<String> command = new ArrayList<String>();
        if (!effectiveConfiguration.hasDebugCmd()) {
            StringAttribute execPath = (StringAttribute)this.getAttrMgr().getAttribute((IAttributeDefinition)JobAttributes.getExecutablePathAttributeDefinition());
            ArrayAttribute arguments = (ArrayAttribute)this.getAttrMgr().getAttribute((IAttributeDefinition)JobAttributes.getProgramArgumentsAttributeDefinition());
            command.add(execPath.getValue());
            command.addAll(arguments.getValue());
        } else {
            String debugCommand = effectiveConfiguration.getDebugCmd();
            Assert.isNotNull((Object)debugCommand);
            Assert.isTrue((debugCommand.trim().length() > 0 ? 1 : 0) != 0);
            debugCommand = this.replaceVariables(debugCommand, substitutionAttributeManager);
            ArgumentParser argumentParser = new ArgumentParser(debugCommand);
            command = argumentParser.getTokenList();
        }
        return command;
    }

    protected String replaceVariables(String input, AttributeManager substitutionAttributeManager) {
        StringBuffer output = new StringBuffer();
        Matcher matcher = variablePattern.matcher(input);
        int lastPos = 0;
        while (matcher.find()) {
            int startPos = matcher.start();
            int endPos = matcher.end();
            String name = matcher.group(1);
            String parameterList = matcher.group(2);
            String variable = matcher.group();
            output.append(input.substring(lastPos, startPos));
            String resolvedValue = null;
            IAttribute attribute = substitutionAttributeManager.getAttribute(name);
            if (attribute != null) {
                if (attribute instanceof ArrayAttribute) {
                    String optStartStr = "";
                    String optEndStr = "";
                    String startStr = "";
                    String endStr = "";
                    String separatorStr = " ";
                    Matcher paramMatcher = parameterPattern.matcher(parameterList);
                    if (paramMatcher.find()) {
                        startStr = paramMatcher.group(1);
                        if (paramMatcher.find()) {
                            separatorStr = paramMatcher.group(1);
                            if (paramMatcher.find()) {
                                endStr = paramMatcher.group(1);
                                if (paramMatcher.find()) {
                                    optStartStr = paramMatcher.group(1);
                                    if (paramMatcher.find()) {
                                        optEndStr = paramMatcher.group(1);
                                    }
                                }
                            }
                        }
                    }
                    ArrayAttribute array_attr = (ArrayAttribute)attribute;
                    StringBuffer buffer = new StringBuffer();
                    boolean first = true;
                    List array = array_attr.getValue();
                    if (array.size() > 0) {
                        buffer.append(optStartStr);
                    }
                    buffer.append(startStr);
                    for (Object element : array) {
                        if (first) {
                            first = false;
                        } else {
                            buffer.append(separatorStr);
                        }
                        assert (element != null);
                        buffer.append(element);
                    }
                    buffer.append(endStr);
                    if (array.size() > 0) {
                        buffer.append(optEndStr);
                    }
                    resolvedValue = buffer.toString();
                } else {
                    resolvedValue = attribute.getValueAsString();
                }
            }
            if (resolvedValue == null) {
                output.append(variable);
            } else {
                resolvedValue = this.replaceVariables(resolvedValue, substitutionAttributeManager);
                output.append(resolvedValue);
            }
            lastPos = endPos;
        }
        output.append(input.substring(lastPos));
        String result = output.toString();
        return result;
    }

    public void terminate() {
        this.terminateJobFlag = true;
        if (this.process != null) {
            this.process.destroy();
        }
        this.doTerminateJob();
    }

    protected void canceling() {
        this.terminate();
        super.canceling();
    }
}

