/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.ui.wizards;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPI12PreferenceManager;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPI13PreferenceManager;
import org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem.OpenMPIResourceManagerConfiguration;
import org.eclipse.ptp.rm.mpi.openmpi.ui.wizards.Messages;
import org.eclipse.ptp.rm.ui.utils.DataSource;
import org.eclipse.ptp.rm.ui.wizards.AbstractConfigurationWizardPage;
import org.eclipse.ptp.rm.ui.wizards.AbstractToolRMConfigurationWizardPage;
import org.eclipse.ptp.rm.ui.wizards.WizardPageDataSource;
import org.eclipse.ptp.rm.ui.wizards.WizardPageWidgetListener;
import org.eclipse.ptp.rmsystem.IResourceManagerConfiguration;
import org.eclipse.ptp.ui.wizards.RMConfigurationWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class OpenMPIConfigurationWizardPage
extends AbstractToolRMConfigurationWizardPage {
    String[] versionIds = new String[]{"openmpi-1.2", "openmpi-1.3"};
    String[] versionsNames = new String[]{Messages.OpenMPIConfigurationWizardPage_VersionCombo_Version12, Messages.OpenMPIConfigurationWizardPage_VersionCombo_Version13};
    protected Combo versionCombo;

    protected WizardPageWidgetListener createListener() {
        return new WidgetListener();
    }

    protected WizardPageDataSource createDataSource() {
        return new DataSource((AbstractConfigurationWizardPage)this);
    }

    public OpenMPIConfigurationWizardPage(RMConfigurationWizard wizard) {
        super(wizard, OpenMPIResourceManagerConfiguration.OPENMPI_CAPABILITIES, Messages.OpenMPIConfigurationWizardPage_Name, Messages.OpenMPIConfigurationWizardPage_Title, Messages.OpenMPIConfigurationWizardPage_Description);
    }

    protected Composite doCreateContents(Composite parent) {
        Composite contents = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        contents.setLayout((Layout)layout);
        this.createVersionContents(contents);
        this.createOpenMPIContents(contents);
        return contents;
    }

    protected void createVersionContents(Composite parent) {
        Composite contents = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        contents.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        contents.setLayoutData((Object)gd);
        Label label = new Label(contents, 0);
        label.setText(Messages.OpenMPIConfigurationWizardPage_Label_Version);
        this.versionCombo = new Combo(contents, 12);
        int i = 0;
        while (i < this.versionsNames.length) {
            this.versionCombo.add(this.versionsNames[i]);
            ++i;
        }
        this.versionCombo.addSelectionListener((SelectionListener)this.getWidgetListener());
    }

    public void handleVersionSelected() {
        this.getWidgetListener().disable();
        DataSource dataSource = (DataSource)this.getDataSource();
        dataSource.justValidate();
        String launchCmd = null;
        String debugCmd = null;
        String discoverCmd = null;
        if (dataSource.getVersionId().equals("openmpi-1.2")) {
            Preferences preferences = OpenMPI12PreferenceManager.getPreferences();
            launchCmd = preferences.getString("openmpi-1.2-launchCmd");
            debugCmd = preferences.getString("openmpi-1.2-debugCmd");
            discoverCmd = preferences.getString("openmpi-1.2-discoverCmd");
            preferences.getString("openmpi-1.2-remoteInstallPAth");
        } else if (dataSource.getVersionId().equals("openmpi-1.3")) {
            Preferences preferences = OpenMPI13PreferenceManager.getPreferences();
            launchCmd = preferences.getString("openmpi-1.3-launchCmd");
            debugCmd = preferences.getString("openmpi-1.3-debugCmd");
            discoverCmd = preferences.getString("openmpi-1.3-discoverCmd");
            preferences.getString("openmpi-1.3-remoteInstallPAth");
        } else assert (false);
        this.resetErrorMessages();
        dataSource.setCommandFields(launchCmd, debugCmd, discoverCmd, null, 0, null, dataSource.getRemoteInstallPath());
        dataSource.setUseDefaults(true);
        dataSource.copyToFields();
        this.getWidgetListener().enable();
    }

    protected class DataSource
    extends AbstractToolRMConfigurationWizardPage.DataSource {
        private OpenMPIResourceManagerConfiguration config;
        private String versionId;

        protected DataSource(AbstractConfigurationWizardPage page) {
            super((AbstractToolRMConfigurationWizardPage)OpenMPIConfigurationWizardPage.this, page);
            this.versionId = null;
        }

        public String getVersionId() {
            return this.versionId;
        }

        protected void copyFromFields() throws DataSource.ValidationException {
            if (OpenMPIConfigurationWizardPage.this.versionCombo.getSelectionIndex() == -1) {
                OpenMPIConfigurationWizardPage.this.versionIds = null;
            } else {
                this.versionId = OpenMPIConfigurationWizardPage.this.versionIds[OpenMPIConfigurationWizardPage.this.versionCombo.getSelectionIndex()];
            }
            super.copyFromFields();
        }

        protected void copyToFields() {
            if (this.versionId == null) {
                OpenMPIConfigurationWizardPage.this.versionCombo.select(-1);
            } else {
                int i = 0;
                while (i < OpenMPIConfigurationWizardPage.this.versionIds.length) {
                    if (this.versionId.equals(OpenMPIConfigurationWizardPage.this.versionIds[i])) {
                        OpenMPIConfigurationWizardPage.this.versionCombo.select(i);
                    }
                    ++i;
                }
            }
            super.copyToFields();
        }

        protected void loadFromStorage() {
            this.versionId = this.config.getVersionId();
            super.loadFromStorage();
        }

        protected void copyToStorage() {
            this.config.setVersionId(this.versionId);
            super.copyToStorage();
        }

        protected void validateLocal() throws DataSource.ValidationException {
            if (this.versionId == null) {
                throw new DataSource.ValidationException((org.eclipse.ptp.rm.ui.utils.DataSource)this, Messages.OpenMPIConfigurationWizardPage_Validation_NoVersionSelected);
            }
            super.validateLocal();
        }

        public void setConfig(IResourceManagerConfiguration configuration) {
            this.config = (OpenMPIResourceManagerConfiguration)configuration;
            super.setConfig(configuration);
        }
    }

    protected class WidgetListener
    extends AbstractToolRMConfigurationWizardPage.WidgetListener {
        protected WidgetListener() {
            super((AbstractToolRMConfigurationWizardPage)OpenMPIConfigurationWizardPage.this);
        }

        protected void doModifyText(ModifyEvent evt) {
            super.doModifyText(evt);
        }

        public void doWidgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == OpenMPIConfigurationWizardPage.this.versionCombo) {
                OpenMPIConfigurationWizardPage.this.handleVersionSelected();
                OpenMPIConfigurationWizardPage.this.updateControls();
                OpenMPIConfigurationWizardPage.this.getDataSource().storeAndValidate();
            } else {
                super.doWidgetSelected(e);
            }
        }
    }
}

