/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.sputiming.core;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.cell.sputiming.debug.Debug;
import org.eclipse.ptp.cell.sputiming.extension.ISPUTimingObserver;
import org.eclipse.ptp.utils.core.extensionpoints.ExtensionPointEnumeration;

public class ExternalTools {
    public static void callExtensions(final IPath file) {
        ExtensionPointEnumeration epe = new ExtensionPointEnumeration("org.eclipse.ptp.cell.sputiming.observerpoint");
        Debug.read();
        Debug.POLICY.trace(Debug.DEBUG_VISUALIZATION, "Start notifying visualization extension points.");
        while (epe.hasMoreElements()) {
            final IConfigurationElement ice = (IConfigurationElement)epe.nextElement();
            Debug.POLICY.trace(Debug.DEBUG_VISUALIZATION, "name:{0} class:{1} valid:{2}", new Object[]{ice.getName(), ice.getAttribute("class"), ice.isValid()});
            Job job = new Job(MessageFormat.format("Sputiming extension: {0}", ice.getName())){

                protected IStatus run(IProgressMonitor monitor) {
                    Object beholderWOType = null;
                    try {
                        beholderWOType = ice.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        Debug.POLICY.error(Debug.DEBUG_VISUALIZATION, "Failed to load class for extension point: {0}; reason: {1}", new Object[]{ice.getName(), e.getMessage()});
                        return e.getStatus();
                    }
                    Debug.POLICY.trace(Debug.DEBUG_VISUALIZATION, "Start notifying {0}.", new Object[]{ice.getName()});
                    final ISPUTimingObserver spubeholder = (ISPUTimingObserver)beholderWOType;
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            Debug.POLICY.error(Debug.DEBUG_VISUALIZATION, "Failed to execute extension point: {0}; reason: {1}", new Object[]{ice.getName(), exception.getMessage()});
                        }

                        public void run() throws Exception {
                            spubeholder.afterFileGeneration(file);
                        }
                    });
                    Debug.POLICY.trace(Debug.DEBUG_VISUALIZATION, "Finished notifying {0}.", new Object[]{ice.getName()});
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.setPriority(30);
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        Debug.POLICY.trace(Debug.DEBUG_VISUALIZATION, "Finished notifying visualization extension points.");
    }
}

