/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.core.elements;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.core.attributes.EnumeratedAttribute;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.elementcontrols.IPElementControl;
import org.eclipse.ptp.core.elementcontrols.IPJobControl;
import org.eclipse.ptp.core.elementcontrols.IPQueueControl;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.core.elements.IPJob;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.core.elements.attributes.QueueAttributes;
import org.eclipse.ptp.core.elements.listeners.IQueueChildListener;
import org.eclipse.ptp.core.elements.listeners.IQueueListener;
import org.eclipse.ptp.internal.core.elements.Parent;
import org.eclipse.ptp.internal.core.elements.events.ChangedJobEvent;
import org.eclipse.ptp.internal.core.elements.events.NewJobEvent;
import org.eclipse.ptp.internal.core.elements.events.QueueChangeEvent;
import org.eclipse.ptp.internal.core.elements.events.RemoveJobEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PQueue
extends Parent
implements IPQueueControl {
    private final ListenerList elementListeners = new ListenerList();
    private final ListenerList childListeners = new ListenerList();

    public PQueue(String id, IResourceManagerControl rm, IAttribute<?, ?, ?>[] attrs) {
        super(id, rm, 16, attrs);
        IAttribute queueState = (EnumeratedAttribute)this.getAttribute(QueueAttributes.getStateAttributeDefinition());
        if (queueState == null) {
            queueState = QueueAttributes.getStateAttributeDefinition().create();
            this.addAttribute(queueState);
        }
    }

    @Override
    public void addChildListener(IQueueChildListener listener) {
        this.childListeners.add((Object)listener);
    }

    @Override
    public void addElementListener(IQueueListener listener) {
        this.elementListeners.add((Object)listener);
    }

    @Override
    public void addJobAttributes(Collection<IPJobControl> jobControls, IAttribute<?, ?, ?>[] attrs) {
        ArrayList<IPJob> jobs = new ArrayList<IPJob>(jobControls.size());
        for (IPJobControl job : jobControls) {
            job.addAttributes(attrs);
            jobs.add(job);
        }
        this.fireChangedJobs(jobs);
    }

    @Override
    public void addJobs(Collection<IPJobControl> jobControls) {
        ArrayList<IPJob> jobs = new ArrayList<IPJob>(jobControls.size());
        for (IPJobControl job : jobControls) {
            this.addChild(job);
            jobs.add(job);
        }
        this.fireNewJobs(jobs);
    }

    @Override
    public IPJob getJobById(String job_id) {
        return this.getJobControl(job_id);
    }

    @Override
    public IPJobControl getJobControl(String job_id) {
        IPElementControl element = this.findChild(job_id);
        if (element != null) {
            return (IPJobControl)element;
        }
        return null;
    }

    @Override
    public Collection<IPJobControl> getJobControls() {
        IPElementControl[] children = this.getChildren();
        ArrayList<IPJobControl> jobs = new ArrayList<IPJobControl>(children.length);
        IPElementControl[] iPElementControlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IPElementControl element = iPElementControlArray[n2];
            jobs.add((IPJobControl)element);
            ++n2;
        }
        return jobs;
    }

    @Override
    public IPJob[] getJobs() {
        Collection<IPJobControl> jobs = this.getJobControls();
        return jobs.toArray(new IPJobControl[jobs.size()]);
    }

    @Override
    public IResourceManager getResourceManager() {
        return (IResourceManager)((Object)this.getParent());
    }

    @Override
    public QueueAttributes.State getState() {
        return (QueueAttributes.State)((Object)((EnumeratedAttribute)this.getAttribute(QueueAttributes.getStateAttributeDefinition())).getValue());
    }

    @Override
    public void removeChildListener(IQueueChildListener listener) {
        this.childListeners.remove((Object)listener);
    }

    @Override
    public void removeElementListener(IQueueListener listener) {
        this.elementListeners.remove((Object)listener);
    }

    @Override
    public void removeJobs(Collection<IPJobControl> jobControls) {
        ArrayList<IPJob> jobs = new ArrayList<IPJob>(jobControls.size());
        for (IPJobControl job : jobControls) {
            job.removeProcesses(job.getProcessControls());
            this.removeChild(job);
            jobs.add(job);
        }
        this.fireRemoveJobs(jobs);
    }

    private void fireChangedJobs(Collection<IPJob> jobs) {
        ChangedJobEvent e = new ChangedJobEvent(this, jobs);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IQueueChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireChangedQueue(AttributeManager attrs) {
        QueueChangeEvent e = new QueueChangeEvent(this, attrs);
        Object[] objectArray = this.elementListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IQueueListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireNewJobs(Collection<IPJob> jobs) {
        NewJobEvent e = new NewJobEvent(this, jobs);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IQueueChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    private void fireRemoveJobs(Collection<IPJob> jobs) {
        RemoveJobEvent e = new RemoveJobEvent(this, jobs);
        Object[] objectArray = this.childListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IQueueChildListener)listener).handleEvent(e);
            ++n2;
        }
    }

    @Override
    protected void doAddAttributeHook(AttributeManager attrs) {
        this.fireChangedQueue(attrs);
    }
}

