/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.internal;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ptp.perf.IPerformanceLaunchConfigurationConstants;
import org.eclipse.ptp.perf.internal.PerfStep;

public class PerfLauncher
extends PerfStep
implements IPerformanceLaunchConfigurationConstants {
    private static final boolean traceOn = false;
    private String progPath = null;
    private String application = null;
    private String saveApp = null;
    private String saveArgs = null;
    private boolean swappedArgs = false;
    private String appnameattrib = null;
    private String apppathattrib = null;
    private ILaunch launch = null;
    private LaunchConfigurationDelegate paraDel = null;

    public PerfLauncher(ILaunchConfiguration conf, String ana, String projnameatt, String apa, String progPath, LaunchConfigurationDelegate pd, ILaunch launcher) throws CoreException {
        super(conf, "Running Application", projnameatt);
        this.launch = launcher;
        this.paraDel = pd;
        this.appnameattrib = ana;
        this.apppathattrib = apa;
        this.progPath = progPath;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (!this.performLaunch(this.paraDel, this.launch, monitor)) {
                return new Status(2, "com.ibm.jdg2e.concurrency", 2, "Nothing to run", null);
            }
        }
        catch (Exception e) {
            try {
                this.cleanup();
            }
            catch (CoreException coreException) {}
            return new Status(4, "com.ibm.jdg2e.concurrency", 4, "Execution Error", (Throwable)e);
        }
        return new Status(0, "com.ibm.jdg2e.concurrency", 0, "Execution Complete", null);
    }

    public boolean performLaunch(LaunchConfigurationDelegate paraDel, ILaunch launch, IProgressMonitor monitor) throws Exception {
        if (this.tool == null) {
            throw new Exception("No valid tool configuration found");
        }
        ILaunchConfigurationWorkingCopy confWC = this.configuration.getWorkingCopy();
        this.application = confWC.getAttribute(this.appnameattrib, null);
        if (this.progPath != null) {
            confWC.setAttribute(this.appnameattrib, this.progPath);
            if (this.apppathattrib != null) {
                IFile path = this.thisProject.getFile(this.progPath);
                confWC.setAttribute(this.apppathattrib, path.getLocation().toString());
            }
        }
        if (this.tool.prependExecution) {
            String prog = confWC.getAttribute(this.appnameattrib, "");
            String arg = confWC.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", "");
            this.saveApp = prog;
            this.saveArgs = arg;
            if (this.tool.execUtils != null && this.tool.execUtils.length > 0) {
                String firstExecUtil = PerfLauncher.getToolExecutable(this.tool.execUtils[0]);
                File f = new File(firstExecUtil);
                if (firstExecUtil == null || !f.exists()) {
                    throw new Exception("Tool " + firstExecUtil + " not found");
                }
                confWC.setAttribute(this.appnameattrib, firstExecUtil);
                String otherUtils = this.getToolArguments(this.tool.execUtils[0], this.configuration);
                int i = 1;
                while (i < this.tool.execUtils.length) {
                    otherUtils = String.valueOf(otherUtils) + " " + this.getToolCommand(this.tool.execUtils[i], this.configuration);
                    ++i;
                }
                this.swappedArgs = true;
                confWC.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", String.valueOf(otherUtils) + " " + prog + " " + arg);
            }
        }
        this.configuration = confWC.doSave();
        paraDel.launch(this.configuration, "run", launch, monitor);
        while (!launch.isTerminated()) {
            if (monitor.isCanceled()) {
                launch.terminate();
                this.cleanup();
                throw new OperationCanceledException();
            }
            Thread.sleep(1000L);
        }
        System.out.println("Launch supposedly complete");
        return true;
    }

    public void cleanup() throws CoreException {
        ILaunchConfigurationWorkingCopy confWC = this.configuration.getWorkingCopy();
        if (this.tool.prependExecution && this.swappedArgs) {
            confWC.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", this.saveApp);
            confWC.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", this.saveArgs);
        }
        confWC.setAttribute(this.appnameattrib, this.application);
        this.configuration = confWC.doSave();
    }
}

