/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.internal;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.perf.AbstractPerformanceDataManager;
import org.eclipse.ptp.perf.Activator;
import org.eclipse.ptp.perf.IPerformanceLaunchConfigurationConstants;
import org.eclipse.ptp.perf.internal.BuildLaunchUtils;
import org.eclipse.ptp.perf.internal.PerfStep;

public class PerfPostlaunch
extends PerfStep
implements IPerformanceLaunchConfigurationConstants {
    String outputLocation;

    public PerfPostlaunch(ILaunchConfiguration conf, String projnameatt, String outLoc) throws CoreException {
        super(conf, "Analysis", projnameatt);
        this.outputLocation = outLoc;
    }

    public void postlaunch(IProgressMonitor monitor) throws CoreException {
        if (this.tool.analysisCommands != null && this.tool.analysisCommands.length > 0) {
            File projectLoc = new File(this.outputLocation);
            int i = 0;
            while (i < this.tool.analysisCommands.length) {
                if (this.tool.analysisCommands[i].toolGroup == null || !this.tool.analysisCommands[i].toolGroup.equals("internal")) {
                    String runTool = this.getToolCommand(this.tool.analysisCommands[i], this.configuration);
                    if (runTool != null) {
                        BuildLaunchUtils.runTool(runTool, null, projectLoc);
                    } else {
                        System.out.println("The command " + this.tool.analysisCommands[i].toolCommand + " could not be run because the application is not in your path.");
                    }
                } else {
                    AbstractPerformanceDataManager manager = Activator.getPerfDataManager(this.tool.analysisCommands[i].toolCommand);
                    if (manager != null) {
                        manager.process(this.thisCProject.getElementName(), this.configuration, this.outputLocation);
                    }
                }
                ++i;
            }
        }
        System.out.println("Postlaunch job done");
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.postlaunch(monitor);
        }
        catch (Exception e) {
            return new Status(4, "com.ibm.jdg2e.concurrency", 4, "Data Collection Error", (Throwable)e);
        }
        return new Status(0, "com.ibm.jdg2e.concurrency", 0, "Data Collected", null);
    }
}

