/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.perf.Activator;
import org.eclipse.ptp.perf.IPerformanceLaunchConfigurationConstants;
import org.eclipse.ptp.perf.internal.BuildLaunchUtils;
import org.eclipse.ptp.perf.toolopts.PerformanceTool;
import org.eclipse.ptp.perf.toolopts.ToolApp;
import org.eclipse.ptp.perf.toolopts.ToolIO;

public abstract class PerfStep
extends Job
implements IPerformanceLaunchConfigurationConstants {
    protected String projectLocation = null;
    protected ICProject thisCProject = null;
    protected IProject thisProject = null;
    protected ILaunchConfiguration configuration = null;
    protected final PerformanceTool tool;
    protected Map<String, String> IOMap = null;

    protected PerfStep(ILaunchConfiguration conf, String name, String projnameattrib) throws CoreException {
        super(name);
        this.configuration = conf;
        this.thisProject = PerfStep.getProject(projnameattrib, this.configuration);
        this.thisCProject = CCorePlugin.getDefault().getCoreModel().create(this.thisProject);
        this.projectLocation = this.thisCProject.getResource().getLocation().toOSString();
        this.IOMap = new HashMap<String, String>();
        this.tool = Activator.getTool(this.configuration.getAttribute("selected_performance_tool", null));
    }

    public void setConfiguration(ILaunchConfiguration conf) {
        this.configuration = conf;
    }

    public ILaunchConfiguration getConfiguration() {
        return this.configuration;
    }

    protected static IProject getProject(String projnameattrib, ILaunchConfiguration configuration) throws CoreException {
        String projectName = configuration.getAttribute(projnameattrib, null);
        if (projectName != null && (projectName = projectName.trim()).length() > 0) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return null;
    }

    protected String getToolArguments(ToolApp app, ILaunchConfiguration configuration) throws CoreException {
        if (app == null) {
            return "";
        }
        String allargs = String.valueOf(app.getArguments(configuration).replaceAll("replace_this_string_with_the_project_path", this.projectLocation)) + this.parseInput(app) + " " + this.parseOutput(app);
        return allargs;
    }

    private String parseInput(ToolApp app) {
        String input = "";
        String oneIn = "";
        if (app.inputArgs != null) {
            int i = 0;
            while (i < app.inputArgs.length) {
                oneIn = "";
                if (app.inputArgs[i].pathFlag != null) {
                    oneIn = String.valueOf(oneIn) + app.inputArgs[i].pathFlag + " ";
                }
                if (!this.IOMap.containsKey(app.inputArgs[i].ID)) {
                    return "";
                }
                input = String.valueOf(input) + this.IOMap.get(app.inputArgs[i].ID);
                ++i;
            }
        }
        return input;
    }

    private String parseOutput(ToolApp app) {
        String output = "";
        if (app.outputArgs != null) {
            int i = 0;
            while (i < app.outputArgs.length) {
                if (app.outputArgs[i].pathFlag != null) {
                    output = String.valueOf(output) + app.outputArgs[i].pathFlag + " ";
                }
                output = this.IOMap.containsKey(app.outputArgs[i].ID) ? String.valueOf(output) + this.IOMap.get(app.outputArgs[i].ID) : String.valueOf(output) + this.createOutputPath(app.outputArgs[i]);
                ++i;
            }
        }
        return output;
    }

    private String createOutputPath(ToolIO IO) {
        String opath = String.valueOf(this.projectLocation) + File.separator + IO.ID + File.separator + BuildLaunchUtils.getNow();
        File ofile = new File(opath);
        ofile.mkdirs();
        this.IOMap.put(IO.ID, opath);
        return opath;
    }

    protected static String getToolExecutable(ToolApp app) {
        String command = app.toolCommand;
        String toolPath = BuildLaunchUtils.getToolPath(app.toolGroup);
        if (toolPath != null) {
            command = String.valueOf(toolPath) + File.separator + command;
        }
        return command;
    }

    protected String getToolCommand(ToolApp app, ILaunchConfiguration configuration) throws CoreException {
        String command = PerfStep.getToolExecutable(app);
        if (command == null) {
            return null;
        }
        return String.valueOf(command) + " " + this.getToolArguments(app, configuration);
    }
}

