/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ptp.perf.internal.PerfBuilder;
import org.eclipse.ptp.perf.internal.PerfLauncher;
import org.eclipse.ptp.perf.internal.PerfPostlaunch;

public class PerformanceLaunchManager {
    protected static final String buildText = "Instrumenting and Building";
    protected static final String launchText = "Executing Instrumented Project";
    protected static final String collectText = "Collecting Performance Data";
    protected String appNameAttribute;
    protected String projNameAttribute;
    protected String appPathAttribute = null;
    protected LaunchConfigurationDelegate paraDel;

    public PerformanceLaunchManager(LaunchConfigurationDelegate delegate, String appNameAtt, String projNameAtt) {
        this.paraDel = delegate;
        this.appNameAttribute = appNameAtt;
        this.projNameAttribute = projNameAtt;
    }

    public PerformanceLaunchManager(LaunchConfigurationDelegate delegate, String appNameAtt, String projNameAtt, String appPathAtt) {
        this.paraDel = delegate;
        this.appNameAttribute = appNameAtt;
        this.appPathAttribute = appPathAtt;
        this.projNameAttribute = projNameAtt;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launchIn, IProgressMonitor monitor) throws CoreException {
        ILaunch launch = launchIn;
        PerfBuilder builder = new PerfBuilder(configuration, this.projNameAttribute, this.appPathAttribute);
        builder.schedule();
        try {
            builder.join();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        if (!builder.getResult().isOK()) {
            return;
        }
        PerfLauncher launcher = new PerfLauncher(configuration, this.appNameAttribute, this.projNameAttribute, this.appPathAttribute, builder.getProgramPath(), this.paraDel, launch);
        launcher.schedule();
        try {
            launcher.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (!launcher.getResult().isOK()) {
            return;
        }
        PerfPostlaunch analyzer = new PerfPostlaunch(configuration, this.projNameAttribute, builder.getOutputLocation());
        analyzer.schedule();
    }
}

