/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remotetools.internal.ssh;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.remotetools.internal.core.ConnectionProperties;
import org.eclipse.ptp.remotetools.internal.ssh.Connection;
import org.eclipse.ptp.remotetools.internal.ssh.KillableExecution;
import org.eclipse.ptp.remotetools.internal.ssh.Messages;

class ExecutionObserver
extends Job {
    int inactivity;
    Connection connection;

    public ExecutionObserver(Connection connection) {
        super(Messages.ExecutionObserver_ExecutionObserver_RemoteCommandObserver);
        this.connection = connection;
    }

    public void newCommand() {
        this.inactivity = 0;
        this.schedule(ConnectionProperties.fastDutyCycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        Connection connection = this.connection;
        synchronized (connection) {
            Iterator operationEnum = this.connection.activeProcessTable.entrySet().iterator();
            while (operationEnum.hasNext()) {
                KillableExecution operation;
                Map.Entry o = operationEnum.next();
                Map.Entry e = o;
                if (!(e.getValue() instanceof KillableExecution) || (operation = (KillableExecution)e.getValue()).isRunning()) continue;
                operationEnum.remove();
                operation.notifyFinish();
                this.inactivity = 0;
            }
            if (this.connection.activeProcessTable.size() > 0) {
                if (this.inactivity > ConnectionProperties.inactivityThreashold) {
                    this.schedule(ConnectionProperties.longDutyCycle);
                } else {
                    this.schedule(ConnectionProperties.fastDutyCycle);
                    ++this.inactivity;
                }
            }
        }
        return Status.OK_STATUS;
    }
}

