/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.managedbuilder.gnu.core.preferences;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.cell.managedbuilder.gnu.core.debug.Debug;
import org.eclipse.ptp.cell.managedbuilder.gnu.core.preferences.GnuToolsProperties;
import org.eclipse.ptp.cell.preferences.core.SearcherMessages;
import org.eclipse.ptp.cell.preferences.core.StringFieldEditorPreferenceSearcher;
import org.eclipse.ptp.cell.utils.linux.findutils.Find;
import org.eclipse.ptp.cell.utils.linux.which.Which;
import org.eclipse.ptp.cell.utils.packagemanager.PackageManagementSystemManager;
import org.eclipse.ptp.cell.utils.searcher.SearchFailedException;
import org.eclipse.swt.widgets.Composite;

public class GnuToolsSearcher
extends StringFieldEditorPreferenceSearcher {
    public GnuToolsSearcher(StringFieldEditor stringFieldEditor, Composite parent) {
        super(stringFieldEditor, parent);
    }

    protected void fastSearch() throws SearchFailedException {
        String gnuToolsPath;
        String currentPreferenceValue = this.stringFieldEditor.getStringValue();
        if (this.isValidGNUToolsDirectory(currentPreferenceValue)) {
            Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Current value is valid");
            return;
        }
        String defaultPreferenceValue = this.preferenceStore.getDefaultString(this.preferenceName);
        if (!currentPreferenceValue.equals(defaultPreferenceValue) && this.isValidGNUToolsDirectory(defaultPreferenceValue)) {
            Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Default value is valid");
            this.setText(defaultPreferenceValue);
            return;
        }
        if (Platform.getOS().equals("linux") && this.isValidGNUToolsDirectory(gnuToolsPath = new Path(Which.which((String)GnuToolsProperties.ppugccExecutable)).removeLastSegments(1).toOSString())) {
            Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Value returned from 'which' is valid");
            this.setText(gnuToolsPath);
            return;
        }
        gnuToolsPath = PackageManagementSystemManager.getPackageManager().searchFileInQueryListAndReturnInitialPathSegments(GnuToolsProperties.ppugccPackage, String.valueOf(File.separator) + GnuToolsProperties.ppugccExecutable);
        if (this.isValidGNUToolsDirectory(gnuToolsPath)) {
            Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Value returned from package management system is valid");
            this.setText(gnuToolsPath);
            return;
        }
        Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "All fast searches failed,");
        throw new SearchFailedException(SearcherMessages.fastSearchFailedMessage);
    }

    protected void longSearch() {
        new Thread(){

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Start long searcher for GNU tools. Start 'find'.");
                    if (!Platform.getOS().equals("linux")) ** GOTO lbl15
                    systemsim_cellPath = new Path(Find.findFile((String)GnuToolsProperties.ppugccSearchRootDirectory, (String)GnuToolsProperties.ppugccExecutable)).removeLastSegments(1).toOSString();
                    Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "'find' finished.");
                    if (GnuToolsSearcher.this.isValidGNUToolsDirectory(systemsim_cellPath)) {
                        GnuToolsSearcher.access$0(GnuToolsSearcher.this, systemsim_cellPath);
                        Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Long searcher successfull.");
                        GnuToolsSearcher.access$1(GnuToolsSearcher.this, SearcherMessages.searchSucceededDialogTitle, NLS.bind((String)SearcherMessages.searchSucceededDialogMessage, (Object)GnuToolsProperties.gnuToolsPathLabel));
                        return;
                    }
                    Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Long searcher found nothing.");
                    GnuToolsSearcher.access$1(GnuToolsSearcher.this, SearcherMessages.searchFailedDialogTitle, NLS.bind((String)SearcherMessages.searchFailedDialogMessage, (Object)GnuToolsProperties.gnuToolsPathLabel));
                    return;
lbl15:
                    // 1 sources

                    Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Not a Linux platform, no long search is available.");
                    return;
                }
                catch (Exception e) {
                    Debug.POLICY.error(Debug.DEBUG_SEARCHER, (Throwable)e);
                    Debug.POLICY.logError((Throwable)e);
                    return;
                }
                finally {
                    Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Finished long searcher for GNU tools.");
                }
            }
        }.start();
    }

    protected boolean isValidGNUToolsDirectory(String directoryPath) {
        File gnuToolsDirectory;
        if (directoryPath != null && (gnuToolsDirectory = new File(directoryPath)).exists() && gnuToolsDirectory.isDirectory()) {
            String[] gnuExecutables = GnuToolsProperties.gnuTools.split(GnuToolsProperties.separator);
            int i = 0;
            while (i < gnuExecutables.length) {
                File gnuExecutable = new File(gnuToolsDirectory, gnuExecutables[i]);
                if (!gnuExecutable.exists() || !gnuExecutable.isFile()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ void access$0(GnuToolsSearcher gnuToolsSearcher, String string) {
        gnuToolsSearcher.setText(string);
    }

    static /* synthetic */ void access$1(GnuToolsSearcher gnuToolsSearcher, String string, String string2) {
        gnuToolsSearcher.showInfoMessage(string, string2);
    }
}

