/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.ui.deploy.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ptp.cell.environment.ui.deploy.debug.Debug;
import org.eclipse.ptp.cell.environment.ui.deploy.events.DeleteJobWrapper;
import org.eclipse.ptp.cell.environment.ui.deploy.events.Messages;
import org.eclipse.ptp.cell.environment.ui.deploy.wizard.AbstractCellWizardPage;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class CellDeleteResourcesPage
extends AbstractCellWizardPage {
    private Text resourcePath;
    private Button deleteButton;

    public CellDeleteResourcesPage(String pageName, ITargetControl control) {
        super(pageName, control);
        this.setTitle(Messages.CellDeleteResourcesPage_0);
        this.setDescription(Messages.CellDeleteResourcesPage_1);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.deleteButton.setFocus();
    }

    protected void createDestinationGroup(Composite parent) {
        Font font = parent.getFont();
        Group deleteGroup = new Group(parent, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 1;
        deleteGroup.setLayout((Layout)groupLayout);
        deleteGroup.setLayoutData((Object)new GridData(48));
        deleteGroup.setText(Messages.CellDeleteResourcesPage_2);
        deleteGroup.setFont(font);
        this.resourcePath = new Text((Composite)deleteGroup, 18436);
        this.resourcePath.addListener(24, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 450;
        this.resourcePath.setLayoutData((Object)data);
        this.resourcePath.setFont(font);
        Composite comp = new Composite((Composite)deleteGroup, 0);
        comp.setLayout((Layout)groupLayout);
        comp.setLayoutData((Object)new GridData(32));
        this.deleteButton = new Button(comp, 8);
        this.deleteButton.setText(Messages.CellDeleteResourcesPage_3);
        this.deleteButton.addListener(13, (Listener)this);
        this.deleteButton.setFont(font);
        this.setButtonLayoutData(this.deleteButton);
        this.deleteButton.setFocus();
    }

    protected void createOptionsGroup(Composite parent) {
    }

    protected void createResourcesGroup(Composite parent) {
    }

    public boolean finish() {
        return true;
    }

    private void handleDeletePressed() {
        try {
            String path = this.resourcePath.getText();
            if (path == null || path.length() == 0) {
                this.setErrorMessage(Messages.CellDeleteResourcesPage_4);
                return;
            }
            try {
                DeleteJobWrapper deleteWrapper = new DeleteJobWrapper();
                ProgressMonitorDialog jobMonitor = new ProgressMonitorDialog(this.getContainer().getShell());
                deleteWrapper.init(this.cellControl, path);
                jobMonitor.setOpenOnRun(true);
                jobMonitor.run(true, true, (IRunnableWithProgress)deleteWrapper);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() == null) {
                    MessageDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.CellDeleteResourcesPage_5, (String)e.getMessage());
                    return;
                }
                Debug.POLICY.logError((Throwable)e);
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)e.getMessage(), (String)e.getTargetException().toString());
                return;
            }
            catch (InterruptedException interruptedException) {
                MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)Messages.CellDeleteResourcesPage_6, (String)Messages.CellDeleteResourcesPage_7);
                return;
            }
            MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)Messages.CellDeleteResourcesPage_8, (String)Messages.CellDeleteResourcesPage_9);
        }
        catch (Exception ee) {
            Debug.POLICY.logError((Throwable)ee);
        }
    }

    public void handleEvent(Event event) {
        try {
            this.setErrorMessage(null);
            Widget source = event.widget;
            if (source == this.deleteButton) {
                this.handleDeletePressed();
            }
        }
        catch (Exception ee) {
            Debug.POLICY.logError((Throwable)ee);
        }
    }
}

