/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.alf.ui.wizard;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.cell.alf.ui.Messages;
import org.eclipse.ptp.cell.utils.packagemanager.PackageManagementSystemManager;
import org.eclipse.ptp.cell.utils.packagemanager.PackageManager;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class ALFWizardNewProjectCreationPage
extends WizardNewProjectCreationPage {
    private boolean RPMsChecked = false;
    private boolean RPMsValidated = false;
    private String RPMErrorMessage = "";

    public ALFWizardNewProjectCreationPage(String pageName) {
        super(pageName);
    }

    protected boolean validatePage() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (!this.RPMsChecked) {
            PackageManager manager = PackageManagementSystemManager.getPackageManager();
            boolean alfPackage1 = manager.query("alf-cross-devel");
            boolean alfPackage2 = manager.query("alf-hybrid-cross-devel");
            boolean alfPackage3 = manager.query("alf");
            boolean alfPackage4 = manager.query("alf-devel");
            boolean alfPackage5 = manager.query("alf-hybrid");
            boolean alfPackage6 = manager.query("alf-hybrid-devel");
            boolean alfPackage7 = manager.query("alf-ide-template");
            this.RPMsChecked = true;
            if (!(alfPackage1 || alfPackage2 || alfPackage3 || alfPackage4 || alfPackage5 || alfPackage6)) {
                this.RPMErrorMessage = Messages.ALFWizard_errorAlfNotInstalled;
                this.openErrorMessage(Messages.ALFWizard_projectNamePageTitle, Messages.ALFWizard_errorAlfNotInstalled);
                this.RPMsValidated = false;
                return false;
            }
            if (!alfPackage7) {
                this.RPMErrorMessage = Messages.ALFWizard_errorALFTemplateNotInstalled;
                this.openErrorMessage(Messages.ALFWizard_projectNamePageTitle, Messages.ALFWizard_errorALFTemplateNotInstalled);
                this.RPMsValidated = false;
                return false;
            }
            this.RPMsValidated = true;
        } else if (!this.RPMsValidated) {
            this.setErrorMessage(this.RPMErrorMessage);
            return false;
        }
        String projectFieldContents = this.getProjectName();
        if (projectFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(Messages.ALFWizardNewProjectCreationPage_projectNameEmpty);
            return false;
        }
        IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        IProject ppuHandle = workspace.getRoot().getProject("ppu_" + this.getProjectName());
        if (ppuHandle.exists()) {
            this.setErrorMessage(String.valueOf(Messages.ALFWizardNewProjectCreationPage_projectExistsMessagePart1) + "ppu_" + this.getProjectName() + Messages.ALFWizardNewProjectCreationPage_projectExistsMessagePart2);
            return false;
        }
        IProject libHandle = workspace.getRoot().getProject("lib" + this.getProjectName());
        if (libHandle.exists()) {
            this.setErrorMessage(String.valueOf(Messages.ALFWizardNewProjectCreationPage_projectExistsMessagePart1) + "lib" + this.getProjectName() + Messages.ALFWizardNewProjectCreationPage_projectExistsMessagePart2);
            return false;
        }
        IProject spuHandle = workspace.getRoot().getProject("spu_" + this.getProjectName());
        if (spuHandle.exists()) {
            this.setErrorMessage(String.valueOf(Messages.ALFWizardNewProjectCreationPage_projectExistsMessagePart1) + "spu_" + this.getProjectName() + Messages.ALFWizardNewProjectCreationPage_projectExistsMessagePart2);
            return false;
        }
        if (!this.useDefaults()) {
            IStatus ppuLocationStatus = workspace.validateProjectLocationURI(ppuHandle, this.getLocationURI());
            if (!ppuLocationStatus.isOK()) {
                this.setErrorMessage(ppuLocationStatus.getMessage());
                return false;
            }
            IStatus libLocationStatus = workspace.validateProjectLocationURI(libHandle, this.getLocationURI());
            if (!libLocationStatus.isOK()) {
                this.setErrorMessage(libLocationStatus.getMessage());
                return false;
            }
            IStatus spuLocationStatus = workspace.validateProjectLocationURI(spuHandle, this.getLocationURI());
            if (!spuLocationStatus.isOK()) {
                this.setErrorMessage(spuLocationStatus.getMessage());
                return false;
            }
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void openErrorMessage(String title, String message) {
        final MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 1, new String[]{Messages.ALFWizard_ok}, 0);
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }
}

