/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.managedbuilder.xl.core.preferences;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.cell.managedbuilder.xl.core.debug.Debug;
import org.eclipse.ptp.cell.managedbuilder.xl.core.preferences.XlToolsProperties;
import org.eclipse.ptp.cell.preferences.core.SearcherMessages;
import org.eclipse.ptp.cell.preferences.core.StringFieldEditorPreferenceSearcher;
import org.eclipse.ptp.cell.utils.linux.findutils.Find;
import org.eclipse.ptp.cell.utils.linux.which.Which;
import org.eclipse.ptp.cell.utils.packagemanager.PackageManagementSystemManager;
import org.eclipse.ptp.cell.utils.searcher.SearchFailedException;
import org.eclipse.swt.widgets.Composite;

public class XlToolsSearcher
extends StringFieldEditorPreferenceSearcher {
    public XlToolsSearcher(StringFieldEditor stringFieldEditor, Composite parent) {
        super(stringFieldEditor, parent);
    }

    protected void fastSearch() throws SearchFailedException {
        String xlToolsPath;
        String currentPreferenceValue = this.stringFieldEditor.getStringValue();
        if (this.isValidXLToolsDirectory(currentPreferenceValue)) {
            Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Current value is valid");
            return;
        }
        String defaultPreferenceValue = this.preferenceStore.getDefaultString(this.preferenceName);
        if (!currentPreferenceValue.equals(defaultPreferenceValue) && this.isValidXLToolsDirectory(defaultPreferenceValue)) {
            Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Default value is valid");
            this.setText(defaultPreferenceValue);
            return;
        }
        if (Platform.getOS().equals("linux") && this.isValidXLToolsDirectory(xlToolsPath = new Path(Which.which((String)XlToolsProperties.ppuxlcExecutable)).removeLastSegments(1).toOSString())) {
            Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Value returned from 'which' is valid");
            this.setText(xlToolsPath);
            return;
        }
        xlToolsPath = PackageManagementSystemManager.getPackageManager().searchFileInQueryListAndReturnInitialPathSegments(XlToolsProperties.ppuxlcPackage, String.valueOf(File.separator) + XlToolsProperties.ppuxlcExecutable);
        if (this.isValidXLToolsDirectory(xlToolsPath)) {
            Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Value returned from package management system is valid");
            this.setText(xlToolsPath);
            return;
        }
        Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "All fast searches failed,");
        throw new SearchFailedException(SearcherMessages.fastSearchFailedMessage);
    }

    protected void longSearch() {
        new Thread(){

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Start long searcher for XL tools. Start 'find'.");
                    if (!Platform.getOS().equals("linux")) ** GOTO lbl15
                    systemsim_cellPath = new Path(Find.findFile((String)XlToolsProperties.ppuxlcSearchRootDirectory, (String)XlToolsProperties.ppuxlcExecutable)).removeLastSegments(1).toOSString();
                    Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "'find' finished.");
                    if (XlToolsSearcher.this.isValidXLToolsDirectory(systemsim_cellPath)) {
                        XlToolsSearcher.access$0(XlToolsSearcher.this, systemsim_cellPath);
                        Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Long searcher successfull.");
                        XlToolsSearcher.access$1(XlToolsSearcher.this, SearcherMessages.searchSucceededDialogTitle, NLS.bind((String)SearcherMessages.searchSucceededDialogMessage, (Object)XlToolsProperties.xlToolsPathLabel));
                        return;
                    }
                    Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Long searcher found nothing.");
                    XlToolsSearcher.access$1(XlToolsSearcher.this, SearcherMessages.searchFailedDialogTitle, NLS.bind((String)SearcherMessages.searchFailedDialogMessage, (Object)XlToolsProperties.xlToolsPathLabel));
                    return;
lbl15:
                    // 1 sources

                    Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Not a Linux platform, no long search is available.");
                    return;
                }
                catch (Exception e) {
                    Debug.POLICY.error(Debug.DEBUG_SEARCHER, (Throwable)e);
                    Debug.POLICY.logError((Throwable)e);
                    return;
                }
                finally {
                    Debug.POLICY.trace(Debug.DEBUG_SEARCHER, "Finished long searcher for XL tools.");
                }
            }
        }.start();
    }

    protected boolean isValidXLToolsDirectory(String directoryPath) {
        File xlToolsDirectory;
        if (directoryPath != null && (xlToolsDirectory = new File(directoryPath)).exists() && xlToolsDirectory.isDirectory()) {
            String[] xlExecutables = XlToolsProperties.xlTools.split(XlToolsProperties.separator);
            int i = 0;
            while (i < xlExecutables.length) {
                File xlExecutable = new File(xlToolsDirectory, xlExecutables[i]);
                if (!xlExecutable.exists() || !xlExecutable.isFile()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ void access$0(XlToolsSearcher xlToolsSearcher, String string) {
        xlToolsSearcher.setText(string);
    }

    static /* synthetic */ void access$1(XlToolsSearcher xlToolsSearcher, String string, String string2) {
        xlToolsSearcher.showInfoMessage(string, string2);
    }
}

