/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.cellsimulator.core.local;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.cell.environment.cellsimulator.SimulatorProperties;
import org.eclipse.ptp.cell.environment.cellsimulator.conf.LocalDefaultValues;
import org.eclipse.ptp.cell.environment.cellsimulator.core.local.LocalConfigurationBean;
import org.eclipse.ptp.cell.environment.cellsimulator.core.local.LocalTargetControl;
import org.eclipse.ptp.cell.environment.cellsimulator.ui.ConfigurationPage;
import org.eclipse.ptp.cell.environment.cellsimulator.ui.Messages;
import org.eclipse.ptp.cell.utils.packagemanager.PackageManagementSystemManager;
import org.eclipse.ptp.remotetools.environment.control.ITargetControl;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.extension.ITargetTypeExtension;
import org.eclipse.ptp.remotetools.environment.wizard.AbstractEnvironmentDialogPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class LocalLaunchEnvironment
implements ITargetTypeExtension {
    public ITargetControl controlFactory(ITargetElement element) throws CoreException {
        return new LocalTargetControl(element);
    }

    public String[] getControlAttributeNames() {
        return LocalConfigurationBean.KEY_ARRAY;
    }

    public AbstractEnvironmentDialogPage dialogPageFactory(ITargetElement element) {
        if (!PackageManagementSystemManager.getPackageManager().query(SimulatorProperties.simulatorPackage)) {
            return new DummyEnvironmentDialogPage(LocalDefaultValues.DefaultTargetName);
        }
        ConfigurationPage page = new ConfigurationPage(element.getName(), new LocalConfigurationBean(element.getAttributes(), element.getId()));
        page.setAvailableAutomaticNetwork(true);
        page.setAvailableAutomaticPort(true);
        page.setAvailableRemoteConnection(false);
        page.setAvailableAutomaticWorkDirectory(true);
        return page;
    }

    public AbstractEnvironmentDialogPage dialogPageFactory() {
        if (!PackageManagementSystemManager.getPackageManager().query(SimulatorProperties.simulatorPackage)) {
            return new DummyEnvironmentDialogPage(LocalDefaultValues.DefaultTargetName);
        }
        ConfigurationPage page = new ConfigurationPage(LocalDefaultValues.DefaultTargetName, new LocalConfigurationBean());
        page.setAvailableAutomaticNetwork(true);
        page.setAvailableAutomaticPort(true);
        page.setAvailableRemoteConnection(false);
        page.setAvailableAutomaticWorkDirectory(true);
        return page;
    }

    public String[] getControlAttributeNamesForCipheredKeys() {
        return LocalConfigurationBean.KEY_CIPHERED_ARRAY;
    }

    public class DummyEnvironmentDialogPage
    extends AbstractEnvironmentDialogPage {
        private String targetName;

        public DummyEnvironmentDialogPage(String targetName) {
            super(targetName);
            this.targetName = targetName;
        }

        public boolean isValid() {
            return false;
        }

        public String getName() {
            return this.targetName;
        }

        public Map getAttributes() {
            return null;
        }

        public void createControl(Composite parent) {
            this.setTitle(Messages.ConfigurationPage_DialogTitle_LocalSimulator);
            this.setDescription(Messages.ConfigurationPage_DialogDescription_LocalSimulator);
            this.setErrorMessage(null);
            GridLayout topLayout = new GridLayout();
            Composite topControl = new Composite(parent, 0);
            this.setControl((Control)topControl);
            topControl.setLayout((Layout)topLayout);
            Label label = new Label(topControl, 0);
            label.setText(Messages.ConfigurationPage_NoLocalSimulator);
        }
    }
}

