/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.cellsimulator.core.remote;

import org.eclipse.ptp.cell.environment.cellsimulator.conf.Parameters;
import org.eclipse.ptp.cell.environment.cellsimulator.core.remote.Messages;
import org.eclipse.ptp.cell.environment.cellsimulator.core.remote.RemoteSimulatorDelegate;
import org.eclipse.ptp.cell.simulator.conf.AttributeNames;
import org.eclipse.ptp.cell.simulator.core.AbstractSimulatorConfiguration;
import org.eclipse.ptp.cell.simulator.core.ISimulatorDelegate;
import org.eclipse.ptp.cell.simulator.core.ISimulatorParameters;
import org.eclipse.ptp.cell.simulator.core.IllegalConfigurationException;
import org.eclipse.ptp.cell.simulator.core.IllegalParameterException;
import org.eclipse.ptp.remotetools.core.IRemoteDirectory;
import org.eclipse.ptp.remotetools.core.IRemoteExecutionManager;
import org.eclipse.ptp.remotetools.core.IRemoteFile;
import org.eclipse.ptp.remotetools.core.IRemoteFileTools;
import org.eclipse.ptp.remotetools.core.IRemoteItem;
import org.eclipse.ptp.remotetools.core.IRemotePathTools;
import org.eclipse.ptp.remotetools.exception.CancelException;
import org.eclipse.ptp.remotetools.exception.RemoteConnectionException;
import org.eclipse.ptp.remotetools.exception.RemoteOperationException;

public class RemoteSimulatorConfiguration
extends AbstractSimulatorConfiguration {
    ISimulatorDelegate simulatorDelegate;
    IRemoteExecutionManager executionManager;
    protected static int FILE = 2;
    protected static int DIRECTORY = 4;
    protected static int READ = 8;
    protected static int WRITE = 16;
    protected static int EXISTING_FILE = FILE;
    protected static int EXISTING_DIR = DIRECTORY;
    protected static int READABLE_FILE = EXISTING_FILE | READ;
    protected static int WRITABLE_FILE = EXISTING_FILE | READ | WRITE;
    protected static int ACCESSIBLE_DIR = DIRECTORY | READ;

    public RemoteSimulatorConfiguration() {
        this.executionManager = null;
        this.simulatorDelegate = null;
    }

    public RemoteSimulatorConfiguration(IRemoteExecutionManager executionManager) {
        this.executionManager = executionManager;
        this.simulatorDelegate = new RemoteSimulatorDelegate((ISimulatorParameters)this, executionManager);
    }

    private void checkDelegate() {
        if (this.simulatorDelegate == null) {
            throw new IllegalStateException(Messages.RemoteSimulatorConfiguration_IncorrectAssociation);
        }
    }

    public ISimulatorDelegate getDelegate() {
        this.checkDelegate();
        return this.simulatorDelegate;
    }

    public String getSimulatorExecutable() {
        this.checkDelegate();
        return this.executionManager.getRemotePathTools().join(this.getSimulatorBaseDirectory(), Parameters.PATH_SIMULATOR);
    }

    public String getSnifExecutable() {
        this.checkDelegate();
        return this.executionManager.getRemotePathTools().join(this.getSimulatorBaseDirectory(), Parameters.PATH_SNIF);
    }

    public String getWorkDirectoryRelativePath(String path) {
        return this.executionManager.getRemotePathTools().join(this.getWorkDirectory(), path);
    }

    public String getLogDirectory() {
        this.checkDelegate();
        return this.getWorkDirectoryRelativePath(Parameters.PATH_RUNINFO);
    }

    public String getPIDPath() {
        this.checkDelegate();
        return this.executionManager.getRemotePathTools().join(this.getLogDirectory(), Parameters.PATH_PID);
    }

    public String getTapDevicePath() {
        this.checkDelegate();
        return this.executionManager.getRemotePathTools().join(this.getLogDirectory(), Parameters.PATH_TAPDEVICE);
    }

    public void verify() throws IllegalConfigurationException {
        super.verify();
        if (this.executionManager != null) {
            try {
                this.verifyPath(READABLE_FILE, AttributeNames.KERNEL_IMAGE_PATH, this.getKernelImagePath());
                this.verifyPath(EXISTING_FILE, AttributeNames.ROOT_IMAGE_PATH, this.getRootImagePath());
                if (this.doMountExtraImage()) {
                    if (this.getExtraImagePersistence() == 2) {
                        this.verifyPath(READABLE_FILE | WRITE, AttributeNames.EXTRA_IMAGE_PATH, this.getExtraImagePath());
                    } else {
                        this.verifyPath(READABLE_FILE, AttributeNames.EXTRA_IMAGE_PATH, this.getExtraImagePath());
                    }
                }
            }
            catch (RemoteConnectionException remoteConnectionException) {
                throw new IllegalStateException(Messages.RemoteSimulatorConfiguration_RemoteHostVerificationFailed);
            }
            catch (CancelException cancelException) {
                throw new IllegalStateException(Messages.RemoteSimulatorConfiguration_RemoteHostVerificationFailed);
            }
        }
    }

    protected void verifyPath(int option, String attributeName, String path) throws IllegalParameterException, RemoteConnectionException, CancelException {
        IRemoteItem item;
        IRemoteFileTools fileTools = this.executionManager.getRemoteFileTools();
        IRemotePathTools pathTools = this.executionManager.getRemotePathTools();
        if (!pathTools.isAbsolute(path)) {
            throw new IllegalParameterException(Messages.RemoteSimulatorConfiguration_PathMustBeAbsolute, attributeName, path);
        }
        try {
            item = fileTools.getItem(path);
        }
        catch (RemoteOperationException remoteOperationException) {
            throw new IllegalParameterException(Messages.RemoteSimulatorConfiguration_PathDoesNotExist, attributeName, path);
        }
        if ((option & FILE) != 0 && !(item instanceof IRemoteFile)) {
            throw new IllegalParameterException(Messages.RemoteSimulatorConfiguration_MustBeFile, attributeName, path);
        }
        if ((option & DIRECTORY) != 0 && !(item instanceof IRemoteDirectory)) {
            throw new IllegalParameterException(Messages.RemoteSimulatorConfiguration_MustBeDir, attributeName, path);
        }
        if ((option & READ) != 0 && !item.isReadable()) {
            throw new IllegalParameterException(Messages.RemoteSimulatorConfiguration_MustBeReadable, attributeName, path);
        }
        if ((option & WRITE) != 0 && !item.isWritable()) {
            throw new IllegalParameterException(Messages.RemoteSimulatorConfiguration_MustBeWritable, attributeName, path);
        }
    }
}

