/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.cellsimulator.preferences.core;

import java.io.File;
import org.eclipse.cdt.internal.core.envvar.DefaultEnvironmentContextInfo;
import org.eclipse.cdt.internal.core.envvar.EnvVarDescriptor;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.internal.core.envvar.IEnvironmentContextInfo;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.cell.environment.cellsimulator.conf.AttributeNames;
import org.eclipse.ptp.cell.environment.cellsimulator.preferences.core.LocalSimulatorProperties;
import org.eclipse.ptp.cell.preferences.core.SearcherMessages;
import org.eclipse.ptp.cell.preferences.core.StringFieldEditorPreferenceSearcher;
import org.eclipse.ptp.cell.utils.linux.findutils.Find;
import org.eclipse.ptp.cell.utils.linux.which.Which;
import org.eclipse.ptp.cell.utils.packagemanager.PackageManagementSystemManager;
import org.eclipse.ptp.cell.utils.searcher.SearchFailedException;
import org.eclipse.swt.widgets.Composite;

public class InstallDirectorySearcher
extends StringFieldEditorPreferenceSearcher {
    protected static final String BINARY_DIRECTORY = "bin";
    protected static final String WILDCARD = "*";

    public InstallDirectorySearcher(StringFieldEditor stringFieldEditor, Composite parent) {
        super(stringFieldEditor, parent);
    }

    protected void fastSearch() throws SearchFailedException {
        String systemsim_cellPath;
        String currentPreferenceValue = this.stringFieldEditor.getStringValue();
        if (this.isValidInstallDirectory(currentPreferenceValue)) {
            return;
        }
        EnvVarDescriptor systemsim_topEnvVar = EnvironmentVariableManager.getVariable((String)LocalSimulatorProperties.SYSTEMSIM_TOP_variableName, (IEnvironmentContextInfo)new DefaultEnvironmentContextInfo(null), (boolean)true);
        String systemsim_top = null;
        if (systemsim_topEnvVar != null) {
            systemsim_top = systemsim_topEnvVar.getValue();
        }
        if (this.isValidInstallDirectory(systemsim_top)) {
            this.setText(systemsim_top);
            return;
        }
        String defaultPreferenceValue = this.preferenceStore.getDefaultString(this.preferenceName);
        if (!currentPreferenceValue.equals(defaultPreferenceValue) && this.isValidInstallDirectory(defaultPreferenceValue)) {
            this.setText(defaultPreferenceValue);
            return;
        }
        if (Platform.getOS().equals("linux") && this.isValidInstallDirectory(systemsim_cellPath = new Path(Which.which((String)LocalSimulatorProperties.systemsim_cell_executable)).removeLastSegments(2).toOSString())) {
            this.setText(systemsim_cellPath);
            return;
        }
        systemsim_top = PackageManagementSystemManager.getPackageManager().searchFileInQueryListAndReturnInitialPathSegments(LocalSimulatorProperties.systemsim_cell_package, String.valueOf(File.separator) + BINARY_DIRECTORY + File.separator + LocalSimulatorProperties.systemsim_cell_executable);
        if (this.isValidInstallDirectory(systemsim_top)) {
            this.setText(systemsim_top);
            return;
        }
        throw new SearchFailedException(SearcherMessages.fastSearchFailedMessage);
    }

    protected void longSearch() {
        new Thread(){

            public void run() {
                if (Platform.getOS().equals("linux")) {
                    String systemsim_cellPath = new Path(Find.findWholename((String)LocalSimulatorProperties.simulatorSearchRootDirectory, (String)("*bin" + File.separator + LocalSimulatorProperties.systemsim_cell_executable))).removeLastSegments(2).toOSString();
                    if (InstallDirectorySearcher.this.isValidInstallDirectory(systemsim_cellPath)) {
                        InstallDirectorySearcher.this.setText(systemsim_cellPath);
                        InstallDirectorySearcher.this.showInfoMessage(SearcherMessages.searchSucceededDialogTitle, NLS.bind((String)SearcherMessages.searchSucceededDialogMessage, (Object)AttributeNames.SIMULATOR_BASE_DIRECTORY));
                        return;
                    }
                    InstallDirectorySearcher.this.showInfoMessage(SearcherMessages.searchFailedDialogTitle, NLS.bind((String)SearcherMessages.searchFailedDialogMessage, (Object)AttributeNames.SIMULATOR_BASE_DIRECTORY));
                }
            }
        }.start();
    }

    protected boolean isValidInstallDirectory(String directoryPath) {
        File installDirectory;
        if (directoryPath != null && (installDirectory = new File(directoryPath)).exists() && installDirectory.isDirectory()) {
            File snif = new File(installDirectory, BINARY_DIRECTORY + File.separator + LocalSimulatorProperties.snifExecutable);
            File systemsim_cell = new File(installDirectory, BINARY_DIRECTORY + File.separator + LocalSimulatorProperties.systemsim_cell_executable);
            if (snif.exists() && snif.isFile() && systemsim_cell.exists() && systemsim_cell.isFile()) {
                return true;
            }
        }
        return false;
    }
}

