/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.cellsimulator.preferences.ui;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ptp.cell.environment.cellsimulator.CellSimulatorTargetPlugin;
import org.eclipse.ptp.cell.environment.cellsimulator.SimulatorProperties;
import org.eclipse.ptp.cell.environment.cellsimulator.preferences.core.InstallDirectorySearcher;
import org.eclipse.ptp.cell.environment.cellsimulator.preferences.ui.Messages;
import org.eclipse.ptp.cell.preferences.events.FollowBeginStringFieldEditorPropertyChangeListener;
import org.eclipse.ptp.cell.preferences.ui.DirectoryFieldEditorWithSearch;
import org.eclipse.ptp.cell.preferences.ui.LabelFieldEditor;
import org.eclipse.ptp.cell.preferences.ui.SpacerFieldEditor;
import org.eclipse.ptp.cell.utils.packagemanager.PackageManagementSystemManager;
import org.eclipse.ptp.cell.utils.searcher.Searcher;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LocalSimulatorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private DirectoryFieldEditorWithSearch simulatorBaseDirectory;
    private DirectoryFieldEditor workDirectory;
    private FileFieldEditor kernelImagePath;
    private FileFieldEditor rootImagePath;
    private BooleanFieldEditor showSimulatorConsole;
    private BooleanFieldEditor showLinuxConsole;
    private BooleanFieldEditor showMamboGUI;
    private boolean isSimulatorInstalled = false;

    public LocalSimulatorPreferencePage() {
        super(Messages.LocalSimulatorPreferencePage_Title, null, 1);
        IPreferenceStore store = CellSimulatorTargetPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
        if (!PackageManagementSystemManager.getPackageManager().query(SimulatorProperties.simulatorPackage)) {
            this.isSimulatorInstalled = true;
            this.setDescription(Messages.LocalSimulatorPreferencePage_Description_NoLocalSimulator);
        } else {
            this.setDescription(Messages.LocalSimulatorPreferencePage_Description);
        }
    }

    protected void createFieldEditors() {
        this.setTitle(Messages.LocalSimulatorPreferencePage_Title);
        if (this.isSimulatorInstalled) {
            return;
        }
        this.simulatorBaseDirectory = new DirectoryFieldEditorWithSearch("local-simulator-base-directory", Messages.LocalSimulatorPreferencePage_LabelSimulatorBaseDirectory, this.getFieldEditorParent());
        this.simulatorBaseDirectory.setSearchButtonText(Messages.searchButtonText);
        this.simulatorBaseDirectory.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.simulatorBaseDirectory);
        this.workDirectory = new DirectoryFieldEditor("local-work-directory", Messages.LocalSimulatorPreferencePage_LabelWorkDirectory, this.getFieldEditorParent());
        this.workDirectory.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.workDirectory);
        this.kernelImagePath = new FileFieldEditor("local-kernel-image-path", Messages.LocalSimulatorPreferencePage_LabelKernelImagePath, this.getFieldEditorParent());
        this.kernelImagePath.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.kernelImagePath);
        this.rootImagePath = new FileFieldEditor("local-root-image-path", Messages.LocalSimulatorPreferencePage_LabelRootImagePath, this.getFieldEditorParent());
        this.rootImagePath.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.rootImagePath);
        this.addSpace(this.getFieldEditorParent());
        this.showLinuxConsole = new BooleanFieldEditor("local-console-show-linux", Messages.LocalSimulatorPreferencePage_LabelShowLinuxconsole, this.getFieldEditorParent());
        this.addField((FieldEditor)this.showLinuxConsole);
        this.showSimulatorConsole = new BooleanFieldEditor("local-console-show-simulator", Messages.LocalSimulatorPreferencePage_LabelShowSimulatorConsole, this.getFieldEditorParent());
        this.addField((FieldEditor)this.showSimulatorConsole);
        this.showMamboGUI = new BooleanFieldEditor("local-show-simulator-gui", Messages.LocalSimulatorPreferencePage_LabelShowSimulatorGUI, this.getFieldEditorParent());
        this.addField((FieldEditor)this.showMamboGUI);
        this.addSpace(this.getFieldEditorParent());
        this.addField((FieldEditor)new LabelFieldEditor(Messages.LocalSimulatorPreferencePage_NetworkConfigHeader1, this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("attribute-generator-base-ip", Messages.LocalSimulatorPreferencePage_LabelBaseNetwork, this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("attribute-generator-base-macaddress", Messages.LocalSimulatorPreferencePage_LabelBaseMacaddress, this.getFieldEditorParent()));
        this.addField((FieldEditor)new LabelFieldEditor(Messages.LocalSimulatorPreferencePage_PortConfigHeader1, this.getFieldEditorParent()));
        this.addField((FieldEditor)new LabelFieldEditor(Messages.LocalSimulatorPreferencePage_PortConfigHeader2, this.getFieldEditorParent()));
        this.addField((FieldEditor)new IntegerFieldEditor("attribute-generator-min-portvalue", Messages.LocalSimulatorPreferencePage_LabelMinPort, this.getFieldEditorParent()));
        this.addField((FieldEditor)new IntegerFieldEditor("attribute-generator-max-portvalue", Messages.LocalSimulatorPreferencePage_LabelMaxPort, this.getFieldEditorParent()));
        this.addSpace(this.getFieldEditorParent());
        this.addField((FieldEditor)new LabelFieldEditor(Messages.LocalSimulatorPreferencePage_HeaderLaunch, this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("local-system-workspace-dir", Messages.LocalSimulatorPreferencePage_LabelSystemWorkspace, this.getFieldEditorParent()));
    }

    protected void initialize() {
        super.initialize();
        if (this.isSimulatorInstalled) {
            return;
        }
        Composite fieldEditorParent = this.getFieldEditorParent();
        InstallDirectorySearcher installDirectorySearcher = new InstallDirectorySearcher((StringFieldEditor)this.simulatorBaseDirectory, fieldEditorParent);
        installDirectorySearcher.addPropertyChangeListener((IPropertyChangeListener)new FollowBeginStringFieldEditorPropertyChangeListener((StringFieldEditor)this.workDirectory, fieldEditorParent));
        installDirectorySearcher.addPropertyChangeListener((IPropertyChangeListener)new FollowBeginStringFieldEditorPropertyChangeListener((StringFieldEditor)this.kernelImagePath, fieldEditorParent));
        installDirectorySearcher.addPropertyChangeListener((IPropertyChangeListener)new FollowBeginStringFieldEditorPropertyChangeListener((StringFieldEditor)this.rootImagePath, fieldEditorParent));
        this.simulatorBaseDirectory.addSearcher((Searcher)installDirectorySearcher);
    }

    protected void addSpace(Composite fieldEditorParent) {
        SpacerFieldEditor spacer1 = new SpacerFieldEditor(fieldEditorParent);
        this.addField((FieldEditor)spacer1);
    }

    public void init(IWorkbench workbench) {
    }
}

