/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.utils.process;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.cell.utils.debug.Debug;

public class ProcessController
extends Thread {
    protected static final long TIME_SLOT = 500L;
    private String processName;
    private Process process;
    private long timeout;

    public ProcessController(String processName, Process process, long timeout) {
        this.processName = processName;
        this.process = process;
        this.timeout = timeout;
        Debug.read();
    }

    public void run() {
        block10: {
            Debug.read();
            Debug.POLICY.trace(Debug.DEBUG_PROCESS, "(" + this.process.hashCode() + ")" + "Started ProcessController.run().");
            UserControl userControl = new UserControl(this.processName, Thread.currentThread(), 500L);
            userControl.schedule();
            Debug.POLICY.trace(Debug.DEBUG_PROCESS, "(" + this.process.hashCode() + ")" + "UserControl scheduled.");
            try {
                try {
                    Thread.sleep(this.timeout);
                    Debug.POLICY.trace(Debug.DEBUG_PROCESS, "(" + this.process.hashCode() + ")" + "Timed out.");
                    try {
                        this.process.exitValue();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        this.process.destroy();
                    }
                }
                catch (InterruptedException interruptedException) {
                    userControl.stopNow();
                    if (userControl.isDoCancel()) {
                        Debug.POLICY.trace(Debug.DEBUG_PROCESS, "(" + this.process.hashCode() + ")" + " killed.");
                        this.process.destroy();
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                userControl.stopNow();
                if (userControl.isDoCancel()) {
                    Debug.POLICY.trace(Debug.DEBUG_PROCESS, "(" + this.process.hashCode() + ")" + " killed.");
                    this.process.destroy();
                }
                throw throwable;
            }
            userControl.stopNow();
            if (userControl.isDoCancel()) {
                Debug.POLICY.trace(Debug.DEBUG_PROCESS, "(" + this.process.hashCode() + ")" + " killed.");
                this.process.destroy();
            }
        }
        Debug.POLICY.trace(Debug.DEBUG_PROCESS, "(" + this.process.hashCode() + ")" + "Finished ProcessController.run().");
    }

    class UserControl
    extends Job {
        private Thread parentThread;
        private long timeSlot;
        private boolean keepRunning;
        private boolean doCancel;

        public UserControl(String processName, Thread parentThread, long timeSlot) {
            super(processName);
            this.keepRunning = true;
            this.doCancel = false;
            this.parentThread = parentThread;
            this.timeSlot = timeSlot;
        }

        synchronized void stopNow() {
            this.keepRunning = false;
        }

        public synchronized boolean isKeepRunning() {
            return this.keepRunning;
        }

        public boolean isDoCancel() {
            return this.doCancel;
        }

        protected IStatus run(IProgressMonitor monitor) {
            Debug.POLICY.trace(Debug.DEBUG_PROCESS, "(" + ProcessController.this.process.hashCode() + ")" + "Start UserControl.");
            while (this.isKeepRunning()) {
                if (monitor != null && monitor.isCanceled()) {
                    Debug.POLICY.trace(Debug.DEBUG_PROCESS, "(" + ProcessController.this.process.hashCode() + ")" + "UserControl cancelled by user.");
                    this.doCancel = true;
                    this.parentThread.interrupt();
                    return Status.CANCEL_STATUS;
                }
                try {
                    ProcessController.this.process.exitValue();
                    Debug.POLICY.trace(Debug.DEBUG_PROCESS, "(" + ProcessController.this.process.hashCode() + ")" + "Detected that process terminated.");
                    this.parentThread.interrupt();
                    return Status.OK_STATUS;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    try {
                        Thread.sleep(this.timeSlot);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            Debug.POLICY.trace(Debug.DEBUG_PROCESS, "(" + ProcessController.this.process.hashCode() + ")" + "Finished UserControl.");
            return Status.OK_STATUS;
        }
    }
}

