/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.rm.mpi.openmpi.core.Messages;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPIPlugin;
import org.osgi.framework.Bundle;

public class OpenMPI12Defaults {
    public static String LAUNCH_CMD = null;
    public static String DEBUG_CMD = null;
    public static String DISCOVER_CMD = null;
    public static String PATH = null;
    public static boolean USE_DEFAULTS = false;
    private static String defaultsResourcePath = "/data/defaults-OpenMPI-1.2.properties";

    public static void loadDefaults() throws CoreException {
        Path defaultsPropertiesPath = new Path(defaultsResourcePath);
        Bundle bundle = OpenMPIPlugin.getDefault().getBundle();
        Properties properties = OpenMPI12Defaults.read(defaultsPropertiesPath, bundle);
        LAUNCH_CMD = OpenMPI12Defaults.getString(bundle, properties, "LAUNCH_CMD");
        DEBUG_CMD = OpenMPI12Defaults.getString(bundle, properties, "DEBUG_CMD");
        DISCOVER_CMD = OpenMPI12Defaults.getString(bundle, properties, "DISCOVER_CMD");
        PATH = OpenMPI12Defaults.getString(bundle, properties, "PATH");
        USE_DEFAULTS = OpenMPI12Defaults.getBoolean(bundle, properties, "USE_DEFAULTS");
        assert (LAUNCH_CMD != null);
        assert (DEBUG_CMD != null);
        assert (DISCOVER_CMD != null);
        assert (PATH != null);
    }

    public static Properties read(Path defaultsPropertiesPath, Bundle bundle) throws CoreException {
        Properties properties = new Properties();
        try {
            InputStream inStream = FileLocator.openStream((Bundle)bundle, (IPath)defaultsPropertiesPath, (boolean)false);
            properties.load(inStream);
        }
        catch (IOException e) {
            throw OpenMPIPlugin.coreErrorException(Messages.OpenMPI12Defaults_Exception_FailedReadFile, e);
        }
        return properties;
    }

    public static String getString(Bundle bundle, Properties properties, String key) throws CoreException {
        String value = properties.getProperty(key);
        if (value == null) {
            throw new CoreException((IStatus)new Status(4, bundle.getSymbolicName(), NLS.bind((String)Messages.OpenMPI12Defaults_MissingValue, (Object)key)));
        }
        return value;
    }

    public static int getInteger(Bundle bundle, Properties properties, String key) throws CoreException {
        String value = OpenMPI12Defaults.getString(bundle, properties, key);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CoreException((IStatus)new Status(4, bundle.getSymbolicName(), NLS.bind((String)Messages.OpenMPI12Defaults_FailedParseInteger, (Object)key)));
        }
    }

    public static boolean getBoolean(Bundle bundle, Properties properties, String key) throws CoreException {
        String value = OpenMPI12Defaults.getString(bundle, properties, key);
        return Boolean.parseBoolean(value);
    }
}

