/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.ptp.core.attributes.AttributeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMPIProcessMap {
    private final AttributeManager attributeManager = new AttributeManager();
    private final List<Application> applications = new ArrayList<Application>();
    private final List<Node> nodes = new ArrayList<Node>();
    private final List<Process> processes = new ArrayList<Process>();

    public List<Process> getProcesses() {
        return Collections.unmodifiableList(this.processes);
    }

    public List<Node> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public List<Application> getAppContexts() {
        return Collections.unmodifiableList(this.applications);
    }

    public AttributeManager getAttributeManager() {
        return this.attributeManager;
    }

    void addApplication(Application application) {
        this.applications.add(application);
    }

    void addNode(Node node) {
        this.nodes.add(node);
    }

    void addProcess(Process process) {
        this.processes.add(process);
        process.node.processes.add(process);
    }

    public static class Application {
        private int index;
        private String name = new String();
        private final AttributeManager attributeManager = new AttributeManager();
        private int numberOfProcessors;

        public Application(int index, String applicationName, int numberOfProcessors) {
            this.index = index;
            this.name = applicationName;
            this.numberOfProcessors = numberOfProcessors;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public int getNumberOfProcessors() {
            return this.numberOfProcessors;
        }

        public AttributeManager getAttributeManager() {
            return this.attributeManager;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node {
        int index;
        private String name = null;
        private final AttributeManager attributeManager = new AttributeManager();
        private List<Process> processes = new ArrayList<Process>();

        public Node(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public AttributeManager getAttributeManager() {
            return this.attributeManager;
        }

        public List<Process> getProcesses() {
            return Collections.unmodifiableList(this.processes);
        }
    }

    public static class Process {
        private String name;
        private int index;
        private int applicationIndex;
        private Node node;
        private final AttributeManager attributeManager = new AttributeManager();

        public Process(Node node, int index, String name, int applicationIndex) {
            this.node = node;
            this.name = name;
            this.index = index;
            this.applicationIndex = applicationIndex;
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public int getApplicationIndex() {
            return this.applicationIndex;
        }

        public AttributeManager getAttributeManager() {
            return this.attributeManager;
        }

        public Node getNode() {
            return this.node;
        }
    }
}

