/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.attributes.IAttribute;
import org.eclipse.ptp.core.attributes.IllegalValueException;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPINodeAttributes;
import org.eclipse.ptp.rm.mpi.openmpi.core.OpenMPIPlugin;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.Messages;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIProcessMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class OpenMPIProcessMapXml13Parser {
    protected final OpenMPIProcessMap map = new OpenMPIProcessMap();
    protected final StackContextHandler handler = new StackContextHandler(new DocumentHandler());
    protected final ListenerList listeners = new ListenerList();

    private OpenMPIProcessMapXml13Parser() {
    }

    public static OpenMPIProcessMap parse(InputStream is) throws IOException {
        return OpenMPIProcessMapXml13Parser.parse(is, null);
    }

    public static OpenMPIProcessMap parse(InputStream is, IOpenMpiProcessMapXml13ParserListener listener) throws IOException {
        OpenMPIProcessMapXml13Parser parser = new OpenMPIProcessMapXml13Parser();
        if (listener != null) {
            parser.addListener(listener);
        }
        try {
            BufferedInputStream bis = new BufferedInputStream(is);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse((InputStream)bis, (DefaultHandler)parser.handler);
        }
        catch (ParseInterruptedException parseInterruptedException) {
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return parser.map;
    }

    public void addListener(IOpenMpiProcessMapXml13ParserListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IOpenMpiProcessMapXml13ParserListener listener) {
        this.listeners.remove((Object)listener);
    }

    public static void main(String[] args) {
        try {
            FileInputStream is = new FileInputStream("xml_sample.txt");
            OpenMPIProcessMapXml13Parser.parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private abstract class ContextHandler {
        private ContextHandler() {
        }

        public ContextHandler newElement(String name) throws SAXException {
            throw new UnknownElementException(name);
        }

        public void start() throws SAXException {
        }

        public void setAttribute(String name, String value) throws SAXException {
            throw new UnknownAttributeException(name);
        }

        public void prepare() throws SAXException {
        }

        public void finish() throws SAXException {
        }
    }

    private class DocumentHandler
    extends ContextHandler {
        private DocumentHandler() {
        }

        public ContextHandler newElement(String name) throws SAXException {
            if (name.equalsIgnoreCase("map")) {
                return new MapHandler();
            }
            if (name.equalsIgnoreCase("allocation")) {
                return null;
            }
            return super.newElement(name);
        }
    }

    public class HostHandler
    extends ContextHandler {
        private int host_counter = 0;
        private String name;
        private boolean has_num_slots = false;
        private boolean has_max_slots = false;
        private int num_slots = 0;
        private int max_slots = 0;
        private OpenMPIProcessMap.Node node;
        private List<OpenMPIProcessMap.Process> processes = new ArrayList<OpenMPIProcessMap.Process>();

        public ContextHandler newElement(String name) throws SAXException {
            if (name.equalsIgnoreCase("process")) {
                return new ProcessHandler(this.node);
            }
            return super.newElement(name);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setAttribute(String name, String value) throws SAXException {
            if (name.equalsIgnoreCase("name")) {
                this.name = value;
                return;
            } else if (name.equalsIgnoreCase("slots")) {
                try {
                    this.num_slots = Integer.parseInt(value);
                    if (this.num_slots < 0) {
                        throw new InvalidIntegerAttributeException(name, value);
                    }
                    this.has_num_slots = true;
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidIntegerAttributeException(name, value);
                }
            } else if (name.equalsIgnoreCase("max_slots")) {
                try {
                    this.max_slots = Integer.parseInt(value);
                    if (this.max_slots < 0) {
                        throw new InvalidIntegerAttributeException(name, value);
                    }
                    if (this.max_slots == 0) return;
                    this.has_max_slots = true;
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidIntegerAttributeException(name, value);
                }
            } else {
                super.setAttribute(name, value);
            }
        }

        public void prepare() throws SAXException {
            if (this.name == null) {
                throw new MissingAttributeException("name");
            }
            if (!this.has_num_slots) {
                throw new MissingAttributeException("slots");
            }
            this.node = new OpenMPIProcessMap.Node(this.host_counter++, this.name);
            OpenMPIProcessMapXml13Parser.this.map.addNode(this.node);
            try {
                this.node.getAttributeManager().addAttribute((IAttribute)OpenMPINodeAttributes.getNumberOfNodesAttributeDefinition().create(Integer.valueOf(this.num_slots)));
            }
            catch (IllegalValueException e) {
                OpenMPIPlugin.log(e);
            }
            if (this.has_max_slots) {
                try {
                    this.node.getAttributeManager().addAttribute((IAttribute)OpenMPINodeAttributes.getMaximalNumberOfNodesAttributeDefinition().create(Integer.valueOf(this.max_slots)));
                }
                catch (IllegalValueException e) {
                    OpenMPIPlugin.log(e);
                }
            }
            super.prepare();
        }

        public void finish() throws SAXException {
            assert (this.node != null);
            this.node.getAttributeManager().addAttribute((IAttribute)OpenMPINodeAttributes.getOversubscribedAttributeDefinition().create(Boolean.valueOf(this.processes.size() > this.num_slots)));
            super.finish();
        }
    }

    public static interface IOpenMpiProcessMapXml13ParserListener {
        public void startDocument();

        public void endDocument();
    }

    private class InvalidIntegerAttributeException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        public InvalidIntegerAttributeException(String name, String value) {
            super(NLS.bind((String)Messages.OpenMPIProcessMapXml13Parser_Exception_AttributeNotInteger, (Object)name, (Object)value));
        }
    }

    public class MapHandler
    extends ContextHandler {
        public ContextHandler newElement(String name) throws SAXException {
            if (name.equalsIgnoreCase("host")) {
                return new HostHandler();
            }
            return super.newElement(name);
        }

        public void finish() throws SAXException {
            super.finish();
            Object[] objectArray = OpenMPIProcessMapXml13Parser.this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                try {
                    ((IOpenMpiProcessMapXml13ParserListener)listener).endDocument();
                }
                catch (Exception e) {
                    OpenMPIPlugin.log(e);
                }
                ++n2;
            }
            throw new ParseInterruptedException();
        }
    }

    private class MissingAttributeException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        public MissingAttributeException(String name) {
            super(NLS.bind((String)Messages.OpenMPIProcessMapXml13Parser_Exception_MissingAttribute, (Object)name));
        }
    }

    private class ParseInterruptedException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        private ParseInterruptedException() {
        }
    }

    public class ProcessHandler
    extends ContextHandler {
        private OpenMPIProcessMap.Node node;
        private int rank;
        private boolean has_rank = false;

        public ProcessHandler(OpenMPIProcessMap.Node node) {
            this.node = node;
        }

        public void setAttribute(String name, String value) throws SAXException {
            if (name.equalsIgnoreCase("rank")) {
                try {
                    this.rank = Integer.parseInt(value);
                    if (this.rank < 0) {
                        throw new InvalidIntegerAttributeException(name, value);
                    }
                    this.has_rank = true;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidIntegerAttributeException(name, value);
                }
            } else {
                super.setAttribute(name, value);
            }
        }

        public void finish() throws SAXException {
            OpenMPIProcessMap.Process process = new OpenMPIProcessMap.Process(this.node, this.rank, Integer.toString(this.rank), 1);
            OpenMPIProcessMapXml13Parser.this.map.addProcess(process);
            super.finish();
        }
    }

    private class StackContextHandler
    extends DefaultHandler {
        Stack<ContextHandler> handlers = new Stack();

        public StackContextHandler(ContextHandler documentHandler) {
            this.handlers.push(documentHandler);
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            Object[] objectArray = OpenMPIProcessMapXml13Parser.this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                try {
                    ((IOpenMpiProcessMapXml13ParserListener)listener).startDocument();
                }
                catch (Exception e) {
                    OpenMPIPlugin.log(e);
                }
                ++n2;
            }
        }

        public void endDocument() throws SAXException {
            super.endDocument();
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, name, attributes);
            ContextHandler handler = this.handlers.peek();
            ContextHandler childHandler = null;
            if (handler != null && (childHandler = handler.newElement(name)) != null) {
                childHandler.start();
                int i = 0;
                while (i < attributes.getLength()) {
                    String attr_name = attributes.getQName(i);
                    String attr_value = attributes.getValue(i);
                    childHandler.setAttribute(attr_name, attr_value);
                    ++i;
                }
                childHandler.prepare();
            }
            this.handlers.push(childHandler);
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            super.endElement(uri, localName, name);
            ContextHandler handler = this.handlers.pop();
            if (handler != null) {
                handler.finish();
            }
        }

        public void error(SAXParseException e) throws SAXException {
            super.error(e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            super.fatalError(e);
        }
    }

    private class UnknownAttributeException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        public UnknownAttributeException(String name) {
            super(NLS.bind((String)Messages.OpenMPIProcessMapXml13Parser_Exception_UnknownAttribute, (Object)name));
        }
    }

    private class UnknownElementException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        public UnknownElementException(String name) {
            super(NLS.bind((String)Messages.OpenMPIProcessMapXml13Parser_Exception_UnknownElement, (Object)name));
        }
    }
}

