/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.core.attributes.AttributeDefinitionManager;
import org.eclipse.ptp.core.attributes.AttributeManager;
import org.eclipse.ptp.rm.core.rmsystem.AbstractEffectiveTollRMConfiguration;
import org.eclipse.ptp.rm.core.rmsystem.AbstractToolRMConfiguration;
import org.eclipse.ptp.rm.core.rtsystem.AbstractToolRuntimeSystem;
import org.eclipse.ptp.rm.mpi.openmpi.core.parameters.Parameters;
import org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem.EffectiveOpenMPIResourceManagerConfiguration;
import org.eclipse.ptp.rm.mpi.openmpi.core.rmsystem.OpenMPIResourceManagerConfiguration;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.Messages;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIDiscoverJob;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIHostMap;
import org.eclipse.ptp.rm.mpi.openmpi.core.rtsystem.OpenMPIRuntimeSystemJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMPIRuntimeSystem
extends AbstractToolRuntimeSystem {
    private Parameters params = new Parameters();
    private String machineID;
    private String queueID;
    private OpenMPIHostMap hostMap;
    private Map<String, String> hostToElementMap = new HashMap<String, String>();

    public OpenMPIRuntimeSystem(Integer openmpi_rmid, OpenMPIResourceManagerConfiguration config, AttributeDefinitionManager attrDefMgr) {
        super(openmpi_rmid, (AbstractToolRMConfiguration)config, attrDefMgr);
    }

    protected void setMachineID(String machineID) {
        this.machineID = machineID;
    }

    protected void setQueueID(String queueID) {
        this.queueID = queueID;
    }

    public String getMachineID() {
        return this.machineID;
    }

    public String getQueueID() {
        return this.queueID;
    }

    public Parameters getParameters() {
        return this.params;
    }

    public String getNodeIDforName(String hostname) {
        return this.hostToElementMap.get(hostname);
    }

    public OpenMPIHostMap getHostMap() {
        return this.hostMap;
    }

    protected void setHostMap(OpenMPIHostMap hostMap) {
        this.hostMap = hostMap;
    }

    public Map<String, String> getHostToElementMap() {
        return this.hostToElementMap;
    }

    protected void doShutdown(IProgressMonitor monitor) throws CoreException {
    }

    protected void doStartEvents() throws CoreException {
    }

    protected void doStartup(IProgressMonitor monitor) throws CoreException {
    }

    protected void doStopEvents() throws CoreException {
    }

    protected Job createDiscoverJob() {
        if (!this.rmConfiguration.hasDiscoverCmd()) {
            return null;
        }
        OpenMPIDiscoverJob job = new OpenMPIDiscoverJob(this);
        job.setPriority(10);
        job.setSystem(false);
        job.setUser(false);
        return job;
    }

    protected Job createPeriodicMonitorJob() {
        return null;
    }

    protected Job createContinuousMonitorJob() {
        return null;
    }

    public Job createRuntimeSystemJob(String jobID, String queueID, AttributeManager attrMgr) {
        return new OpenMPIRuntimeSystemJob(jobID, queueID, Messages.OpenMPIRuntimeSystem_JobName, this, attrMgr);
    }

    public AbstractEffectiveTollRMConfiguration retrieveEffectiveToolRmConfiguration() {
        return new EffectiveOpenMPIResourceManagerConfiguration(this.getRmConfiguration());
    }
}

