/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.ui;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elementcontrols.IResourceManagerControl;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.internal.ui.LaunchImages;
import org.eclipse.ptp.launch.messages.Messages;
import org.eclipse.ptp.launch.ui.LaunchConfigurationTab;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.rm.remote.core.AbstractRemoteResourceManagerConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ApplicationTab
extends LaunchConfigurationTab {
    protected Text projText = null;
    protected Text appText = null;
    protected Text localAppText = null;
    protected Button projButton = null;
    protected Button appButton = null;
    protected Button browseAppButton = null;
    protected Button localAppButton = null;
    protected Button consoleButton = null;
    protected WidgetListener listener = new WidgetListener();

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout());
        Composite mainComp = new Composite(comp, 0);
        mainComp.setLayout((Layout)this.createGridLayout(2, false, 0, 0));
        mainComp.setLayoutData((Object)new GridData(768));
        Label projLabel = new Label(mainComp, 0);
        projLabel.setText(Messages.ApplicationTab_Project_Label);
        projLabel.setLayoutData((Object)this.spanGridData(-1, 2));
        this.projText = new Text(mainComp, 2052);
        this.projText.setLayoutData((Object)new GridData(768));
        this.projText.addModifyListener((ModifyListener)this.listener);
        this.projButton = this.createPushButton(mainComp, Messages.Tab_common_Browse_1, null);
        this.projButton.addSelectionListener((SelectionListener)this.listener);
        this.createVerticalSpacer(comp, 1);
        Label appLabel = new Label(mainComp, 0);
        appLabel.setText(Messages.ApplicationTab_Application_Label);
        appLabel.setLayoutData((Object)this.spanGridData(-1, 2));
        this.appText = new Text(mainComp, 2052);
        this.appText.setLayoutData((Object)new GridData(768));
        this.appText.addModifyListener((ModifyListener)this.listener);
        this.appButton = this.createPushButton(mainComp, Messages.Tab_common_Browse_2, null);
        this.appButton.addSelectionListener((SelectionListener)this.listener);
        this.createVerticalSpacer(mainComp, 2);
        this.localAppButton = this.createCheckButton(mainComp, "Copy executable from local filesystem");
        this.localAppButton.setLayoutData((Object)new GridData(768));
        this.localAppButton.addSelectionListener((SelectionListener)this.listener);
        Label localAppLabel = new Label(mainComp, 0);
        localAppLabel.setText("Path to the local file:");
        localAppLabel.setLayoutData((Object)this.spanGridData(-1, 2));
        this.localAppText = new Text(mainComp, 2052);
        this.localAppText.setLayoutData((Object)new GridData(768));
        this.localAppText.addModifyListener((ModifyListener)this.listener);
        this.browseAppButton = this.createPushButton(mainComp, "Browse", null);
        this.browseAppButton.addSelectionListener((SelectionListener)this.listener);
        this.createVerticalSpacer(mainComp, 2);
        this.consoleButton = this.createCheckButton(mainComp, Messages.ApplicationTab_Console);
        this.consoleButton.setSelection(false);
        this.consoleButton.addSelectionListener((SelectionListener)this.listener);
    }

    public Image getImage() {
        return LaunchImages.getImage("org.eclipse.ptp.launch.main_tab.gif");
    }

    public String getName() {
        return Messages.ApplicationTab_Main;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            this.projText.setText(configuration.getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", ""));
            this.appText.setText(configuration.getAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", ""));
            this.localAppText.setText(configuration.getAttribute("org.eclipse.ptp.launch.ATTR_LOCAL_EXECUTABLE_PATH", ""));
            this.localAppButton.setSelection(configuration.getAttribute("org.eclipse.ptp.launch.ATTR_COPY_EXECUTABLE_FROM_LOCAL", false));
            this.consoleButton.setSelection(configuration.getAttribute("org.eclipse.ptp.launch.ATTR_CONSOLE", false));
        }
        catch (CoreException coreException) {
            this.setErrorMessage(Messages.CommonTab_common_Exception_occurred_reading_configuration_EXCEPTION);
        }
        this.handleLocalApplicationButtonSelected();
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.getFieldContent(this.projText.getText());
        if (name != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateName(name, 4);
            if (status.isOK()) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                if (!project.exists()) {
                    this.setErrorMessage(NLS.bind((String)Messages.ApplicationTab_Project_not_exist, (Object[])new Object[]{name}));
                    return false;
                }
                if (!project.isOpen()) {
                    this.setErrorMessage(NLS.bind((String)Messages.ApplicationTab_Project_is_closed, (Object[])new Object[]{name}));
                    return false;
                }
            } else {
                this.setErrorMessage(NLS.bind((String)Messages.ApplicationTab_Illegal_project, (Object[])new Object[]{status.getMessage()}));
                return false;
            }
        }
        if ((name = this.getFieldContent(this.appText.getText())) == null) {
            this.setErrorMessage(Messages.ApplicationTab_Application_program_not_specified);
            return false;
        }
        if (this.localAppButton.getSelection()) {
            File file;
            name = this.getFieldContent(this.localAppText.getText());
            if (name == null) {
                this.setErrorMessage("Local file not specified");
            }
            if (!(file = new File(name)).isAbsolute()) {
                this.setErrorMessage("Local file path must be absolute");
            }
            if (!file.exists() || !file.isFile()) {
                this.setErrorMessage("Local file must exist and be valid");
            }
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", this.getFieldContent(this.projText.getText()));
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", this.getFieldContent(this.appText.getText()));
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_COPY_EXECUTABLE_FROM_LOCAL", this.localAppButton.getSelection());
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_LOCAL_EXECUTABLE_PATH", this.getFieldContent(this.localAppText.getText()));
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_CONSOLE", this.consoleButton.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IProject project = this.getDefaultProject((ILaunchConfiguration)configuration);
        String projectName = null;
        if (project != null) {
            projectName = project.getName();
            String name = this.getLaunchConfigurationDialog().generateName(projectName);
            configuration.rename(name);
        }
        configuration.setAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", projectName);
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", null);
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_COPY_EXECUTABLE_FROM_LOCAL", null);
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_LOCAL_EXECUTABLE_PATH", false);
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
    }

    protected IResource chooseFile() {
        final IProject project = this.getProject();
        if (project == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ApplicationTab_Project_required, (String)Messages.ApplicationTab_Enter_project_before_browsing_for_program);
            return null;
        }
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        BaseWorkbenchContentProvider contentProvider = new BaseWorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setTitle(Messages.ApplicationTab_Program_selection);
        dialog.setMessage(Messages.ApplicationTab_Choose_program_to_run_from_NAME);
        dialog.setBlockOnOpen(true);
        dialog.setAllowMultiple(false);
        dialog.setInput((Object)project);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 0 || !(selection[0] instanceof IFile)) {
                    return new Status(4, PTPCorePlugin.getUniqueIdentifier(), 1, Messages.ApplicationTab_Selection_must_be_file, null);
                }
                try {
                    IResource resource = project.findMember(((IFile)selection[0]).getProjectRelativePath());
                    if (resource == null || resource.getType() != 1) {
                        return new Status(4, PTPCorePlugin.getUniqueIdentifier(), 1, Messages.ApplicationTab_Selection_must_be_file, null);
                    }
                    return new Status(0, PTPCorePlugin.getUniqueIdentifier(), 0, resource.getName(), null);
                }
                catch (Exception exception) {
                    return new Status(4, "org.eclipse.ptp.core", 1, Messages.ApplicationTab_Selection_must_be_file, null);
                }
            }
        });
        if (dialog.open() == 0) {
            return (IResource)dialog.getFirstResult();
        }
        return null;
    }

    protected IProject chooseProject() {
        Object[] projects = this.getWorkspaceRoot().getProjects();
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(Messages.ApplicationTab_Project_Selection_Title);
        dialog.setMessage(Messages.ApplicationTab_Project_Selection_Message);
        dialog.setElements(projects);
        IProject project = this.getProject();
        if (project != null) {
            dialog.setInitialSelections(new Object[]{project});
        }
        if (dialog.open() == 0) {
            return (IProject)dialog.getFirstResult();
        }
        return null;
    }

    protected IProject getDefaultProject(ILaunchConfiguration configuration) {
        IEditorInput input;
        IFile file;
        IEditorPart part;
        Object o;
        Object obj;
        IStructuredSelection ss;
        ISelection selection;
        String projectName = null;
        try {
            projectName = configuration.getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", null);
        }
        catch (CoreException coreException) {
            return null;
        }
        IWorkbenchPage page = PTPLaunchPlugin.getActivePage();
        if (projectName != null && !projectName.equals("")) {
            IProject project = this.getWorkspaceRoot().getProject(projectName);
            if (project != null && project.exists()) {
                return project;
            }
        } else if (page != null && (selection = page.getSelection()) instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty() && (obj = ss.getFirstElement()) instanceof IAdaptable && (o = ((IAdaptable)obj).getAdapter(IResource.class)) instanceof IResource) {
            return ((IResource)o).getProject();
        }
        if ((part = page.getActiveEditor()) != null && (file = (IFile)(input = part.getEditorInput()).getAdapter(IFile.class)) != null) {
            return file.getProject();
        }
        return null;
    }

    protected IProject getProject() {
        String projectName = this.projText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getWorkspaceRoot().getProject(projectName);
    }

    protected void handleApplicationButtonSelected() {
        IRemoteUIFileManager fileMgr;
        IRemoteConnection remCon;
        String initPath = this.appText.getText();
        if (initPath.equals("")) {
            IProject project = this.getProject();
            if (project == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ApplicationTab_Project_required, (String)Messages.ApplicationTab_Enter_project_before_browsing_for_program);
                return;
            }
            initPath = this.getProject().getLocationURI().getPath();
        }
        IResourceManager rm = this.getResourceManager(this.getLaunchConfiguration());
        AbstractRemoteResourceManagerConfiguration rmConf = (AbstractRemoteResourceManagerConfiguration)((IResourceManagerControl)rm).getConfiguration();
        IRemoteServices remServices = PTPRemoteCorePlugin.getDefault().getRemoteServices(rmConf.getRemoteServicesId());
        IRemoteUIServices remUIServices = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(remServices);
        if (remServices != null && remUIServices != null && (remCon = remServices.getConnectionManager().getConnection(rmConf.getConnectionName())) != null && (fileMgr = remUIServices.getUIFileManager()) != null) {
            fileMgr.setConnection(remCon);
            fileMgr.showConnections(false);
            IPath path = fileMgr.browseFile(this.getShell(), "Select application to execute", initPath);
            if (path != null) {
                this.appText.setText(path.toString());
            }
        }
    }

    protected void handleProjectButtonSelected() {
        IProject project = this.chooseProject();
        if (project == null) {
            return;
        }
        String projectName = project.getName();
        this.projText.setText(projectName);
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    protected void handleLocalApplicationButtonSelected() {
        this.localAppText.setEnabled(this.localAppButton.getSelection());
        this.browseAppButton.setEnabled(this.localAppButton.getSelection());
    }

    protected void handleBrowseLocalApplicationButtonSelected() {
        String initPath = this.localAppText.getText();
        if (initPath.equals("")) {
            IProject project = this.getProject();
            if (project == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ApplicationTab_Project_required, (String)Messages.ApplicationTab_Enter_project_before_browsing_for_program);
                return;
            }
            initPath = this.getProject().getLocationURI().getPath();
        }
        IRemoteServices localServices = PTPRemoteCorePlugin.getDefault().getRemoteServices("org.eclipse.ptp.remote.LocalServices");
        IRemoteUIServices localUIServices = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(localServices);
        if (localServices != null && localUIServices != null) {
            IRemoteConnectionManager lconnMgr = localServices.getConnectionManager();
            IRemoteConnection lconn = lconnMgr.getConnection(null);
            IRemoteUIFileManager localUIFileMgr = localUIServices.getUIFileManager();
            localUIFileMgr.setConnection(lconn);
            IPath path = localUIFileMgr.browseFile(this.getShell(), "Select the executable file to be copied", initPath);
            if (path != null) {
                this.localAppText.setText(path.toString());
            }
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            ApplicationTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == ApplicationTab.this.projButton) {
                ApplicationTab.this.handleProjectButtonSelected();
            } else if (source == ApplicationTab.this.appButton) {
                ApplicationTab.this.handleApplicationButtonSelected();
            } else if (source == ApplicationTab.this.consoleButton) {
                ApplicationTab.this.updateLaunchConfigurationDialog();
            } else if (source == ApplicationTab.this.localAppButton) {
                ApplicationTab.this.handleLocalApplicationButtonSelected();
                ApplicationTab.this.updateLaunchConfigurationDialog();
            } else if (source == ApplicationTab.this.browseAppButton) {
                ApplicationTab.this.handleBrowseLocalApplicationButtonSelected();
            }
        }
    }
}

