/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.remotesimulator.ui;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.ptp.cell.environment.remotesimulator.core.ConfigFactory;
import org.eclipse.ptp.cell.environment.remotesimulator.core.TargetControl;
import org.eclipse.ptp.cell.environment.remotesimulator.ui.Messages;
import org.eclipse.ptp.remotetools.utils.verification.ControlAttributes;
import org.eclipse.ptp.utils.ui.swt.AuthenticationFrame;
import org.eclipse.ptp.utils.ui.swt.AuthenticationFrameMold;
import org.eclipse.ptp.utils.ui.swt.ComboGroup;
import org.eclipse.ptp.utils.ui.swt.ComboGroupItem;
import org.eclipse.ptp.utils.ui.swt.TextGroup;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SimulatorConfigDialog
extends TitleAreaDialog {
    Composite dialogArea;
    AuthenticationFrame remoteSimGroup;
    ControlAttributes attributes;
    ControlAttributes originalAttributes;
    boolean hasError;

    public SimulatorConfigDialog(Shell parentShell, ControlAttributes attributes) {
        super(parentShell);
        this.attributes = attributes;
        try {
            this.originalAttributes = (ControlAttributes)attributes.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.SimulatorConfigDialog_RemoteSimulatorCustomConfigTitle);
        ((GridData)composite.getLayoutData()).widthHint = parent.getShell().getSize().y;
        AuthenticationFrameMold fmold = new AuthenticationFrameMold(Messages.SimulatorConfigDialog_Test);
        this.remoteSimGroup = new AuthenticationFrame(composite, fmold);
        this.remoteSimGroup.setLayoutData((Object)new GridData(1808));
        this.fillSimulatorConfigurationGroup();
        this.remoteSimGroup.addModifyListener((ModifyListener)new SimulatorConfigListener());
        return composite;
    }

    private void fillSimulatorConfigurationGroup() {
        this.fillTextGroup(this.remoteSimGroup.getHostAddrTextGroup(), "simulator-connection-address", ConfigFactory.DEFAULT_SIMULATOR_CONNECTION_ADDRESS);
        this.fillTextGroup(this.remoteSimGroup.getHostPortTextGroup(), "simulator-connection-port", Integer.toString(ConfigFactory.DEFAULT_SIMULATOR_CONNECTION_PORT));
        this.fillTextGroup(this.remoteSimGroup.getUsernameTextGroup(), "simulator-login-username", ConfigFactory.DEFAULT_SIMULATOR_LOGIN_USERNAME);
        this.fillTextGroup(this.remoteSimGroup.getPasswordTextGroup(), "simulator-login-password", ConfigFactory.DEFAULT_SIMULATOR_LOGIN_PASSWORD);
        this.fillTextGroup((TextGroup)this.remoteSimGroup.getPublicKeyPathGroup(), "simulator-key-path", ConfigFactory.DEFAULT_SIMULATOR_KEY_PATH);
        this.fillTextGroup(this.remoteSimGroup.getPassphraseTextGroup(), "simulator-key-passphrase", ConfigFactory.DEFAULT_SIMULATOR_KEY_PASSPHRASE);
        this.remoteSimGroup.setPasswordBased(this.attributes.getBooleanAttribute("remote-is-password-auth", ConfigFactory.DEFAULT_SIMULATOR_IS_PASSWORD_AUTH));
        this.fillTextGroup(this.remoteSimGroup.getTimeoutTextGroup(), "simulator-connection-timeout", Integer.toString(ConfigFactory.DEFAULT_SIMULATOR_CONNECTION_TIMEOUT));
        Map cipherMap = TargetControl.getCipherTypesMap();
        Set cKeySet = cipherMap.keySet();
        ComboGroup cipherGroup = this.remoteSimGroup.getCipherTypeGroup();
        for (String key : cKeySet) {
            String value = (String)cipherMap.get(key);
            cipherGroup.add(new ComboGroupItem(key, value));
        }
        cipherGroup.selectIndexUsingID(this.attributes.getString("simulator-cipher-type"));
    }

    void fillTextGroup(TextGroup tgroup, String key, String defaultValue) {
        Text tbox = tgroup.getText();
        tbox.setText(this.attributes.getStringAttribute(key, defaultValue));
    }

    public void validateFieldsAndUpdateInterface() {
        this.hasError = false;
        this.setErrorMessage(null);
        try {
            this.remoteSimGroup.validateFields();
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
            this.hasError = true;
        }
        this.getButton(0).setEnabled(!this.hasError);
    }

    protected void cancelPressed() {
        super.cancelPressed();
        this.attributes = this.originalAttributes;
    }

    public ControlAttributes getModifiedAttributes() {
        return this.attributes;
    }

    class SimulatorConfigListener
    implements ModifyListener {
        SimulatorConfigListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget instanceof Text) {
                String textValue = ((Text)e.widget).getText();
                if (e.widget == SimulatorConfigDialog.this.remoteSimGroup.getHostAddrTextGroup().getText()) {
                    SimulatorConfigDialog.this.attributes.setStringAttribute("simulator-connection-address", textValue);
                } else if (e.widget == SimulatorConfigDialog.this.remoteSimGroup.getHostPortTextGroup().getText()) {
                    SimulatorConfigDialog.this.attributes.setStringAttribute("simulator-connection-port", textValue);
                } else if (e.widget == SimulatorConfigDialog.this.remoteSimGroup.getUsernameTextGroup().getText()) {
                    SimulatorConfigDialog.this.attributes.setStringAttribute("simulator-login-username", textValue);
                } else if (e.widget == SimulatorConfigDialog.this.remoteSimGroup.getPasswordTextGroup().getText()) {
                    SimulatorConfigDialog.this.attributes.setStringAttribute("simulator-login-password", textValue);
                } else if (e.widget == SimulatorConfigDialog.this.remoteSimGroup.getPublicKeyPathGroup().getText()) {
                    SimulatorConfigDialog.this.attributes.setStringAttribute("simulator-key-path", textValue);
                } else if (e.widget == SimulatorConfigDialog.this.remoteSimGroup.getPassphraseTextGroup().getText()) {
                    SimulatorConfigDialog.this.attributes.setStringAttribute("simulator-key-passphrase", textValue);
                } else if (e.widget == SimulatorConfigDialog.this.remoteSimGroup.getTimeoutTextGroup().getText()) {
                    SimulatorConfigDialog.this.attributes.setStringAttribute("simulator-connection-timeout", textValue);
                }
            } else if (e.widget instanceof Button) {
                boolean boolValue = e.widget == SimulatorConfigDialog.this.remoteSimGroup.getAuthKindSelectionButtons()[0];
                SimulatorConfigDialog.this.attributes.setBooleanAttribute("remote-is-password-auth", boolValue);
            } else if (e.widget instanceof Combo) {
                SimulatorConfigDialog.this.attributes.setAttribute("simulator-cipher-type", SimulatorConfigDialog.this.remoteSimGroup.getSelectedCipherType().getId());
            }
            SimulatorConfigDialog.this.validateFieldsAndUpdateInterface();
        }
    }
}

