/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.manager;

import java.util.Observable;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.PDebugUtils;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.manager.IPDIEventRequestManager;
import org.eclipse.ptp.debug.core.pdi.request.IPDIEventRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIStopDebuggerRequest;
import org.eclipse.ptp.debug.internal.core.pdi.manager.AbstractPDIManager;

public class EventRequestManager
extends AbstractPDIManager
implements IPDIEventRequestManager {
    private EventRequestDispatchJob dispatchJob = new EventRequestDispatchJob();

    public EventRequestManager(IPDISession session) {
        super(session, false);
    }

    public void addEventRequest(IPDIEventRequest request) throws PDIException {
        if (!(request instanceof IPDIStopDebuggerRequest)) {
            if (request.getTasks().isEmpty()) {
                throw new PDIException(request.getTasks(), String.valueOf(request.getName()) + ": No tasks found");
            }
            if (this.session.getTaskManager().isAllPending(request.getTasks())) {
                throw new PDIException(request.getTasks(), String.valueOf(request.getName()) + ": Request tasks are in pending status.");
            }
        }
        this.dispatchJob.addEventRequest(request);
    }

    public boolean canExecute(IPDIEventRequest request) {
        return true;
    }

    public void cleanEventRequests() {
        this.session.getEventManager().removeAllRegisteredEventRequests();
        this.dispatchJob.cleanEventRequests();
    }

    public void deleteAllEventRequests() throws PDIException {
        this.dispatchJob.removeEventRequests();
    }

    public void deleteEventRequest(IPDIEventRequest request) throws PDIException {
        this.dispatchJob.removeEventRequest(request);
    }

    public void execute(IPDIEventRequest request) {
        this.session.getEventManager().registerEventRequest(request);
        request.execute(this.session.getDebugger());
        if (request.getStatus() == 1) {
            this.session.getEventManager().notifyEventRequest(request);
        }
    }

    public IPDIEventRequest[] getRequests() {
        return this.dispatchJob.getEventRequests();
    }

    public void shutdown() {
    }

    public void update(BitList tasks) throws PDIException {
    }

    public void update(Observable o, Object arg) {
        if (arg instanceof IPDIEventRequest) {
            this.dispatchJob.removeCurrentEventRequest();
        }
    }

    public class EventRequestDispatchJob
    extends Job {
        private Vector<IPDIEventRequest> fRequests;

        public EventRequestDispatchJob() {
            super("PTP Debug Request Job");
            this.fRequests = null;
            this.setSystem(true);
            this.fRequests = new Vector(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addEventRequest(IPDIEventRequest request) throws PDIException {
            Vector<IPDIEventRequest> vector = this.fRequests;
            synchronized (vector) {
                if (this.containEventRequest(request)) {
                    throw new PDIException(request.getTasks(), "[" + request.getName() + "] request is already added.");
                }
                PDebugUtils.println("Msg: EventRequestManager - addEventRequest(): Request: " + request);
                this.fRequests.add(request);
            }
            this.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanEventRequests() {
            Vector<IPDIEventRequest> vector = this.fRequests;
            synchronized (vector) {
                this.fRequests.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containEventRequest(IPDIEventRequest request) {
            Vector<IPDIEventRequest> vector = this.fRequests;
            synchronized (vector) {
                return this.fRequests.contains(request);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IPDIEventRequest getCurrentEventRequest() {
            Vector<IPDIEventRequest> vector = this.fRequests;
            synchronized (vector) {
                block4: {
                    if (!this.fRequests.isEmpty()) break block4;
                    return null;
                }
                return this.fRequests.get(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IPDIEventRequest[] getEventRequests() {
            Vector<IPDIEventRequest> vector = this.fRequests;
            synchronized (vector) {
                return this.fRequests.toArray(new IPDIEventRequest[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeCurrentEventRequest() {
            Vector<IPDIEventRequest> vector = this.fRequests;
            synchronized (vector) {
                if (!this.fRequests.isEmpty()) {
                    this.fRequests.remove(0);
                }
            }
            this.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeEventRequest(IPDIEventRequest request) throws PDIException {
            Vector<IPDIEventRequest> vector = this.fRequests;
            synchronized (vector) {
                if (request.getStatus() == 2) {
                    throw new PDIException(request.getTasks(), "[" + request.getName() + "] request cannot be deleted during executing.");
                }
                if (!this.containEventRequest(request)) {
                    throw new PDIException(request.getTasks(), "[" + request.getName() + "] request is not existed or already deleted.");
                }
                this.fRequests.remove(request);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeEventRequests() throws PDIException {
            Vector<IPDIEventRequest> vector = this.fRequests;
            synchronized (vector) {
                int end;
                int i = end = this.fRequests.size() - 1;
                while (i >= 0) {
                    this.removeEventRequest(this.fRequests.get(i));
                    this.fRequests.remove(i);
                    --i;
                }
            }
        }

        public IStatus run(IProgressMonitor monitor) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    PTPDebugCorePlugin.log(exception);
                }

                public void run() throws Exception {
                    EventRequestManager.this.execute(EventRequestDispatchJob.this.getCurrentEventRequest());
                }
            });
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldRun() {
            Vector<IPDIEventRequest> vector = this.fRequests;
            synchronized (vector) {
                return !this.fRequests.isEmpty() && this.getCurrentEventRequest().getStatus() == 5;
            }
        }
    }
}

