/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.parallel;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.perf.IPerformanceLaunchConfigurationConstants;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametricParameterTab
extends AbstractLaunchConfigurationTab
implements IPerformanceLaunchConfigurationConstants {
    private Button useParam;
    private Text processors;
    private Text optLevels;
    private Table argTab;
    private Table varTab;
    private Button allCom;
    private Text trial;
    private Text script;
    private Button scriptBrowse;
    private WidgetListener wl = new WidgetListener();
    private static final String weakError = "Checked parameters must have at most 1 flag/name and exactly as many variables a there are processor counts";

    public void createControl(Composite comp) {
        ScrolledComposite sparent = new ScrolledComposite(comp, 512);
        this.setControl((Control)sparent);
        final Composite parent = new Composite((Composite)sparent, 0);
        parent.setLayout((Layout)ParametricParameterTab.createGridLayout(3, false, 0, 0));
        parent.setLayoutData((Object)ParametricParameterTab.spanGridData(768, 5));
        this.createVerticalSpacer(parent, 3);
        this.useParam = new Button(parent, 32);
        this.useParam.setText("Enable Parametric Testing");
        this.useParam.addSelectionListener((SelectionListener)this.wl);
        GridData fill3 = new GridData(768);
        fill3.horizontalSpan = 3;
        Label lab = new Label(parent, 258);
        lab.setLayoutData((Object)fill3);
        lab = new Label(parent, 0);
        lab.setText("Optimization Levels");
        lab.setToolTipText("Leave blank for default, may not work with some compilers");
        this.optLevels = new Text(parent, 2048);
        this.optLevels.setLayoutData((Object)new GridData(768));
        this.optLevels.addModifyListener((ModifyListener)this.wl);
        lab = new Label(parent, 258);
        lab.setLayoutData((Object)fill3);
        lab = new Label(parent, 0);
        lab.setText("MPI Processes");
        this.processors = new Text(parent, 2048);
        this.processors.setLayoutData((Object)new GridData(768));
        this.processors.addModifyListener((ModifyListener)this.wl);
        lab = new Label(parent, 258);
        lab.setLayoutData((Object)fill3);
        this.allCom = new Button(parent, 32);
        this.allCom.setText("Run jobs for all combinations");
        this.allCom.setToolTipText("Perform one run for every combination of values: compiler * mpi-processes * arguments * environment-variables");
        this.allCom.addSelectionListener((SelectionListener)this.wl);
        lab = new Label(parent, 258);
        lab.setLayoutData((Object)fill3);
        this.argTab = this.makeArgTable(parent, "Name", "Values", "Application Arguments");
        lab = new Label(parent, 258);
        lab.setLayoutData((Object)fill3);
        this.varTab = this.makeArgTable(parent, "Name", "Values", "Environment Variables");
        lab = new Label(parent, 258);
        lab.setLayoutData((Object)fill3);
        lab = new Label(parent, 0);
        lab.setText("Analysis Application");
        this.script = new Text(parent, 2048);
        this.script.setLayoutData((Object)new GridData(768));
        this.script.addModifyListener((ModifyListener)this.wl);
        this.scriptBrowse = new Button(parent, 0);
        this.scriptBrowse.setText("Browse");
        this.scriptBrowse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(parent.getShell());
                fd.setText("Select a PerfExplorer script");
                String s = fd.open();
                if (s != null) {
                    ParametricParameterTab.this.script.setText(s);
                }
            }
        });
        int thisHeight = parent.computeSize((int)-1, (int)-1).y;
        sparent.setMinSize(400, thisHeight);
        sparent.setExpandHorizontal(true);
        sparent.setExpandVertical(true);
        sparent.setContent((Control)parent);
    }

    private Table makeArgTable(Composite suParent, String c1, String c2, String title) {
        Group parent = new Group(suParent, 0);
        parent.setLayout((Layout)ParametricParameterTab.createGridLayout(3, false, 0, 0));
        parent.setLayoutData((Object)ParametricParameterTab.spanGridData(768, 5));
        parent.setText(title);
        final Table argTab = new Table((Composite)parent, 2594);
        argTab.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    ParametricParameterTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        GridData tableGD = new GridData(768);
        tableGD.heightHint = 80;
        tableGD.horizontalSpan = 3;
        argTab.setLayoutData((Object)tableGD);
        GridData span2 = new GridData(768);
        span2.horizontalSpan = 2;
        TableColumn tc = new TableColumn(argTab, 0);
        tc.setText(c1);
        tc.setWidth(80);
        tc = new TableColumn(argTab, 0);
        tc.setText(c2);
        tc.setWidth(80);
        argTab.setHeaderVisible(true);
        TableEditor te = new TableEditor(argTab);
        te.horizontalAlignment = 16384;
        te.grabHorizontal = true;
        te.minimumWidth = 50;
        Label lab = new Label((Composite)parent, 0);
        lab.setText(c1);
        final Text flags = new Text((Composite)parent, 2048);
        flags.setLayoutData((Object)span2);
        lab = new Label((Composite)parent, 0);
        lab.setText(c2);
        final Text vars = new Text((Composite)parent, 2048);
        vars.setLayoutData((Object)span2);
        Button addVar = new Button((Composite)parent, 0);
        addVar.setText("Add");
        addVar.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem it = new TableItem(argTab, 0);
                it.setText(0, flags.getText());
                it.setText(1, vars.getText());
                ParametricParameterTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button removeVar = new Button((Composite)parent, 0);
        removeVar.setText("Remove");
        removeVar.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (argTab.getSelectionIndices().length > 0) {
                    argTab.remove(argTab.getSelectionIndices());
                    ParametricParameterTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        new Label((Composite)parent, 0);
        return argTab;
    }

    public String getName() {
        return "Parametric Study";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.processors.setText(configuration.getAttribute("processors to use in parametric study", "1"));
            this.optLevels.setText(configuration.getAttribute("compiler optimization levels to use in parametric study", ""));
            ParametricParameterTab.setTableList(this.argTab, configuration.getAttribute("argument names use in parametric study", null), configuration.getAttribute("argument values use in parametric study", null), configuration.getAttribute("tells which para args are checked", null));
            ParametricParameterTab.setTableList(this.varTab, configuration.getAttribute("env-var names to use in parametric study", null), configuration.getAttribute("env-var values to use in parametric study", null), configuration.getAttribute("tells which para vars are checked", null));
            this.useParam.setSelection(configuration.getAttribute("use the parametric analysis system", false));
            this.allCom.setSelection(configuration.getAttribute("use simple weak scaling in perf parametric tests", false));
            this.script.setText(configuration.getAttribute("path to the perfexplorer script to use in parametric study", ""));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static void setTableList(Table ta, List<String> data0, List<String> data1, List<String> checkList) {
        if (data0 == null || data1 == null) {
            return;
        }
        ta.removeAll();
        int i = 0;
        while (i < data0.size()) {
            TableItem ti = new TableItem(ta, 0);
            ti.setText(0, data0.get(i));
            ti.setText(1, data1.get(i));
            if (checkList.get(i).equals("1")) {
                ti.setChecked(true);
            }
            ++i;
        }
    }

    private static List<String> getTableList(Table table, int index) {
        TableItem[] tiA;
        ArrayList<String> l = new ArrayList<String>();
        TableItem[] tableItemArray = tiA = table.getItems();
        int n = tiA.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem it = tableItemArray[n2];
            l.add(it.getText(index));
            ++n2;
        }
        return l;
    }

    private static List<String> getTableChecks(Table table) {
        TableItem[] tiA;
        ArrayList<String> l = new ArrayList<String>();
        TableItem[] tableItemArray = tiA = table.getItems();
        int n = tiA.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem it = tableItemArray[n2];
            if (it.getChecked()) {
                l.add("1");
            } else {
                l.add("0");
            }
            ++n2;
        }
        return l;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("processors to use in parametric study", this.processors.getText());
        configuration.setAttribute("compiler optimization levels to use in parametric study", this.optLevels.getText());
        configuration.setAttribute("argument names use in parametric study", ParametricParameterTab.getTableList(this.argTab, 0));
        configuration.setAttribute("argument values use in parametric study", ParametricParameterTab.getTableList(this.argTab, 1));
        configuration.setAttribute("tells which para args are checked", ParametricParameterTab.getTableChecks(this.argTab));
        configuration.setAttribute("env-var names to use in parametric study", ParametricParameterTab.getTableList(this.varTab, 0));
        configuration.setAttribute("env-var values to use in parametric study", ParametricParameterTab.getTableList(this.varTab, 1));
        configuration.setAttribute("tells which para vars are checked", ParametricParameterTab.getTableChecks(this.varTab));
        configuration.setAttribute("use the parametric analysis system", this.useParam.getSelection());
        configuration.setAttribute("use simple weak scaling in perf parametric tests", this.allCom.getSelection());
        configuration.setAttribute("path to the perfexplorer script to use in parametric study", this.script.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        super.isValid(config);
        boolean all = this.allCom.getSelection();
        int numProcArgs = ParametricParameterTab.getComArgs(this.processors.getText()).size();
        boolean ok = ParametricParameterTab.checkTableCounts(this.argTab, numProcArgs, !all);
        if (!(ok &= ParametricParameterTab.checkTableCounts(this.varTab, numProcArgs, !all))) {
            this.setErrorMessage(weakError);
        }
        return ok;
    }

    private static boolean checkTableCounts(Table t, int n, boolean all) {
        TableItem[] tis;
        TableItem[] tableItemArray = tis = t.getItems();
        int n2 = tis.length;
        int n3 = 0;
        while (n3 < n2) {
            TableItem ti = tableItemArray[n3];
            if ((ti.getChecked() || all) && (ParametricParameterTab.getComArgs(ti.getText(0)).size() > 1 || ParametricParameterTab.getComArgs(ti.getText(1)).size() != n)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    protected static GridLayout createGridLayout(int columns, boolean isEqual, int mh, int mw) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = columns;
        gridLayout.makeColumnsEqualWidth = isEqual;
        gridLayout.marginHeight = mh;
        gridLayout.marginWidth = mw;
        return gridLayout;
    }

    protected static GridData spanGridData(int style, int space) {
        GridData gd = null;
        gd = style == -1 ? new GridData() : new GridData(style);
        gd.horizontalSpan = space;
        return gd;
    }

    static List<String> getComArgs(String combined) {
        StringTokenizer st = new StringTokenizer(combined, ",");
        ArrayList<String> numProcesses = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            numProcesses.add(st.nextToken());
        }
        return numProcesses;
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener,
    IPropertyChangeListener {
        protected WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ParametricParameterTab.this.updateLaunchConfigurationDialog();
        }

        public void propertyChange(PropertyChangeEvent event) {
            ParametricParameterTab.this.updateLaunchConfigurationDialog();
        }

        public void modifyText(ModifyEvent evt) {
            ParametricParameterTab.this.updateLaunchConfigurationDialog();
        }
    }
}

