/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.parallel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ptp.debug.core.launch.PLaunch;
import org.eclipse.ptp.perf.internal.BuildLaunchUtils;
import org.eclipse.ptp.perf.internal.PerfBuilder;
import org.eclipse.ptp.perf.internal.PerfLauncher;
import org.eclipse.ptp.perf.internal.PerfPostlaunch;
import org.eclipse.ptp.perf.internal.PerfStep;
import org.eclipse.ptp.perf.internal.PerformanceLaunchManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceParametricLaunchManager
extends PerformanceLaunchManager {
    private static final String tmp = "org.eclipse.ptp.rm.orte.ui.launchAttributes.numProcs";
    final Queue<ILaunchConfiguration> configs = new LinkedList<ILaunchConfiguration>();
    final Queue<PerfStep> steps = new LinkedList<PerfStep>();
    JobChangeAdapter tauChange = new JobChangeAdapter(){

        public void done(IJobChangeEvent event) {
            if (event.getJob() instanceof PerfPostlaunch) {
                try {
                    PerformanceParametricLaunchManager.this.configs.poll().delete();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (!PerformanceParametricLaunchManager.this.steps.isEmpty()) {
                System.out.println("About to run job " + PerformanceParametricLaunchManager.this.steps.size() + " " + PerformanceParametricLaunchManager.this.steps.element().getName());
                PerformanceParametricLaunchManager.this.steps.poll().schedule();
                System.out.println("Done.  Jobs left: " + PerformanceParametricLaunchManager.this.steps.size());
            }
        }
    };

    public PerformanceParametricLaunchManager(LaunchConfigurationDelegate delegate, String appNameAtt, String projNameAtt) {
        super(delegate, appNameAtt, projNameAtt);
    }

    public PerformanceParametricLaunchManager(LaunchConfigurationDelegate delegate, String appNameAtt, String projNameAtt, String appPathAtt) {
        super(delegate, appNameAtt, projNameAtt, appPathAtt);
    }

    static List<StringPair> getStringCombinations(String a, String b) {
        ArrayList<StringPair> combos = new ArrayList<StringPair>();
        List<String> aList = PerformanceParametricLaunchManager.getComArgs(a);
        List<String> bList = PerformanceParametricLaunchManager.getComArgs(b);
        for (String first : aList) {
            for (String second : bList) {
                combos.add(new StringPair(first, second));
            }
        }
        return combos;
    }

    static List<List<StringPair>> getListCombinations(List<String> a, List<String> b) {
        ArrayList<List<StringPair>> comCom = new ArrayList<List<StringPair>>();
        if (a.size() != b.size()) {
            return comCom;
        }
        int i = 0;
        while (i < a.size()) {
            comCom.add(PerformanceParametricLaunchManager.getStringCombinations(a.get(i), b.get(i)));
            ++i;
        }
        return comCom;
    }

    static List<List<StringPair>> unifyCombos(List<List<StringPair>> combos, int curDex) {
        ArrayList<List<StringPair>> allCom = new ArrayList<List<StringPair>>();
        if (combos.size() == 0) {
            return allCom;
        }
        if (curDex == combos.size() - 1) {
            int i = 0;
            while (i < combos.get(curDex).size()) {
                ArrayList<StringPair> jList = new ArrayList<StringPair>();
                jList.add(0, combos.get(curDex).get(i));
                allCom.add(jList);
                ++i;
            }
            return allCom;
        }
        List<List<StringPair>> someCom = PerformanceParametricLaunchManager.unifyCombos(combos, curDex + 1);
        int i = 0;
        while (i < combos.get(curDex).size()) {
            int j = 0;
            while (j < someCom.size()) {
                ArrayList<StringPair> jList = new ArrayList<StringPair>((Collection)someCom.get(j));
                jList.add(0, combos.get(curDex).get(i));
                allCom.add(jList);
                ++j;
            }
            ++i;
        }
        return allCom;
    }

    static List<String> getComboStrings(List<List<StringPair>> combos) {
        ArrayList<String> allCom = new ArrayList<String>();
        for (List<StringPair> sl : combos) {
            String agg = "";
            for (StringPair sp : sl) {
                agg = String.valueOf(agg) + sp.first + sp.second + " ";
            }
            allCom.add(agg);
        }
        return allCom;
    }

    static List<Map<String, String>> getComboMaps(List<List<StringPair>> combos) {
        ArrayList<Map<String, String>> allCom = new ArrayList<Map<String, String>>();
        for (List<StringPair> sl : combos) {
            LinkedHashMap<String, String> agg = new LinkedHashMap<String, String>();
            for (StringPair sp : sl) {
                agg.put(sp.first, sp.second);
            }
            allCom.add(agg);
        }
        return allCom;
    }

    static List<RunParams> getWeakParams(String procs, List<String> argNames, List<String> argVars, List<String> envNames, List<String> envVars) {
        ArrayList<RunParams> params = new ArrayList<RunParams>();
        List<String> numProcs = PerformanceParametricLaunchManager.getComArgs(procs);
        int i = 0;
        while (i < numProcs.size()) {
            String num = numProcs.get(i);
            String arg = null;
            HashMap<String, String> var = null;
            int j = 0;
            while (j < argNames.size()) {
                if (arg == null) {
                    arg = "";
                }
                List<String> av = PerformanceParametricLaunchManager.getComArgs(argVars.get(j));
                arg = String.valueOf(arg) + " " + argNames.get(j) + av.get(i);
                ++j;
            }
            j = 0;
            while (j < envNames.size()) {
                if (var == null) {
                    var = new HashMap<String, String>();
                }
                List<String> ev = PerformanceParametricLaunchManager.getComArgs(envVars.get(j));
                var.put(envNames.get(j), ev.get(i));
                ++j;
            }
            params.add(new RunParams(Integer.parseInt(num), arg, var));
            ++i;
        }
        return params;
    }

    static List<RunParams> getRunParams(String procs, List<String> argNames, List<String> argVars, List<String> argBools, List<String> envNames, List<String> envVars, List<String> envBools) {
        ArrayList<RunParams> params = new ArrayList<RunParams>();
        List<String> numProcs = PerformanceParametricLaunchManager.getComArgs(procs);
        ArrayList<StringPair> checkedArgs = new ArrayList<StringPair>();
        int i = 0;
        while (i < argBools.size()) {
            if (argBools.get(i).equals("1")) {
                argBools.remove(i);
                checkedArgs.add(new StringPair(argNames.remove(i), argVars.remove(i)));
                continue;
            }
            ++i;
        }
        ArrayList<StringPair> checkedVars = new ArrayList<StringPair>();
        i = 0;
        while (i < envBools.size()) {
            if (envBools.get(i).equals("1")) {
                envBools.remove(i);
                checkedVars.add(new StringPair(envNames.remove(i), envVars.remove(i)));
                continue;
            }
            ++i;
        }
        List<String> args = PerformanceParametricLaunchManager.getComboStrings(PerformanceParametricLaunchManager.unifyCombos(PerformanceParametricLaunchManager.getListCombinations(argNames, argVars), 0));
        List<Map<String, String>> vars = PerformanceParametricLaunchManager.getComboMaps(PerformanceParametricLaunchManager.unifyCombos(PerformanceParametricLaunchManager.getListCombinations(envNames, envVars), 0));
        if (args.size() == 0) {
            args.add(null);
        }
        if (vars.size() == 0) {
            vars.add(null);
        }
        i = 0;
        while (i < numProcs.size()) {
            String num = numProcs.get(i);
            for (String arg : args) {
                for (Map<String, String> var : vars) {
                    if (checkedArgs.size() > 0) {
                        if (arg == null) {
                            arg = "";
                        }
                        for (StringPair sp : checkedArgs) {
                            arg = String.valueOf(arg) + " " + sp.getFirst() + PerformanceParametricLaunchManager.getComArgs(sp.getSecond()).get(i);
                        }
                    }
                    if (checkedVars.size() > 0) {
                        if (var == null) {
                            var = new HashMap<String, String>();
                        }
                        for (StringPair sp : checkedVars) {
                            var.put(sp.getFirst(), PerformanceParametricLaunchManager.getComArgs(sp.getSecond()).get(i));
                        }
                    }
                    params.add(new RunParams(Integer.parseInt(num), arg, var));
                }
            }
            ++i;
        }
        return params;
    }

    static List<String> getComArgs(String combined) {
        StringTokenizer st = new StringTokenizer(combined, ",");
        ArrayList<String> numProcesses = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            numProcesses.add(st.nextToken());
        }
        return numProcesses;
    }

    public static String makeTauAtt(String name, String value) {
        String att = "\n<tau:attribute>\n<tau:name>" + name + "</tau:name>\n<tau:value>" + value + "</tau:value>\n</tau:attribute>";
        return att;
    }

    public static String mapToString(Map<String, String> map) {
        String out = "";
        Iterator<Map.Entry<String, String>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            out = String.valueOf(out) + e.getKey() + "=" + e.getValue();
            if (!it.hasNext()) continue;
            out = String.valueOf(out) + ", ";
        }
        return out;
    }

    public static String makeTauAtts(Map<String, String> map, String prefix) {
        String atts = "";
        for (Map.Entry<String, String> e : map.entrySet()) {
            atts = String.valueOf(atts) + PerformanceParametricLaunchManager.makeTauAtt(String.valueOf(prefix) + e.getKey(), e.getValue());
        }
        return atts;
    }

    public static String getTauMetadata(Map<String, String> build, RunParams par) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<tau:metadata xmlns:tau=\"http://www.cs.uoregon.edu/research/tau\">\n<tau:CommonProfileAttributes>";
        if (build != null) {
            xml = String.valueOf(xml) + PerformanceParametricLaunchManager.makeTauAtts(build, "BUILD:");
        }
        if (par.args != null) {
            xml = String.valueOf(xml) + PerformanceParametricLaunchManager.makeTauAtt("ApplicationArguments", par.args);
        }
        if (par.vars != null) {
            xml = String.valueOf(xml) + PerformanceParametricLaunchManager.makeTauAtts(par.vars, "ENV:");
        }
        xml = String.valueOf(xml) + "\n</tau:CommonProfileAttributes>\n</tau:metadata>";
        return xml;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launchIn, IProgressMonitor monitor) throws CoreException {
        String processorOptionString = configuration.getAttribute("processors to use in parametric study", "1");
        List argNames = configuration.getAttribute("argument names use in parametric study", null);
        List argVars = configuration.getAttribute("argument values use in parametric study", null);
        List argBools = configuration.getAttribute("tells which para args are checked", null);
        List varNames = configuration.getAttribute("env-var names to use in parametric study", null);
        List varVars = configuration.getAttribute("env-var values to use in parametric study", null);
        List varBools = configuration.getAttribute("tells which para vars are checked", null);
        String timestamp = BuildLaunchUtils.getNow();
        boolean allCom = configuration.getAttribute("use simple weak scaling in perf parametric tests", false);
        List<RunParams> params = null;
        params = !allCom ? PerformanceParametricLaunchManager.getWeakParams(processorOptionString, argNames, argVars, varNames, varVars) : PerformanceParametricLaunchManager.getRunParams(processorOptionString, argNames, argVars, argBools, varNames, varVars, varBools);
        System.out.println(params.size());
        for (RunParams param : params) {
            System.out.println("Num Processors: " + param.numProcs);
            if (param.args != null) {
                System.out.println("Program args: " + param.args);
            }
            System.out.println("Env args: ");
            if (param.vars == null) continue;
            for (Map.Entry<String, String> env : param.vars.entrySet()) {
                System.out.println(env);
            }
        }
        String optLevStr = configuration.getAttribute("compiler optimization levels to use in parametric study", "");
        List<String> optLevs = PerformanceParametricLaunchManager.getComArgs(optLevStr);
        ArrayList buildopts = new ArrayList();
        if (optLevs.size() == 0) {
            buildopts.add(null);
        } else {
            block10: for (String s : optLevs) {
                String lev = null;
                HashMap<String, String> hm = null;
                switch (Integer.parseInt(s)) {
                    case 0: {
                        lev = "None (-O0)";
                        break;
                    }
                    case 1: {
                        lev = "Optimize (-O1)";
                        break;
                    }
                    case 2: {
                        lev = "Optimize more (-O2)";
                        break;
                    }
                    case 3: {
                        lev = "Optimize most (-O3)";
                        break;
                    }
                    default: {
                        continue block10;
                    }
                }
                if (lev == null) continue;
                hm = new HashMap<String, String>();
                hm.put("Optimization Level", lev);
                buildopts.add(hm);
            }
        }
        int numruns = 0;
        int bDex = 0;
        while (bDex < buildopts.size()) {
            Map optM = (Map)buildopts.get(bDex);
            PerfBuilder builder = new PerfBuilder(configuration, this.projNameAttribute, this.appPathAttribute, optM);
            this.steps.add((PerfStep)builder);
            builder.addJobChangeListener((IJobChangeListener)this.tauChange);
            try {
                builder.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            int lDex = 0;
            while (lDex < params.size()) {
                RunParams param = params.get(lDex);
                int numProcs = param.numProcs;
                System.out.println("doing " + numProcs + " processors...");
                ILaunchConfigurationWorkingCopy wc = configuration.copy(String.valueOf(configuration.getName()) + " ParameterSet_" + numruns);
                wc.setAttribute(tmp, numProcs);
                wc.setAttribute("string representation of xml metadata file for perfexplorer", PerformanceParametricLaunchManager.getTauMetadata(optM, param));
                wc.setAttribute("string that will override the default experiment identifier used in perfdmf storage", timestamp);
                if (param.args != null) {
                    String arg = wc.getAttribute("org.eclipse.ptp.launch.ARGUMENT_ATTR", "");
                    arg = String.valueOf(arg) + " " + param.args;
                    wc.setAttribute("org.eclipse.ptp.launch.ARGUMENT_ATTR", arg);
                }
                if (param.vars != null) {
                    HashMap<String, String> envvars = null;
                    envvars = wc.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
                    if (envvars == null) {
                        envvars = new HashMap<String, String>();
                    }
                    envvars.putAll(param.vars);
                    wc.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, envvars);
                }
                wc.setAttribute("launch perfexplorer along with other tau profile management activity", false);
                if (bDex == buildopts.size() - 1 && lDex == params.size() - 1) {
                    wc.setAttribute("launch perfexplorer along with other tau profile management activity", true);
                }
                ILaunchConfiguration tmpConfig = wc.doSave();
                this.configs.add(tmpConfig);
                PLaunch launch = new PLaunch(tmpConfig, launchIn.getLaunchMode(), launchIn.getSourceLocator());
                PerfLauncher launcher = new PerfLauncher(tmpConfig, this.appNameAttribute, this.projNameAttribute, this.appPathAttribute, builder.getProgramPath(), this.paraDel, (ILaunch)launch);
                this.steps.add((PerfStep)launcher);
                PerfPostlaunch analyzer = new PerfPostlaunch(tmpConfig, this.projNameAttribute, builder.getOutputLocation());
                this.steps.add((PerfStep)analyzer);
                launcher.addJobChangeListener((IJobChangeListener)this.tauChange);
                analyzer.addJobChangeListener((IJobChangeListener)this.tauChange);
                ++numruns;
                ++lDex;
            }
            ++bDex;
        }
        if (this.steps.size() > 0) {
            this.steps.poll().schedule();
        } else {
            System.out.println("No performance analysis jobs constructed");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RunParams {
        int numProcs;
        String args;
        Map<String, String> vars;

        public RunParams(int numProcs, String args, Map<String, String> vars) {
            this.args = args;
            this.numProcs = numProcs;
            this.vars = vars;
        }
    }

    static class StringPair {
        private String first;
        private String second;

        public String getFirst() {
            return this.first;
        }

        public void setFirst(String first) {
            this.first = first;
        }

        public String getSecond() {
            return this.second;
        }

        public void setSecond(String second) {
            this.second = second;
        }

        public StringPair(String first, String second) {
            this.first = first;
            this.second = second;
        }
    }
}

