/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.rse.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ptp.remote.core.AbstractRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.rse.core.RSEConnection;
import org.eclipse.ptp.remote.rse.core.RSEProcess;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSEProcessBuilder
extends AbstractRemoteProcessBuilder {
    private static final String EXIT_CMD = "exit";
    private static final String CMD_DELIMITER = ";";
    private RSEConnection connection;
    private Map<String, String> remoteEnv = new HashMap<String, String>();

    public RSEProcessBuilder(IRemoteConnection conn, List<String> command) {
        super(conn, command);
        this.connection = (RSEConnection)conn;
        IShellService shellService = this.connection.getRemoteShellService();
        try {
            String[] env = shellService.getHostEnvironment();
            this.populateEnvironmentMap(env);
        }
        catch (SystemMessageException systemMessageException) {}
    }

    private void populateEnvironmentMap(String[] env) {
        int k = 0;
        while (k < env.length) {
            int pos = env[k].indexOf("=");
            assert (pos != -1);
            this.remoteEnv.put(env[k].substring(0, pos), env[k].substring(pos + 1));
            ++k;
        }
    }

    private String[] getEnvironment() {
        String[] env = new String[this.remoteEnv.size()];
        int pos = 0;
        for (Map.Entry<String, String> entry : this.remoteEnv.entrySet()) {
            env[pos++] = String.valueOf(entry.getKey()) + "=" + entry.getValue();
        }
        return env;
    }

    public RSEProcessBuilder(IRemoteConnection conn, String ... command) {
        this(conn, Arrays.asList(command));
    }

    public Map<String, String> environment() {
        return this.remoteEnv;
    }

    public IRemoteProcess start() throws IOException {
        List cmdArgs = this.command();
        if (cmdArgs.size() < 1) {
            throw new IndexOutOfBoundsException();
        }
        String remoteCmd = "";
        int i = 0;
        while (i < cmdArgs.size()) {
            if (i > 0) {
                remoteCmd = String.valueOf(remoteCmd) + " ";
            }
            remoteCmd = String.valueOf(remoteCmd) + this.spaceEscapify((String)cmdArgs.get(i));
            ++i;
        }
        remoteCmd = String.valueOf(remoteCmd) + ";exit";
        IShellService shellService = this.connection.getRemoteShellService();
        if (shellService == null) {
            throw new IOException("Remote service not found");
        }
        IHostShell hostShell = null;
        try {
            String initialDir = "";
            if (this.directory() != null) {
                initialDir = this.directory().toURI().getPath();
            }
            hostShell = shellService.runCommand(initialDir, remoteCmd, this.getEnvironment(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (SystemMessageException e) {
            e.printStackTrace();
            return null;
        }
        return new RSEProcess(hostShell);
    }

    private String spaceEscapify(String inputString) {
        if (inputString == null) {
            return null;
        }
        return inputString.replaceAll(" ", "\\\\ ");
    }
}

