/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.analysis;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPIBlock;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPICallGraphNode;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPISSA;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.UseDefBuilder;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.Util;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.IBlock;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraph;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.ICallGraphNode;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.IControlFlowGraph;

public class MPIDUChain {
    protected ICallGraph cg_;
    protected Hashtable<String, List<IBlock>> defTable_;
    protected IControlFlowGraph cfg_;

    public MPIDUChain(ICallGraph cg) {
        this.cg_ = cg;
    }

    public void run() {
        UseDefBuilder ud = new UseDefBuilder(this.cg_);
        ud.run();
        MPISSA ssa = new MPISSA(this.cg_);
        ssa.run();
        this.DUChain();
    }

    protected void GenKillSet() {
        IBlock b = this.cfg_.getEntry();
        while (b != null) {
            MPIBlock block = (MPIBlock)b;
            Enumeration<String> e = this.defTable_.keys();
            while (e.hasMoreElements()) {
                String var = e.nextElement();
                block.getGen().put(var, new ArrayList());
                block.getKill().put(var, new ArrayList());
                block.getIn().put(var, new ArrayList());
                block.getOut().put(var, new ArrayList());
                block.getDUPred().put(var, new ArrayList());
                block.getDUSucc().put(var, new ArrayList());
            }
            List<String> def = block.getDef();
            for (String var : def) {
                ArrayList<MPIBlock> genlist = new ArrayList<MPIBlock>();
                genlist.add(block);
                block.getGen().put(var, genlist);
                List killlist = (List)((ArrayList)this.defTable_.get(var)).clone();
                killlist.remove((Object)block);
                block.getKill().put(var, killlist);
            }
            b = b.topNext();
        }
    }

    protected void ReachingDefinition() {
        IBlock b = this.cfg_.getEntry();
        while (b != null) {
            MPIBlock block = (MPIBlock)b;
            block.setOut((Hashtable)block.getGen().clone());
            b = b.topNext();
        }
        boolean change = true;
        while (change) {
            change = false;
            IBlock b2 = this.cfg_.getEntry();
            while (b2 != null) {
                MPIBlock block = (MPIBlock)b2;
                Hashtable<String, List<IBlock>> in = block.getIn();
                for (MPIBlock pred : block.getPreds()) {
                    Enumeration<String> e = in.keys();
                    while (e.hasMoreElements()) {
                        String var = e.nextElement();
                        in.put(var, Util.Union(in.get(var), pred.getOut().get(var)));
                    }
                }
                Hashtable<String, List<IBlock>> out = block.getOut();
                Enumeration<String> e = out.keys();
                while (e.hasMoreElements()) {
                    String var = e.nextElement();
                    List outlist = Util.Union(block.getGen().get(var), Util.Minus(in.get(var), block.getKill().get(var)));
                    if (Util.equals(outlist, out.get(var))) continue;
                    change = true;
                    out.put(var, outlist);
                }
                b2 = b2.topNext();
            }
        }
    }

    protected void FlowDependence() {
        IBlock b = this.cfg_.getEntry();
        while (b != null) {
            MPIBlock block = (MPIBlock)b;
            Hashtable<String, List<IBlock>> in = block.getIn();
            Enumeration<String> e = in.keys();
            while (e.hasMoreElements()) {
                String var = e.nextElement();
                if (!block.getUse().contains(var)) continue;
                List<IBlock> pred = block.getDUPred().get(var);
                for (MPIBlock mPIBlock : in.get(var)) {
                    List<IBlock> succ = mPIBlock.getDUSucc().get(var);
                    pred.add((IBlock)mPIBlock);
                    succ.add((IBlock)block);
                }
            }
            b = b.topNext();
        }
    }

    protected void DUChain() {
        ICallGraphNode n = this.cg_.botEntry();
        while (n != null) {
            MPICallGraphNode node = (MPICallGraphNode)n;
            if (node.marked) {
                if (node.getFuncName().equals("Moc_KWayFM")) {
                    System.out.println("MPIDUChain.DUChain(): Moc_KWayFM " + node.getFuncName());
                }
                this.cfg_ = node.getCFG();
                this.defTable_ = node.getDefTable();
                this.GenKillSet();
                this.ReachingDefinition();
                this.FlowDependence();
            }
            n = n.botNext();
        }
    }
}

