/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.index;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.internal.rdt.core.model.BindingAdapter;
import org.eclipse.ptp.internal.rdt.core.model.CElement;
import org.eclipse.ptp.internal.rdt.core.model.ICProjectFactory;
import org.eclipse.ptp.internal.rdt.core.model.TranslationUnit;

public class IndexQueries {
    private static final ICElement[] EMPTY_ELEMENTS = new ICElement[0];

    public static IIndexBinding elementToBinding(IIndex index, ICElement element) throws CoreException {
        if (element instanceof ISourceReference) {
            String name = element.getElementName();
            name = name.substring(name.lastIndexOf(58) + 1);
            IIndexBinding[] bindings = index.findBindings(name.toCharArray(), IndexFilter.ALL, (IProgressMonitor)new NullProgressMonitor());
            int i = 0;
            while (i < bindings.length) {
                IIndexBinding binding = bindings[i];
                if (IndexQueries.checkBinding(binding, element)) {
                    return binding;
                }
                ++i;
            }
        }
        return null;
    }

    private static boolean checkBinding(IIndexBinding binding, ICElement element) {
        try {
            switch (element.getElementType()) {
                case 63: {
                    return binding instanceof IEnumeration;
                }
                case 61: {
                    return binding instanceof ICPPNamespace;
                }
                case 66: 
                case 67: {
                    return binding instanceof ICompositeType && ((ICompositeType)binding).getKey() == 1;
                }
                case 64: 
                case 65: {
                    return binding instanceof ICPPClassType && ((ICompositeType)binding).getKey() == 3;
                }
                case 68: 
                case 69: {
                    return binding instanceof ICompositeType && ((ICompositeType)binding).getKey() == 2;
                }
                case 80: {
                    return binding instanceof ITypedef;
                }
                case 70: 
                case 71: {
                    return binding instanceof ICPPMethod;
                }
                case 72: {
                    return binding instanceof IField;
                }
                case 73: 
                case 74: {
                    return binding instanceof ICPPFunction && !(binding instanceof ICPPMethod);
                }
                case 76: 
                case 77: {
                    return binding instanceof IVariable;
                }
                case 81: {
                    return binding instanceof IEnumerator;
                }
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: {
                    return binding instanceof ICPPClassTemplate;
                }
                case 88: 
                case 89: {
                    return binding instanceof ICPPFunctionTemplate && !(binding instanceof ICPPMethod);
                }
                case 90: 
                case 91: {
                    return binding instanceof ICPPFunctionTemplate && binding instanceof ICPPMethod;
                }
                case 92: {
                    return binding instanceof ICPPTemplateParameter;
                }
            }
        }
        catch (DOMException dOMException) {}
        return false;
    }

    public static IIndexName elementToName(IIndex index, ICElement element) throws CoreException {
        IIndexFileLocation location;
        ISourceReference sf;
        ITranslationUnit tu;
        if (element instanceof ISourceReference && (tu = (sf = (ISourceReference)element).getTranslationUnit()) != null && (location = IndexLocationFactory.getIFL((ITranslationUnit)tu)) != null) {
            IIndexFile[] files = index.getFiles(location);
            int i = 0;
            while (i < files.length) {
                IIndexFile file = files[i];
                String elementName = element.getElementName();
                int idx = elementName.lastIndexOf(":") + 1;
                ISourceRange pos = sf.getSourceRange();
                int offset = pos.getIdStartPos() + idx;
                int length = pos.getIdLength() - idx;
                IIndexName[] names = file.findNames(offset, length);
                int j = 0;
                while (j < names.length) {
                    IIndexName name = names[j];
                    if (!name.isReference() && elementName.endsWith(new String(name.toCharArray()))) {
                        return name;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public static IIndexName remoteElementToName(IIndex index, ICElement element) throws CoreException {
        ISourceReference sf;
        ITranslationUnit tu;
        if (element instanceof ISourceReference && (tu = (sf = (ISourceReference)element).getTranslationUnit()) != null) {
            URI uri = null;
            try {
                uri = IndexQueries.convertRemoteURIToLocal(tu.getLocationURI());
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            IndexFileLocation location = null;
            if (uri != null) {
                location = new IndexFileLocation(uri, uri.getPath());
            }
            if (location != null) {
                IIndexFile[] files = index.getFiles(location);
                int i = 0;
                while (i < files.length) {
                    IIndexFile file = files[i];
                    String elementName = element.getElementName();
                    int idx = elementName.lastIndexOf(":") + 1;
                    ISourceRange pos = sf.getSourceRange();
                    int offset = pos.getIdStartPos() + idx;
                    int length = pos.getIdLength() - idx;
                    IIndexName[] names = file.findNames(offset, length);
                    int j = 0;
                    while (j < names.length) {
                        IIndexName name = names[j];
                        if (!name.isReference() && elementName.endsWith(new String(name.toCharArray()))) {
                            return name;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private static URI convertRemoteURIToLocal(URI locationURI) throws URISyntaxException {
        URI uri = new URI("file", null, locationURI.getPath(), null);
        return uri;
    }

    public static boolean isIndexed(IIndex index, ICElement element) throws CoreException {
        IIndexFileLocation location;
        ISourceReference sf;
        ITranslationUnit tu;
        if (element instanceof ISourceReference && (tu = (sf = (ISourceReference)element).getTranslationUnit()) != null && (location = IndexLocationFactory.getIFL((ITranslationUnit)tu)) != null) {
            IIndexFile[] files = index.getFiles(location);
            return files.length > 0;
        }
        return false;
    }

    public static IIndexInclude elementToInclude(IIndex index, IInclude include) throws CoreException {
        IIndexFile[] files;
        int j;
        IIndexFileLocation location;
        ITranslationUnit tu;
        if (include != null && (tu = include.getTranslationUnit()) != null && (location = IndexLocationFactory.getIFL((ITranslationUnit)tu)) != null && (j = 0) < (files = index.getFiles(location)).length) {
            IIndexFile file = files[j];
            String elementName = include.getElementName();
            elementName = elementName.substring(elementName.lastIndexOf(47) + 1);
            ISourceRange pos = include.getSourceRange();
            int offset = pos.getIdStartPos();
            IIndexInclude[] includes = index.findIncludes(file);
            int bestDiff = Integer.MAX_VALUE;
            IIndexInclude best = null;
            int i = 0;
            while (i < includes.length) {
                IIndexInclude candidate = includes[i];
                int diff = Math.abs(candidate.getNameOffset() - offset);
                if (diff > bestDiff) break;
                if (candidate.getName().endsWith(elementName)) {
                    bestDiff = diff;
                    best = candidate;
                }
                ++i;
            }
            return best;
        }
        return null;
    }

    public static ICElement[] findRepresentative(IIndex index, IBinding binding, IIndexLocationConverter converter, ICProject preferProject, ICProjectFactory projectFactory) throws CoreException {
        ICElement elem;
        ICElement[] defs = IndexQueries.findAllDefinitions(index, binding, converter, preferProject, projectFactory);
        if (defs.length == 0 && (elem = IndexQueries.findAnyDeclaration(index, null, binding, converter, projectFactory)) != null) {
            defs = new ICElement[]{elem};
        }
        return defs;
    }

    public static ICElement[] findAllDefinitions(IIndex index, IBinding binding, IIndexLocationConverter converter, ICProject preferProject, ICProjectFactory projectFactory) throws CoreException {
        if (binding != null) {
            IIndexName[] defs = index.findNames(binding, 10);
            ArrayList<ICElement> result = new ArrayList<ICElement>();
            int i = 0;
            while (i < defs.length) {
                IIndexName in = defs[i];
                ICElement definition = IndexQueries.getCElementForName(preferProject, index, in, converter, projectFactory);
                if (definition != null) {
                    result.add(definition);
                }
                ++i;
            }
            return result.toArray(new ICElement[result.size()]);
        }
        return EMPTY_ELEMENTS;
    }

    public static ICElement getCElementForName(ICProject preferProject, IIndex index, IASTName declName, IIndexLocationConverter converter, ICProjectFactory projectFactory) throws CoreException {
        assert (!declName.isReference());
        IBinding binding = declName.resolveBinding();
        if (binding != null) {
            ITranslationUnit tu;
            ICProject cProject = preferProject;
            if (preferProject == null) {
                cProject = projectFactory.getProjectForFile(declName.getFileLocation().getFileName());
            }
            if ((tu = IndexQueries.getTranslationUnit(cProject, (IName)declName, converter)) != null) {
                IASTFileLocation loc = declName.getFileLocation();
                try {
                    return BindingAdapter.adaptBinding(tu, binding, loc.getNodeOffset(), loc.getNodeLength(), declName.isDefinition());
                }
                catch (DOMException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rdt.core", "", (Throwable)e));
                }
            }
        }
        return null;
    }

    public static ITranslationUnit getTranslationUnit(ICProject cproject, IName name, IIndexLocationConverter converter) {
        return IndexQueries.getTranslationUnit(cproject, name.getFileLocation(), converter);
    }

    private static ITranslationUnit getTranslationUnit(ICProject cproject, IASTFileLocation fileLocation, IIndexLocationConverter converter) {
        if (converter == null) {
            throw new IllegalArgumentException();
        }
        if (fileLocation != null) {
            IPath path = Path.fromOSString((String)fileLocation.getFileName());
            if (converter != null) {
                IIndexFileLocation location = converter.fromInternalFormat(fileLocation.getFileName());
                TranslationUnit unit = new TranslationUnit((ICElement)cproject, path.lastSegment(), cproject == null ? null : cproject.getElementName(), location.getURI());
                return unit;
            }
        }
        return null;
    }

    public static ICElement getCElementForName(ICProject preferProject, IIndex index, IIndexName declName, IIndexLocationConverter converter, ICProjectFactory projectFactory) throws CoreException {
        ITranslationUnit tu;
        assert (!declName.isReference());
        ICProject cProject = preferProject;
        if (preferProject == null) {
            cProject = projectFactory.getProjectForFile(declName.getFileLocation().getFileName());
        }
        if ((tu = IndexQueries.getTranslationUnit(cProject, (IName)declName, converter)) != null) {
            return IndexQueries.getCElementForName(tu, index, declName, projectFactory);
        }
        return null;
    }

    public static ICElement getCElementForName(ITranslationUnit tu, IIndex index, IIndexName declName, ICProjectFactory projectFactory) throws CoreException {
        try {
            return BindingAdapter.adaptBinding(tu, (IBinding)index.findBinding((IName)declName), declName.getNodeOffset(), declName.getNodeLength(), declName.isDefinition());
        }
        catch (DOMException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rdt.core", "", (Throwable)e));
        }
    }

    public static ICElement findAnyDeclaration(IIndex index, ICProject preferProject, IBinding binding, IIndexLocationConverter converter, ICProjectFactory projectFactory) throws CoreException {
        if (binding != null) {
            IIndexName[] names = index.findNames(binding, 1);
            int i = 0;
            while (i < names.length) {
                ICElement elem = IndexQueries.getCElementForName(preferProject, index, names[i], converter, projectFactory);
                if (elem != null) {
                    return elem;
                }
                ++i;
            }
        }
        return null;
    }

    public static ICElement attemptConvertionToHandle(IIndex index, ICElement input, IIndexLocationConverter converter, ICProjectFactory projectFactory) throws CoreException {
        ICElement handle;
        if (input instanceof CElement) {
            return input;
        }
        IIndexName name = IndexQueries.elementToName(index, input);
        if (name != null && (handle = IndexQueries.getCElementForName(input.getCProject(), index, name, converter, projectFactory)) != null) {
            return handle;
        }
        return input;
    }

    public static IASTName getSelectedName(IIndex index, ITranslationUnit workingCopy, int selectionStart, int selectionLength) throws CoreException {
        if (workingCopy == null) {
            return null;
        }
        int options = 2;
        IASTTranslationUnit ast = workingCopy.getAST(index, options);
        return ast.getNodeSelector(null).findEnclosingName(selectionStart, selectionLength);
    }
}

