/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.model;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.BufferChangedEvent;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.IProblemRequestor;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.DefaultLogService;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.rdt.core.miners.StandaloneSavedCodeReaderFactory;
import org.eclipse.ptp.internal.rdt.core.model.CProject;
import org.eclipse.ptp.internal.rdt.core.model.Parent;

public class TranslationUnit
extends Parent
implements ITranslationUnit {
    private static final long serialVersionUID = 1L;
    Class<? extends ILanguage> fLanguageClass;
    protected transient ILanguage fLanguage;
    private IScannerInfo fScannerInfo;

    public TranslationUnit(ICElement parent, String name, String projectName, URI locationURI) {
        super(parent, 60, name);
        if (projectName == null || locationURI == null) {
            throw new IllegalArgumentException();
        }
        this.setCProject(new CProject(projectName));
        this.fLocation = locationURI;
    }

    public TranslationUnit(Parent parent, ITranslationUnit element) {
        super(parent, element.getElementType(), element.getElementName());
        ICProject project = element.getCProject();
        if (project instanceof CProject) {
            this.setCProject(project);
        } else if (project != null) {
            this.setCProject(new CProject(project.getElementName()));
        } else {
            throw new IllegalArgumentException();
        }
        try {
            this.setLanguage(element.getLanguage());
        }
        catch (CoreException e) {
            throw new IllegalArgumentException(e);
        }
        this.setLocationURI(element.getLocationURI());
    }

    public IInclude createInclude(String name, boolean isStd, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        return null;
    }

    public INamespace createNamespace(String namespace, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        return null;
    }

    public IUsing createUsing(String name, boolean isDirective, ICElement sibling, IProgressMonitor monitor) throws CModelException {
        return null;
    }

    public IWorkingCopy findSharedWorkingCopy(IBufferFactory bufferFactory) {
        return null;
    }

    public IASTTranslationUnit getAST() throws CoreException {
        return this.getAST(null, 0);
    }

    public void setASTContext(IScannerInfo scannerInfo) {
        this.fScannerInfo = scannerInfo;
    }

    public void setLanguage(ILanguage language) {
        this.fLanguage = language;
        this.fLanguageClass = language == null ? null : language.getClass();
    }

    public IASTTranslationUnit getAST(IIndex index, int style) throws CoreException {
        this.checkState();
        if (this.fLanguage != null && this.fScannerInfo != null && this.fLocation != null) {
            DefaultLogService log = new DefaultLogService();
            StandaloneSavedCodeReaderFactory fileCreator = StandaloneSavedCodeReaderFactory.getInstance();
            String filePath = this.fLocation.getPath();
            int options = style | this.getParserOptions(filePath);
            CodeReader reader = this.getCodeReader();
            return this.fLanguage.getASTTranslationUnit(reader, this.fScannerInfo, (ICodeReaderFactory)fileCreator, index, options, (IParserLogService)log);
        }
        return null;
    }

    public CodeReader getCodeReader() {
        if (this.fLocation == null) {
            return null;
        }
        String filePath = this.fLocation.getPath();
        try {
            return new CodeReader(filePath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IASTCompletionNode getCompletionNode(IIndex index, int style, int offset) throws CoreException {
        this.checkState();
        if (this.fLanguage != null && this.fScannerInfo != null && this.fLocation != null) {
            DefaultLogService log = new DefaultLogService();
            StandaloneSavedCodeReaderFactory fileCreator = StandaloneSavedCodeReaderFactory.getInstance();
            CodeReader reader = this.getCodeReader();
            return this.fLanguage.getCompletionNode(reader, this.fScannerInfo, (ICodeReaderFactory)fileCreator, index, (IParserLogService)log, offset);
        }
        return null;
    }

    public String getContentTypeId() {
        return null;
    }

    public char[] getContents() {
        return null;
    }

    public ICElement getElement(String name) throws CModelException {
        return null;
    }

    public ICElement getElementAtLine(int line) throws CModelException {
        return null;
    }

    public ICElement getElementAtOffset(int offset) throws CModelException {
        return null;
    }

    public ICElement[] getElementsAtOffset(int offset) throws CModelException {
        return null;
    }

    public IInclude getInclude(String name) {
        return null;
    }

    public IInclude[] getIncludes() throws CModelException {
        return null;
    }

    public ILanguage getLanguage() throws CoreException {
        this.checkState();
        return this.fLanguage;
    }

    public IPath getLocation() {
        return null;
    }

    public INamespace getNamespace(String name) {
        return null;
    }

    public INamespace[] getNamespaces() throws CModelException {
        return null;
    }

    public IScannerInfo getScannerInfo(boolean force) {
        return null;
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws CModelException {
        return null;
    }

    public IWorkingCopy getSharedWorkingCopy(IProgressMonitor monitor, IBufferFactory factory, IProblemRequestor requestor) throws CModelException {
        return null;
    }

    public IUsing getUsing(String name) {
        return null;
    }

    public IUsing[] getUsings() throws CModelException {
        return null;
    }

    public IWorkingCopy getWorkingCopy() throws CModelException {
        return null;
    }

    public IWorkingCopy getWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws CModelException {
        return null;
    }

    public boolean isASMLanguage() {
        return false;
    }

    public boolean isCLanguage() {
        return false;
    }

    public boolean isCXXLanguage() {
        return false;
    }

    public boolean isHeaderUnit() {
        return false;
    }

    public boolean isSourceUnit() {
        return false;
    }

    public boolean isWorkingCopy() {
        return false;
    }

    public Map parse() {
        return null;
    }

    public void setIsStructureKnown(boolean wasSuccessful) {
    }

    public void close() throws CModelException {
    }

    public IBuffer getBuffer() throws CModelException {
        return null;
    }

    public boolean hasUnsavedChanges() throws CModelException {
        return false;
    }

    public boolean isConsistent() throws CModelException {
        return false;
    }

    public boolean isOpen() {
        return false;
    }

    public void makeConsistent(IProgressMonitor progress) throws CModelException {
    }

    public void makeConsistent(IProgressMonitor progress, boolean forced) throws CModelException {
    }

    public void open(IProgressMonitor progress) throws CModelException {
    }

    public void save(IProgressMonitor progress, boolean force) throws CModelException {
    }

    public void bufferChanged(BufferChangedEvent event) {
    }

    public String getSource() throws CModelException {
        return null;
    }

    public ISourceRange getSourceRange() throws CModelException {
        return null;
    }

    public ITranslationUnit getTranslationUnit() {
        return null;
    }

    public void copy(ICElement container, ICElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws CModelException {
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CModelException {
    }

    public void move(ICElement container, ICElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws CModelException {
    }

    public void rename(String name, boolean replace, IProgressMonitor monitor) throws CModelException {
    }

    public IProblemRequestor getProblemRequestor() {
        return null;
    }

    private void checkState() {
        if (this.fLanguage == null && this.fLanguageClass != null) {
            try {
                this.fLanguage = this.fLanguageClass.newInstance();
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public int getParserOptions(String filePath) {
        if (filePath.endsWith(".cpp") || filePath.endsWith(".C") || filePath.endsWith(".c")) {
            return 8;
        }
        return 0;
    }
}

