/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;

public class CFunctionType
implements IFunctionType {
    IType[] parameters = null;
    IType returnType = null;

    public CFunctionType(IType returnType, IType[] types) {
        this.returnType = returnType;
        this.parameters = types;
    }

    public boolean isSameType(IType o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ITypedef) {
            return o.isSameType(this);
        }
        if (o instanceof IFunctionType) {
            IType[] fps;
            IFunctionType ft = (IFunctionType)o;
            try {
                fps = ft.getParameterTypes();
            }
            catch (DOMException dOMException) {
                return false;
            }
            if (fps.length != this.parameters.length) {
                return false;
            }
            try {
                if (!this.returnType.isSameType(ft.getReturnType())) {
                    return false;
                }
            }
            catch (DOMException dOMException) {
                return false;
            }
            int i = 0;
            while (i < this.parameters.length) {
                if (!this.parameters[i].isSameType(fps[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public IType getReturnType() {
        return this.returnType;
    }

    public IType[] getParameterTypes() {
        return this.parameters;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }
}

