/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArraySet;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticUtil {
    private static final char[] OPERATOR_CHARS = "operator".toCharArray();
    private static final CharArraySet cas = new CharArraySet(OverloadableOperator.values().length);

    static {
        int OPERATOR_SPC = OPERATOR_CHARS.length + 1;
        OverloadableOperator[] overloadableOperatorArray = OverloadableOperator.values();
        int n = overloadableOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            OverloadableOperator op = overloadableOperatorArray[n2];
            char[] name = op.toCharArray();
            cas.put(CharArrayUtils.subarray(name, OPERATOR_SPC, name.length));
            ++n2;
        }
    }

    public static final ICPPMethod[] getDeclaredConversionOperators(ICPPClassType clazz) throws DOMException {
        ICPPMethod[] decs;
        Object[] methods = new ICPPMethod[]{};
        if (clazz instanceof ICPPDeferredClassInstance) {
            clazz = (ICPPClassType)((Object)((ICPPDeferredClassInstance)clazz).getTemplateDefinition());
        }
        if ((decs = clazz.getDeclaredMethods()) != null) {
            ICPPMethod[] iCPPMethodArray = decs;
            int n = decs.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPMethod method = iCPPMethodArray[n2];
                if (SemanticUtil.isConversionOperator(method)) {
                    methods = (ICPPMethod[])ArrayUtil.append(ICPPMethod.class, methods, method);
                }
                ++n2;
            }
        }
        return methods;
    }

    public static ICPPMethod[] getConversionOperators(ICPPClassType clazz) throws DOMException {
        Object[] methods = new ICPPMethod[]{};
        ObjectSet<ICPPClassType> ancestry = SemanticUtil.inheritanceClosure(clazz);
        int i = 0;
        while (i < ancestry.size()) {
            methods = (ICPPMethod[])ArrayUtil.addAll(ICPPMethod.class, methods, SemanticUtil.getDeclaredConversionOperators((ICPPClassType)ancestry.keyAt(i)));
            ++i;
        }
        return methods;
    }

    public static ObjectSet<ICPPClassType> inheritanceClosure(ICPPClassType root) throws DOMException {
        ObjectSet<ICPPClassType> done = new ObjectSet<ICPPClassType>(2);
        ObjectSet<ICPPClassType> current = new ObjectSet<ICPPClassType>(2);
        current.put(root);
        int count = 0;
        while (count < 10 && !current.isEmpty()) {
            ObjectSet<ICPPClassType> next = new ObjectSet<ICPPClassType>(2);
            int i = 0;
            while (i < current.size()) {
                ICPPClassType clazz = (ICPPClassType)current.keyAt(i);
                done.put(clazz);
                ICPPBase[] iCPPBaseArray = clazz.getBases();
                int n = iCPPBaseArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPClassType ct;
                    ICPPBase base = iCPPBaseArray[n2];
                    IBinding binding = base.getBaseClass();
                    if (binding instanceof ICPPClassType && !(binding instanceof IProblemBinding) && !done.containsKey(ct = (ICPPClassType)binding)) {
                        next.put(ct);
                    }
                    ++n2;
                }
                ++i;
            }
            current = next;
            ++count;
        }
        return done;
    }

    public static final boolean isConversionOperator(ICPPMethod method) {
        char[] name;
        boolean result = false;
        if (!method.isImplicit() && (name = method.getNameCharArray()).length > OPERATOR_CHARS.length + 1 && CharArrayUtils.equals(name, 0, OPERATOR_CHARS.length, OPERATOR_CHARS) && name[OPERATOR_CHARS.length] == ' ') {
            result = !cas.containsKey(name, OPERATOR_CHARS.length + 1, name.length - (OPERATOR_CHARS.length + 1));
        }
        return result;
    }

    public static IType getUltimateType(IType type, boolean stopAtPointerToMember) {
        return SemanticUtil.getUltimateType(type, null, stopAtPointerToMember);
    }

    static IType getUltimateType(IType type, IType[] lastPointerType, boolean stopAtPointerToMember) {
        try {
            while (true) {
                if (type instanceof ITypedef) {
                    IType tt = ((ITypedef)type).getType();
                    if (tt == null) {
                        return type;
                    }
                    type = tt;
                    continue;
                }
                if (type instanceof IQualifierType) {
                    type = ((IQualifierType)type).getType();
                    continue;
                }
                if (stopAtPointerToMember && type instanceof ICPPPointerToMemberType) {
                    return type;
                }
                if (type instanceof IPointerType) {
                    if (lastPointerType != null) {
                        lastPointerType[0] = type;
                    }
                    type = ((IPointerType)type).getType();
                    continue;
                }
                if (!(type instanceof ICPPReferenceType)) break;
                type = ((ICPPReferenceType)type).getType();
            }
            return type;
        }
        catch (DOMException e) {
            return e.getProblem();
        }
    }

    public static IType getUltimateTypeUptoPointers(IType type) {
        try {
            while (true) {
                if (type instanceof ITypedef) {
                    IType tt = ((ITypedef)type).getType();
                    if (tt == null) {
                        return type;
                    }
                    type = tt;
                    continue;
                }
                if (type instanceof IQualifierType) {
                    type = ((IQualifierType)type).getType();
                    continue;
                }
                if (!(type instanceof ICPPReferenceType)) break;
                type = ((ICPPReferenceType)type).getType();
            }
            return type;
        }
        catch (DOMException e) {
            return e.getProblem();
        }
    }

    static IType getUltimateTypeViaTypedefs(IType type) {
        try {
            while (type instanceof ITypedef) {
                IType t = ((ITypedef)type).getType();
                if (t == null) {
                    return type;
                }
                type = t;
            }
        }
        catch (DOMException e) {
            type = e.getProblem();
        }
        return type;
    }

    static IType getSimplifiedType(IType type) {
        try {
            if (type instanceof IFunctionType) {
                IType ret = null;
                IType[] params = null;
                IType r = ((IFunctionType)type).getReturnType();
                ret = SemanticUtil.getSimplifiedType(r);
                IType[] ps = ((IFunctionType)type).getParameterTypes();
                params = SemanticUtil.getSimplifiedTypes(ps);
                if (ret == r && params == ps) {
                    return type;
                }
                return new CPPFunctionType(ret, params, ((ICPPFunctionType)type).getThisType());
            }
            if (type instanceof ITypeContainer) {
                IType nestedType = ((ITypeContainer)type).getType();
                if (nestedType == null) {
                    return type;
                }
                IType newType = SemanticUtil.getSimplifiedType(nestedType);
                if (newType != nestedType) {
                    type = (IType)type.clone();
                    ((ITypeContainer)type).setType(newType);
                    return type;
                }
                return type;
            }
        }
        catch (DOMException dOMException) {}
        return type;
    }

    public static IType[] getSimplifiedTypes(IType[] types) {
        IType[] result = types;
        int i = 0;
        while (i < types.length) {
            IType type = types[i];
            IType newType = SemanticUtil.getSimplifiedType(type);
            if (result != types) {
                result[i] = newType;
            } else if (type != newType) {
                result = new IType[types.length];
                if (i > 0) {
                    System.arraycopy(types, 0, result, 0, i);
                }
                result[i] = newType;
            }
            ++i;
        }
        return result;
    }
}

