/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.internal.core.model.DebugLogConstants;
import org.eclipse.cdt.internal.core.parser.InternalParserUtil;
import org.eclipse.cdt.internal.core.parser.ParserLogService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserUtil {
    private static IParserLogService parserLogService = new ParserLogService(DebugLogConstants.PARSER);
    private static IParserLogService scannerLogService = new ParserLogService(DebugLogConstants.SCANNER);

    public static IParserLogService getParserLogService() {
        return parserLogService;
    }

    public static IParserLogService getScannerLogService() {
        return scannerLogService;
    }

    public static char[] findWorkingCopyBuffer(String path, Iterator<IWorkingCopy> workingCopies) {
        IResource resultingResource = ParserUtil.getResourceForFilename(path);
        if (resultingResource != null && resultingResource.getType() == 1 && workingCopies.hasNext()) {
            return ParserUtil.findWorkingCopy(resultingResource, workingCopies);
        }
        return null;
    }

    public static CodeReader createReader(String finalPath, Iterator<IWorkingCopy> workingCopies) {
        block9: {
            CodeReader codeReader;
            block10: {
                char[] buffer;
                IResource resultingResource = ParserUtil.getResourceForFilename(finalPath);
                if (resultingResource == null || resultingResource.getType() != 1) break block9;
                if (workingCopies != null && workingCopies.hasNext() && (buffer = ParserUtil.findWorkingCopy(resultingResource, workingCopies)) != null) {
                    return new CodeReader(finalPath, buffer);
                }
                InputStream in = null;
                try {
                    in = ((IFile)resultingResource).getContents();
                    codeReader = new CodeReader(finalPath, ((IFile)resultingResource).getCharset(), in);
                    if (in == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                        throw throwable;
                    }
                    catch (CoreException coreException) {
                        break block9;
                    }
                    catch (IOException iOException) {
                        break block9;
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
                in.close();
            }
            return codeReader;
        }
        return InternalParserUtil.createFileReader(finalPath);
    }

    public static IResource getResourceForFilename(String finalPath) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return null;
        }
        Path path = new Path(finalPath);
        Path initialPath = new Path(finalPath);
        IWorkspaceRoot root = workspace.getRoot();
        if (root.getLocation().isPrefixOf((IPath)path)) {
            path = path.removeFirstSegments(root.getLocation().segmentCount());
        }
        try {
            IFile[] files;
            IFile resultingResource = root.getFile((IPath)path);
            if (resultingResource != null && resultingResource.exists()) {
                return resultingResource;
            }
            resultingResource = root.getFileForLocation((IPath)path);
            if (resultingResource != null && resultingResource.exists()) {
                return resultingResource;
            }
            IFile[] iFileArray = files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)initialPath);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file.isAccessible()) {
                    return file;
                }
                ++n2;
            }
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    protected static char[] findWorkingCopy(IResource resultingResource, Iterator<IWorkingCopy> workingCopies) {
        if (parserLogService.isTracing()) {
            parserLogService.traceLog("Attempting to find the working copy for " + resultingResource.getName());
        }
        while (workingCopies.hasNext()) {
            IWorkingCopy copy = workingCopies.next();
            if (!resultingResource.equals((Object)copy.getResource())) continue;
            if (parserLogService.isTracing()) {
                parserLogService.traceLog("Working copy found!!");
            }
            return copy.getContents();
        }
        if (parserLogService.isTracing()) {
            parserLogService.traceLog("Working copy not found.");
        }
        return null;
    }
}

