/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.util;

import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtil {
    private static final int DEFAULT_LENGTH = 2;

    public static Object[] append(Class<?> c, Object[] array, Object obj) {
        if (obj == null) {
            return array;
        }
        if (array == null || array.length == 0) {
            array = (Object[])Array.newInstance(c, 2);
            array[0] = obj;
            return array;
        }
        int i = ArrayUtil.findFirstNull(array);
        if (i >= 0) {
            array[i] = obj;
            return array;
        }
        Object[] temp = (Object[])Array.newInstance(c, array.length * 2);
        System.arraycopy(array, 0, temp, 0, array.length);
        temp[array.length] = obj;
        return temp;
    }

    private static int findFirstNull(Object[] array) {
        boolean haveNull = false;
        int left = 0;
        int right = array.length - 1;
        while (left <= right) {
            int mid = (left + right) / 2;
            if (array[mid] == null) {
                haveNull = true;
                right = mid - 1;
                continue;
            }
            left = mid + 1;
        }
        return haveNull ? right + 1 : -1;
    }

    public static Object[] append(Class<?> c, Object[] array, int currentLength, Object obj) {
        if (obj == null) {
            return array;
        }
        if (array == null || array.length == 0) {
            array = (Object[])Array.newInstance(c, 2);
            array[0] = obj;
            return array;
        }
        if (currentLength < array.length) {
            assert (array[currentLength] == null);
            assert (currentLength == 0 || array[currentLength - 1] != null);
            array[currentLength] = obj;
            return array;
        }
        Object[] temp = (Object[])Array.newInstance(c, array.length * 2);
        System.arraycopy(array, 0, temp, 0, array.length);
        temp[array.length] = obj;
        return temp;
    }

    public static Object[] append(Object[] array, Object obj) {
        return ArrayUtil.append(Object.class, array, obj);
    }

    public static Object[] trim(Class<?> c, Object[] array, boolean forceNew) {
        if (array == null) {
            return (Object[])Array.newInstance(c, 0);
        }
        int i = array.length;
        if (i == 0 || array[i - 1] != null) {
            if (!forceNew) {
                return array;
            }
        } else {
            i = ArrayUtil.findFirstNull(array);
            assert (i >= 0);
        }
        Object[] temp = (Object[])Array.newInstance(c, i);
        System.arraycopy(array, 0, temp, 0, i);
        return temp;
    }

    public static Object[] trim(Class<?> c, Object[] array) {
        return ArrayUtil.trim(c, array, false);
    }

    public static Object[] addAll(Class<?> c, Object[] dest, Object[] source) {
        if (source == null || source.length == 0) {
            return dest;
        }
        int numToAdd = ArrayUtil.findFirstNull(source);
        if (numToAdd <= 0) {
            if (numToAdd == 0) {
                return dest;
            }
            numToAdd = source.length;
        }
        if (dest == null || dest.length == 0) {
            dest = (Object[])Array.newInstance(c, numToAdd);
            System.arraycopy(source, 0, dest, 0, numToAdd);
            return dest;
        }
        int firstFree = ArrayUtil.findFirstNull(dest);
        if (firstFree < 0) {
            firstFree = dest.length;
        }
        if (firstFree + numToAdd <= dest.length) {
            System.arraycopy(source, 0, dest, firstFree, numToAdd);
            return dest;
        }
        Object[] temp = (Object[])Array.newInstance(c, firstFree + numToAdd);
        System.arraycopy(dest, 0, temp, 0, firstFree);
        System.arraycopy(source, 0, temp, firstFree, numToAdd);
        return temp;
    }

    public static boolean contains(Object[] array, Object obj) {
        return ArrayUtil.indexOf(array, obj) != -1;
    }

    public static int indexOf(Object[] array, Object obj) {
        int result = -1;
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (array[i] == obj) {
                    return i;
                }
                ++i;
            }
        }
        return result;
    }

    public static boolean containsEqual(Object[] array, Object obj) {
        return ArrayUtil.indexOfEqual(array, obj) != -1;
    }

    public static int indexOfEqual(Object[] comments, Object comment) {
        int result = -1;
        if (comments != null) {
            int i = 0;
            while (i < comments.length && comments[i] != null) {
                if (comments[i].equals(comment)) {
                    return i;
                }
                ++i;
            }
        }
        return result;
    }

    public static Object[] removeNulls(Class<?> c, Object[] array) {
        if (array == null) {
            return (Object[])Array.newInstance(c, 0);
        }
        int validEntries = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                ++validEntries;
            }
            ++i;
        }
        if (array.length == validEntries) {
            return array;
        }
        Object[] newArray = (Object[])Array.newInstance(c, validEntries);
        int j = 0;
        i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                newArray[j++] = array[i];
            }
            ++i;
        }
        return newArray;
    }

    public static Object[] removeNullsAfter(Class<?> c, Object[] array, int index) {
        if (array == null || index < 0) {
            return (Object[])Array.newInstance(c, 0);
        }
        int newLen = index + 1;
        if (array.length == newLen) {
            return array;
        }
        Object[] newArray = (Object[])Array.newInstance(c, newLen);
        System.arraycopy(array, 0, newArray, 0, newLen);
        return newArray;
    }

    public static Object[] prepend(Class<?> c, Object[] array, Object obj) {
        if (obj == null) {
            return array;
        }
        if (array == null || array.length == 0) {
            array = (Object[])Array.newInstance(c, 2);
            array[0] = obj;
            return array;
        }
        int i = ArrayUtil.findFirstNull(array);
        if (i >= 0) {
            System.arraycopy(array, 0, array, 1, i);
            array[0] = obj;
        } else {
            Object[] temp = (Object[])Array.newInstance(c, array.length * 2);
            System.arraycopy(array, 0, temp, 1, array.length);
            temp[0] = obj;
            array = temp;
        }
        return array;
    }

    public static void remove(Object[] array, Object element) {
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                if (element == array[i]) {
                    System.arraycopy(array, i + 1, array, i, array.length - i - 1);
                    array[array.length - 1] = null;
                    return;
                }
                ++i;
            }
        }
    }

    public static int[] setInt(int[] array, int idx, int val) {
        if (array == null) {
            array = new int[2 > idx + 1 ? 2 : idx + 1];
            array[idx] = val;
            return array;
        }
        if (array.length <= idx) {
            int newLen = array.length * 2;
            while (newLen <= idx) {
                newLen *= 2;
            }
            int[] temp = new int[newLen];
            System.arraycopy(array, 0, temp, 0, array.length);
            array = temp;
        }
        array[idx] = val;
        return array;
    }

    public static <S, T> T[] convert(Class<T> target, S[] source) {
        Object[] result = null;
        if (source != null) {
            result = (Object[])Array.newInstance(target, source.length);
            int i = 0;
            while (i < source.length) {
                result[i] = source[i];
                ++i;
            }
        }
        return result;
    }
}

