/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTIfStatement;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBlockScope;

public class CPPASTIfStatement
extends CPPASTNode
implements ICPPASTIfStatement,
IASTAmbiguityParent {
    private IASTExpression condition;
    private IASTStatement thenClause;
    private IASTStatement elseClause;
    private IASTDeclaration condDecl;
    private IScope scope;

    public CPPASTIfStatement() {
    }

    public CPPASTIfStatement(IASTDeclaration condition, IASTStatement thenClause, IASTStatement elseClause) {
        this.setConditionDeclaration(condition);
        this.setThenClause(thenClause);
        this.setElseClause(elseClause);
    }

    public CPPASTIfStatement(IASTExpression condition, IASTStatement thenClause, IASTStatement elseClause) {
        this.setConditionExpression(condition);
        this.setThenClause(thenClause);
        this.setElseClause(elseClause);
    }

    public IASTExpression getConditionExpression() {
        return this.condition;
    }

    public void setConditionExpression(IASTExpression condition) {
        this.condition = condition;
        if (condition != null) {
            condition.setParent(this);
            condition.setPropertyInParent(CONDITION);
        }
    }

    public IASTStatement getThenClause() {
        return this.thenClause;
    }

    public void setThenClause(IASTStatement thenClause) {
        this.thenClause = thenClause;
        if (thenClause != null) {
            thenClause.setParent(this);
            thenClause.setPropertyInParent(THEN);
        }
    }

    public IASTStatement getElseClause() {
        return this.elseClause;
    }

    public void setElseClause(IASTStatement elseClause) {
        this.elseClause = elseClause;
        if (elseClause != null) {
            elseClause.setParent(this);
            elseClause.setPropertyInParent(ELSE);
        }
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.condition != null && !this.condition.accept(action)) {
            return false;
        }
        if (this.condDecl != null && !this.condDecl.accept(action)) {
            return false;
        }
        if (this.thenClause != null && !this.thenClause.accept(action)) {
            return false;
        }
        if (this.elseClause != null && !this.elseClause.accept(action)) {
            return false;
        }
        if (action.shouldVisitStatements) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    public void replace(IASTNode child, IASTNode other) {
        if (this.thenClause == child) {
            other.setParent(child.getParent());
            other.setPropertyInParent(child.getPropertyInParent());
            this.thenClause = (IASTStatement)other;
        } else if (this.elseClause == child) {
            other.setParent(child.getParent());
            other.setPropertyInParent(child.getPropertyInParent());
            this.elseClause = (IASTStatement)other;
        }
        if (this.condDecl == child) {
            other.setParent(child.getParent());
            other.setPropertyInParent(child.getPropertyInParent());
            this.condDecl = (IASTDeclaration)other;
        }
    }

    public IASTDeclaration getConditionDeclaration() {
        return this.condDecl;
    }

    public void setConditionDeclaration(IASTDeclaration d) {
        this.condDecl = d;
        if (d != null) {
            d.setParent(this);
            d.setPropertyInParent(CONDITION);
        }
    }

    public IScope getScope() {
        if (this.scope == null) {
            this.scope = new CPPBlockScope(this);
        }
        return this.scope;
    }
}

