/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPUnknownClassType;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPUnknownClassInstance
extends PDOMCPPUnknownClassType
implements ICPPUnknownClassInstance {
    private static final int ARGUMENTS = 36;
    protected static final int RECORD_SIZE = 40;
    IType[] arguments;

    public PDOMCPPUnknownClassInstance(PDOM pdom, PDOMNode parent, ICPPUnknownClassInstance classInstance) throws CoreException {
        super(pdom, parent, classInstance);
        IType[] args;
        PDOMNodeLinkedList list = new PDOMNodeLinkedList(pdom, this.record + 36, this.getLinkageImpl());
        IType[] iTypeArray = args = classInstance.getArguments();
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            IType arg = iTypeArray[n2];
            PDOMNode typeNode = this.getLinkageImpl().addType(this, arg);
            if (typeNode != null) {
                list.addMember(typeNode);
            }
            ++n2;
        }
    }

    public PDOMCPPUnknownClassInstance(PDOM pdom, int bindingRecord) {
        super(pdom, bindingRecord);
    }

    protected int getRecordSize() {
        return 40;
    }

    public int getNodeType() {
        return 48;
    }

    public IType[] getArguments() {
        if (this.arguments == null) {
            try {
                PDOMNodeLinkedList list = new PDOMNodeLinkedList(this.pdom, this.record + 36, this.getLinkageImpl());
                TemplateArgumentCollector visitor = new TemplateArgumentCollector();
                list.accept(visitor);
                this.arguments = visitor.getTemplateArguments();
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
                return IType.EMPTY_TYPE_ARRAY;
            }
        }
        return this.arguments;
    }

    public IBinding resolvePartially(ICPPUnknownBinding parentBinding, ObjectMap argMap, ICPPScope instantiationScope) {
        IType[] arguments = this.getArguments();
        IType[] newArgs = CPPTemplates.instantiateTypes(arguments, argMap, instantiationScope);
        if (parentBinding instanceof PDOMNode && this.isChildOf((PDOMNode)((Object)parentBinding)) && newArgs == arguments) {
            return this;
        }
        CPPASTName name = new CPPASTName(this.getNameCharArray());
        return new CPPUnknownClassInstance(parentBinding, name, newArgs);
    }

    public String toString() {
        return String.valueOf(this.getName()) + " <" + ASTTypeUtil.getTypeListString(this.getArguments()) + ">";
    }

    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (type instanceof ICPPUnknownClassInstance) {
            ICPPUnknownClassInstance rhs = (ICPPUnknownClassInstance)type;
            if (CharArrayUtils.equals(this.getNameCharArray(), rhs.getNameCharArray())) {
                IType[] rhsArgs;
                IType[] lhsArgs = this.getArguments();
                if (lhsArgs != (rhsArgs = rhs.getArguments())) {
                    if (lhsArgs == null || rhsArgs == null) {
                        return false;
                    }
                    if (lhsArgs.length != rhsArgs.length) {
                        return false;
                    }
                    int i = 0;
                    while (i < lhsArgs.length) {
                        if (!CPPTemplates.isSameTemplateArgument(lhsArgs[i], rhsArgs[i])) {
                            return false;
                        }
                        ++i;
                    }
                }
                ICPPUnknownBinding lhsContainer = this.getUnknownContainerBinding();
                ICPPUnknownBinding rhsContainer = rhs.getUnknownContainerBinding();
                if (lhsContainer instanceof IType && rhsContainer instanceof IType) {
                    return ((IType)((Object)lhsContainer)).isSameType((IType)((Object)rhsContainer));
                }
            }
        }
        return false;
    }

    private static class TemplateArgumentCollector
    implements IPDOMVisitor {
        private List<IType> args = new ArrayList<IType>();

        private TemplateArgumentCollector() {
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            if (node instanceof IType) {
                this.args.add((IType)((Object)node));
            }
            return false;
        }

        public void leave(IPDOMNode node) throws CoreException {
        }

        public IType[] getTemplateArguments() {
            return this.args.toArray(new IType[this.args.size()]);
        }
    }
}

