/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileExistsCache {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final boolean CASE_INSENSITIVE = new File("a").equals(new File("A"));
    private static boolean BYPASS_CACHE = Boolean.getBoolean("CDT_INDEXER_BYPASS_FILE_EXISTS_CACHE");
    private Reference<Map<String, String[]>> fCache = new SoftReference(new HashMap());

    public boolean exists(String path) {
        Object[] avail;
        File file = new File(path);
        if (BYPASS_CACHE) {
            return file.exists();
        }
        String parent = file.getParent();
        String name = file.getName();
        if (CASE_INSENSITIVE) {
            name = name.toUpperCase();
        }
        if ((avail = this.getExistsCache().get(parent)) == null) {
            avail = new File(parent).list();
            if (avail == null || avail.length == 0) {
                avail = EMPTY_STRING_ARRAY;
            } else {
                if (CASE_INSENSITIVE) {
                    int i = 0;
                    while (i < avail.length) {
                        avail[i] = ((String)avail[i]).toUpperCase();
                        ++i;
                    }
                }
                Arrays.sort(avail);
            }
            this.getExistsCache().put(parent, (String[])avail);
        }
        return Arrays.binarySearch(avail, name) >= 0;
    }

    private Map<String, String[]> getExistsCache() {
        Map<String, String[]> cache = this.fCache.get();
        if (cache == null) {
            cache = new HashMap<String, String[]>();
            this.fCache = new SoftReference<Map<String, String[]>>(cache);
        }
        return cache;
    }
}

