/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.index;

import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class IndexLocationFactory {
    public static IPath getPath(IIndexFileLocation location) {
        String fp = location.getFullPath();
        if (fp != null) {
            return new Path(fp);
        }
        return IndexLocationFactory.getAbsolutePath(location);
    }

    public static IPath getAbsolutePath(IIndexFileLocation location) {
        return URIUtil.toPath((URI)location.getURI());
    }

    public static IIndexFileLocation getIFLExpensive(String absolutePath) {
        return IndexLocationFactory.getIFLExpensive(null, absolutePath);
    }

    public static IIndexFileLocation getIFLExpensive(ICProject cproject, String absolutePath) {
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(absolutePath));
        if (files.length == 1) {
            IFile file = files[0];
            if (file.exists()) {
                return IndexLocationFactory.getWorkspaceIFL(file);
            }
        } else {
            Arrays.sort(files, new FILE_COMPARATOR());
            IProject preferredProject = cproject == null ? null : cproject.getProject();
            IFile fileInCProject = null;
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file.exists()) {
                    IProject project = file.getProject();
                    if (preferredProject != null && preferredProject.equals((Object)project)) {
                        return IndexLocationFactory.getWorkspaceIFL(file);
                    }
                    if (fileInCProject == null) {
                        try {
                            if (project.hasNature("org.eclipse.cdt.core.cnature")) {
                                fileInCProject = file;
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                }
                ++n2;
            }
            if (fileInCProject != null) {
                return IndexLocationFactory.getWorkspaceIFL(fileInCProject);
            }
        }
        return IndexLocationFactory.getExternalIFL(absolutePath);
    }

    public static IIndexFileLocation getExternalIFL(String absolutePath) {
        return IndexLocationFactory.getExternalIFL((IPath)new Path(absolutePath));
    }

    public static IIndexFileLocation getExternalIFL(IPath absolutePath) {
        return new IndexFileLocation(URIUtil.toURI((IPath)absolutePath), null);
    }

    public static IIndexFileLocation getWorkspaceIFL(IFile file) {
        URI locationURI = file.getLocationURI();
        if (locationURI != null) {
            return new IndexFileLocation(locationURI, file.getFullPath().toString());
        }
        return null;
    }

    public static IIndexFileLocation getIFL(ITranslationUnit tu) {
        IResource res = tu.getResource();
        if (res instanceof IFile) {
            return IndexLocationFactory.getWorkspaceIFL((IFile)res);
        }
        IPath location = tu.getLocation();
        if (location != null) {
            return IndexLocationFactory.getExternalIFL(location);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FILE_COMPARATOR
    implements Comparator<IFile> {
        private FILE_COMPARATOR() {
        }

        @Override
        public int compare(IFile o1, IFile o2) {
            return this.compare(o1.getLocationURI(), o2.getLocationURI());
        }

        @Override
        private int compare(URI uri1, URI uri2) {
            if (uri1 == uri2) {
                return 0;
            }
            if (uri1 == null) {
                return -1;
            }
            if (uri2 == null) {
                return 1;
            }
            return uri1.toString().compareTo(uri2.toString());
        }
    }
}

