/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.util.HashSet;
import org.eclipse.cdt.core.dom.IPDOMIndexer;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMUpdateTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexUpdatePolicy {
    public static final int POST_CHANGE = 0;
    public static final int POST_BUILD = 1;
    public static final int MANUAL = 2;
    private final ICProject fCProject;
    private int fKind;
    private HashSet<ITranslationUnit> fForce = new HashSet();
    private HashSet<ITranslationUnit> fTimestamp = new HashSet();
    private HashSet<ITranslationUnit> fRemoved = new HashSet();
    private IPDOMIndexer fIndexer;
    private boolean fReindexRequested;

    public IndexUpdatePolicy(ICProject project, int kind) {
        this.fCProject = project;
        this.fKind = this.getLegalPolicy(kind);
    }

    private int getLegalPolicy(int kind) {
        switch (kind) {
            case 0: 
            case 1: 
            case 2: {
                return kind;
            }
        }
        return 0;
    }

    public ICProject getProject() {
        return this.fCProject;
    }

    public void clearTUs() {
        this.fForce.clear();
        this.fTimestamp.clear();
        this.fRemoved.clear();
    }

    public boolean hasTUs() {
        return !this.fForce.isEmpty() || !this.fTimestamp.isEmpty() || !this.fRemoved.isEmpty();
    }

    public void setIndexer(IPDOMIndexer indexer) {
        this.fIndexer = indexer;
    }

    public IPDOMIndexer getIndexer() {
        return this.fIndexer;
    }

    public IPDOMIndexerTask handleDelta(ITranslationUnit[] force, ITranslationUnit[] changed, ITranslationUnit[] removed) {
        ITranslationUnit tu;
        if (this.isNullIndexer()) {
            return null;
        }
        switch (this.fKind) {
            case 2: {
                return null;
            }
            case 0: {
                if (this.fIndexer == null) break;
                return this.fIndexer.createTask(force, changed, removed);
            }
        }
        int i = 0;
        while (i < removed.length) {
            tu = removed[i];
            this.fForce.remove(tu);
            this.fTimestamp.remove(tu);
            this.fRemoved.add(tu);
            ++i;
        }
        i = 0;
        while (i < force.length) {
            tu = force[i];
            this.fForce.add(tu);
            this.fTimestamp.remove(tu);
            this.fRemoved.remove(tu);
            ++i;
        }
        i = 0;
        while (i < changed.length) {
            tu = changed[i];
            if (!this.fForce.contains(tu)) {
                this.fTimestamp.add(tu);
            }
            this.fRemoved.remove(tu);
            ++i;
        }
        return null;
    }

    public IPDOMIndexerTask createTask() {
        IPDOMIndexerTask task = null;
        if (this.fIndexer != null && this.hasTUs()) {
            if (this.fKind != 2 && !this.isNullIndexer()) {
                task = this.fIndexer.createTask(this.toarray(this.fForce), this.toarray(this.fTimestamp), this.toarray(this.fRemoved));
            }
            this.clearTUs();
        }
        return task;
    }

    private ITranslationUnit[] toarray(HashSet<ITranslationUnit> set) {
        return set.toArray(new ITranslationUnit[set.size()]);
    }

    private boolean isNullIndexer() {
        return this.fIndexer != null && this.fIndexer.getID().equals("org.eclipse.cdt.core.nullindexer");
    }

    public IPDOMIndexerTask changePolicy(int updatePolicy) {
        int oldPolicy = this.fKind;
        this.fKind = this.getLegalPolicy(updatePolicy);
        IPDOMIndexerTask task = null;
        if (this.fKind == 2 || this.isNullIndexer()) {
            this.clearTUs();
        } else if (this.fIndexer != null) {
            if (oldPolicy == 2) {
                task = new PDOMUpdateTask(this.fIndexer, 2);
                this.clearTUs();
            } else if (this.fKind == 0) {
                task = this.createTask();
            }
        }
        return task;
    }

    public void requestInitialReindex() {
        this.fReindexRequested = true;
    }

    public void clearInitialFlags() {
        this.fReindexRequested = false;
    }

    public boolean isInitialRebuildRequested() {
        return this.fReindexRequested;
    }
}

