/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPNamespace;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPUsingDirective
implements ICPPUsingDirective,
IPDOMNode {
    private static final int CONTAINER_NAMESPACE = 0;
    private static final int NOMINATED_NAMESPACE = 4;
    private static final int PREV_DIRECTIVE_OF_FILE = 8;
    private static final int RECORD_SIZE = 12;
    private final PDOMCPPLinkage fLinkage;
    private final int fRecord;

    PDOMCPPUsingDirective(PDOMCPPLinkage pdom, int record) {
        this.fLinkage = pdom;
        this.fRecord = record;
    }

    public PDOMCPPUsingDirective(PDOMCPPLinkage linkage, int prevRecInFile, PDOMCPPNamespace containerNS, PDOMBinding nominated) throws CoreException {
        Database db = linkage.getPDOM().getDB();
        int containerRec = containerNS == null ? 0 : containerNS.getRecord();
        int nominatedRec = nominated.getRecord();
        this.fLinkage = linkage;
        this.fRecord = db.malloc(12);
        db.putInt(this.fRecord + 0, containerRec);
        db.putInt(this.fRecord + 4, nominatedRec);
        db.putInt(this.fRecord + 8, prevRecInFile);
    }

    public ICPPNamespaceScope getNominatedScope() {
        try {
            int rec = this.fLinkage.getPDOM().getDB().getInt(this.fRecord + 4);
            PDOMNode node = this.fLinkage.getNode(rec);
            if (node instanceof ICPPNamespace) {
                return ((ICPPNamespace)((Object)node)).getNamespaceScope();
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
        }
        catch (DOMException dOMException) {}
        return null;
    }

    public IScope getContainingScope() {
        try {
            PDOMNode node;
            int rec = this.fLinkage.getPDOM().getDB().getInt(this.fRecord + 0);
            if (rec != 0 && (node = this.fLinkage.getNode(rec)) instanceof PDOMCPPNamespace) {
                return (PDOMCPPNamespace)node;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
        }
        return null;
    }

    public int getPointOfDeclaration() {
        return 0;
    }

    public int getRecord() {
        return this.fRecord;
    }

    public int getPreviousRec() throws CoreException {
        Database db = this.fLinkage.getPDOM().getDB();
        return db.getInt(this.fRecord + 8);
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
    }

    public void delete(PDOMLinkage linkage) throws CoreException {
        this.fLinkage.getPDOM().getDB().free(this.fRecord);
    }
}

