/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.search;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.browser.ITypeReference;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ptp.internal.rdt.core.index.DummyName;
import org.eclipse.ptp.internal.rdt.core.search.RemoteASTTypeInfo;
import org.eclipse.ptp.internal.rdt.core.search.RemoteSearchMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteSearchQuery
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int FIND_DECLARATIONS = 1;
    public static final int FIND_DEFINITIONS = 2;
    public static final int FIND_REFERENCES = 4;
    public static final int FIND_DECLARATIONS_DEFINITIONS = 3;
    public static final int FIND_ALL_OCCURANCES = 7;
    protected int flags;
    protected ICElement[] scope;
    protected ICProject[] projects;
    protected List<RemoteSearchMatch> fMatches;
    protected IIndexLocationConverter fConverter;

    protected RemoteSearchQuery(ICElement[] scope, int flags) {
        this.flags = flags;
        this.fMatches = new LinkedList<RemoteSearchMatch>();
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    protected boolean filterName(IIndexName name) {
        return false;
    }

    private void collectNames(IIndex index, IIndexName[] names) throws CoreException {
        int i = 0;
        while (i < names.length) {
            IIndexName name = names[i];
            if (!this.filterName(name)) {
                IASTFileLocation loc = name.getFileLocation();
                IIndexBinding binding = index.findBinding((IName)name);
                IIndexFileLocation indexLocation = this.fConverter.fromInternalFormat(loc.getFileName());
                this.fMatches.add(new RemoteSearchMatch(index, binding, new DummyName(name, loc, indexLocation), loc.getNodeOffset(), loc.getNodeLength()));
            }
            ++i;
        }
    }

    protected void createMatches(IIndex index, IBinding binding) throws CoreException {
        if (binding != null) {
            IIndexName[] names = index.findNames(binding, this.flags);
            this.collectNames(index, names);
        }
    }

    protected void createLocalMatches(IASTTranslationUnit ast, IBinding binding) {
        if (binding != null) {
            HashSet names = new HashSet();
            names.addAll(Arrays.asList(ast.getDeclarationsInAST(binding)));
            names.addAll(Arrays.asList(ast.getDefinitionsInAST(binding)));
            names.addAll(Arrays.asList(ast.getReferences(binding)));
            for (IASTName name : names) {
                ITypeReference ref;
                RemoteASTTypeInfo typeInfo;
                if (!((this.flags & 1) != 0 && name.isDeclaration() || (this.flags & 2) != 0 && name.isDefinition()) && ((this.flags & 4) == 0 || !name.isReference()) || (typeInfo = RemoteASTTypeInfo.create(name)) == null || (ref = typeInfo.getResolvedReference()) == null) continue;
                IASTFileLocation loc = name.getFileLocation();
                IIndexFileLocation indexLocation = this.fConverter.fromInternalFormat(typeInfo.getIFL().getFullPath());
                DummyName indexName = new DummyName(name, loc, indexLocation);
                this.fMatches.add(new RemoteSearchMatch(indexName, typeInfo, ref.getOffset(), ref.getLength()));
            }
        }
    }

    public int getFlags() {
        return this.flags;
    }

    public abstract IStatus runWithIndex(IIndex var1, IIndexLocationConverter var2, IProgressMonitor var3);

    public List<RemoteSearchMatch> getMatches() {
        return this.fMatches;
    }

    public void setMatches(List<RemoteSearchMatch> matches) {
        this.fMatches = matches;
    }

    public ICProject[] getProjects() {
        return this.projects;
    }

    public String getScopeDescription() {
        StringBuilder buf = new StringBuilder();
        if (this.scope == null) {
            return "";
        }
        switch (this.scope.length) {
            case 0: {
                break;
            }
            case 1: {
                buf.append(this.scope[0].getElementName());
                break;
            }
            case 2: {
                buf.append(this.scope[0].getElementName());
                buf.append(", ");
                buf.append(this.scope[1].getElementName());
                break;
            }
            default: {
                buf.append(this.scope[0].getElementName());
                buf.append(", ");
                buf.append(this.scope[1].getElementName());
                buf.append(", ...");
            }
        }
        return buf.toString();
    }
}

