/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.serviceproviders;

import org.eclipse.ptp.rdt.core.serviceproviders.IRemoteExecutionServiceProvider;
import org.eclipse.ptp.rdt.services.core.ServiceProviderDescriptor;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ui.IMemento;

public class RemoteBuildServiceProvider
extends ServiceProviderDescriptor
implements IRemoteExecutionServiceProvider {
    public static final String REMOTE_BUILD_SERVICE_PROVIDER_REMOTE_TOOLS_PROVIDER_ID = "RemoteBuildServiceProvider.remoteToolsProviderID";
    public static final String REMOTE_BUILD_SERVICE_PROVIDER_REMOTE_TOOLS_CONNECTION_NAME = "RemoteBuildServiceProvider.remoteToolsConnectionName";
    public static final String ID = "org.eclipse.ptp.rdt.ui.RemoteBuildServiceProvider";
    public static final String SERVICE_ID = "org.eclipse.ptp.rdt.core.BuildService";
    public static final String NAME = Messages.getString("RemoteBuildServiceProvider.0");
    private String fRemoteToolsProviderID;
    private IRemoteConnection fRemoteConnection;
    private String fConnectionName;

    public RemoteBuildServiceProvider(String id, String name, String serviceId) {
        super(id, name, serviceId);
    }

    public RemoteBuildServiceProvider() {
        this(ID, NAME, SERVICE_ID);
    }

    public boolean isConfigured() {
        return this.fRemoteToolsProviderID != null && this.fConnectionName != null;
    }

    public void setRemoteToolsProviderID(String id) {
        this.fRemoteToolsProviderID = id;
    }

    public void restoreState(IMemento memento) {
        this.fRemoteToolsProviderID = memento.getString(REMOTE_BUILD_SERVICE_PROVIDER_REMOTE_TOOLS_PROVIDER_ID);
        this.fConnectionName = memento.getString(REMOTE_BUILD_SERVICE_PROVIDER_REMOTE_TOOLS_CONNECTION_NAME);
    }

    public void saveState(IMemento memento) {
        memento.putString(REMOTE_BUILD_SERVICE_PROVIDER_REMOTE_TOOLS_PROVIDER_ID, this.fRemoteToolsProviderID);
        memento.putString(REMOTE_BUILD_SERVICE_PROVIDER_REMOTE_TOOLS_CONNECTION_NAME, this.fConnectionName);
    }

    public IRemoteServices getRemoteServices() {
        return PTPRemoteCorePlugin.getDefault().getRemoteServices(this.fRemoteToolsProviderID);
    }

    public void setRemoteToolsConnection(IRemoteConnection connection) {
        this.fRemoteConnection = connection;
        this.fConnectionName = connection.getName();
    }

    public IRemoteConnection getConnection() {
        if (this.fRemoteConnection == null && this.fConnectionName != null) {
            this.fRemoteConnection = this.getRemoteServices().getConnectionManager().getConnection(this.fConnectionName);
        }
        return this.fRemoteConnection;
    }

    public String getConfigurationString() {
        if (this.isConfigured()) {
            return String.valueOf(this.getRemoteServices().getName()) + ": " + this.fConnectionName;
        }
        return null;
    }

    public String toString() {
        return "RemoteBuildServiceProvider(" + this.fConnectionName + ")";
    }
}

