/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.rdt.services.core.IService;
import org.eclipse.ptp.rdt.services.core.IServiceConfiguration;
import org.eclipse.ptp.rdt.services.core.IServiceProvider;
import org.eclipse.ptp.rdt.services.core.ServiceConfiguration;
import org.eclipse.ptp.rdt.services.core.ServiceModelManager;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.rse.internal.connectorservice.dstore.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureRemoteServices {
    public static String DEFAULT_CONFIG = Messages.getString("ConfigureRemoteServices.0");

    public static void configure(IProject project, Map<String, String> serviceIDToProviderIDMap, Map<String, IServiceProvider> providerIDToProviderMap, IProgressMonitor monitor) {
        monitor.beginTask("actual Configure remote services", 100);
        if (project == null) {
            throw new NullPointerException();
        }
        ServiceModelManager serviceModelManager = ServiceModelManager.getInstance();
        ServiceConfiguration config = new ServiceConfiguration(DEFAULT_CONFIG);
        int workUnit = 90 / serviceIDToProviderIDMap.size();
        for (String serviceID : serviceIDToProviderIDMap.keySet()) {
            IService service = serviceModelManager.getService(serviceID);
            String serviceProviderID = serviceIDToProviderIDMap.get(serviceID);
            IServiceProvider provider = providerIDToProviderMap.get(serviceProviderID);
            config.setServiceProvider(service, provider);
            monitor.worked(workUnit);
            serviceModelManager.putConfiguration(project, (IServiceConfiguration)config);
            serviceModelManager.setActiveConfiguration(project, (IServiceConfiguration)config);
        }
        try {
            serviceModelManager.saveModelConfiguration();
        }
        catch (IOException e) {
            Activator.logError((String)e.toString(), (Throwable)e);
        }
        ICProject cProject = CModelManager.getDefault().getCModel().getCProject((IResource)project);
        CCorePlugin.getIndexManager().setIndexerId(cProject, "org.eclipse.ptp.rdt.core.RemoteFastIndexer");
        Properties properties = new Properties();
        properties.put("filesToParseUpFront", "");
        IndexerPreferences.setProperties((IProject)project, (int)1, (Properties)properties);
        monitor.worked(10);
        monitor.done();
    }
}

