/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.ptp.rdt.services.core.IService;
import org.eclipse.ptp.rdt.services.core.IServiceProvider;
import org.eclipse.ptp.rdt.services.core.IServiceProviderDescriptor;
import org.eclipse.ptp.rdt.services.core.ServiceModelManager;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.rdt.ui.wizards.ServiceModelWidget;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertToRemoteServiceModelWidget
extends ServiceModelWidget {
    IProject fCurrentProject;
    Map<IProject, Map<String, String>> projectToServices = new HashMap<IProject, Map<String, String>>();
    Map<IProject, Map<String, IServiceProvider>> projectToProviders = new HashMap<IProject, Map<String, IServiceProvider>>();

    public void addServicesToTable(IProject project) {
        this.fProviderIDToProviderMap = new HashMap();
        this.fServiceIDToSelectedProviderID = new HashMap();
        this.fCurrentProject = project;
        this.createTableContent(project);
    }

    @Override
    protected void createTableContent(IProject project) {
        this.fTable.removeAll();
        if (project == null) {
            super.createTableContent(project);
        } else if (this.projectToServices.get(project) == null && this.projectToProviders.get(project) == null) {
            super.createTableContent(project);
        } else {
            Set<IService> services = this.getContributedServices(project);
            Iterator<IService> iterator = services.iterator();
            Map<String, String> serviceIDToSelectedProviderID = this.projectToServices.get(this.fCurrentProject);
            Map<String, IServiceProvider> providerIDToProviderMap = this.projectToProviders.get(this.fCurrentProject);
            while (iterator.hasNext()) {
                String configString;
                IService service = iterator.next();
                TableItem item = new TableItem(this.fTable, 0);
                item.setText(0, service.getName());
                item.setData("service-id", (Object)service);
                String providerID = serviceIDToSelectedProviderID.get(service.getId());
                IServiceProvider provider = providerIDToProviderMap.get(providerID);
                if (provider != null) {
                    item.setText(1, provider.getName());
                    item.setData("provider-id", (Object)provider);
                    configString = provider.getConfigurationString();
                } else {
                    IServiceProviderDescriptor descriptor = service.getId().compareTo("org.eclipse.ptp.rdt.core.BuildService") == 0 ? service.getProviderDescriptor("org.eclipse.ptp.rdt.ui.NullBuildServiceProvider") : (service.getId().compareTo("org.eclipse.ptp.rdt.core.CIndexingService") == 0 ? service.getProviderDescriptor("org.eclipse.ptp.rdt.ui.NullCIndexServiceProvider") : (IServiceProviderDescriptor)service.getProviders().iterator().next());
                    item.setText(1, descriptor.getName());
                    item.setData("provider-id", (Object)descriptor);
                    configString = Messages.getString("ServiceModelWidget.4");
                    if (descriptor.getId().compareTo("org.eclipse.ptp.rdt.ui.NullBuildServiceProvider") == 0 || descriptor.getId().compareTo("org.eclipse.ptp.rdt.ui.NullCIndexServiceProvider") == 0) {
                        ServiceModelManager manager = ServiceModelManager.getInstance();
                        IServiceProvider serviceProvider = manager.getServiceProvider(descriptor);
                        configString = serviceProvider.getConfigurationString();
                        if (configString == null) {
                            configString = Messages.getString("ServiceModelWidget.4");
                        }
                        this.fServiceIDToSelectedProviderID.put(service.getId(), descriptor.getId());
                        this.fProviderIDToProviderMap.put(descriptor.getId(), serviceProvider);
                    }
                }
                if (configString == null) {
                    configString = Messages.getString("ServiceModelWidget.4");
                }
                item.setText(2, configString);
            }
            this.fServiceIDToSelectedProviderID.putAll(serviceIDToSelectedProviderID);
            this.fProviderIDToProviderMap.putAll(providerIDToProviderMap);
        }
        this.projectToServices.put(project, this.fServiceIDToSelectedProviderID);
        this.projectToProviders.put(project, this.fProviderIDToProviderMap);
        if (this.fConfigChangeListener != null) {
            this.fConfigChangeListener.handleEvent(null);
        }
        if (this.fConfigureButton != null) {
            this.fConfigureButton.setEnabled(false);
        }
    }

    public void emptyTable() {
        this.fTable.removeAll();
    }

    @Override
    protected Listener getConfigureListener() {
        return new ConfigureListener2();
    }

    public Map<IProject, Map<String, String>> getProjectToServices() {
        return this.projectToServices;
    }

    public Map<IProject, Map<String, IServiceProvider>> getProjectToProviders() {
        return this.projectToProviders;
    }

    public boolean isConfigured(Object[] selectedProjects) {
        boolean configured = true;
        if (selectedProjects == null || selectedProjects.length < 1) {
            return false;
        }
        int i = 0;
        while (i < selectedProjects.length) {
            IProject project = (IProject)selectedProjects[i];
            Map<String, String> serviceIDToSelectedProviderID = this.projectToServices.get(project);
            Map<String, IServiceProvider> providerIDToProviderMap = this.projectToProviders.get(project);
            if (serviceIDToSelectedProviderID == null || providerIDToProviderMap == null) {
                return false;
            }
            configured = configured && this.isConfigured(project, serviceIDToSelectedProviderID, providerIDToProviderMap);
            ++i;
        }
        return configured;
    }

    public class ConfigureListener2
    extends ServiceModelWidget.ConfigureListener {
        public ConfigureListener2() {
            super(ConvertToRemoteServiceModelWidget.this);
        }

        public void handleEvent(Event event) {
            super.handleEvent(event);
            ConvertToRemoteServiceModelWidget.this.projectToServices.put(ConvertToRemoteServiceModelWidget.this.fCurrentProject, ConvertToRemoteServiceModelWidget.this.fServiceIDToSelectedProviderID);
            ConvertToRemoteServiceModelWidget.this.projectToProviders.put(ConvertToRemoteServiceModelWidget.this.fCurrentProject, ConvertToRemoteServiceModelWidget.this.fProviderIDToProviderMap);
        }
    }
}

