/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.cdt.ui.wizards.conversion.ConvertProjectWizardPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ptp.rdt.core.resources.RemoteNature;
import org.eclipse.ptp.rdt.services.core.IServiceProvider;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.ptp.rdt.ui.wizards.ConfigureRemoteServices;
import org.eclipse.ptp.rdt.ui.wizards.ConvertToRemoteServiceModelWidget;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ConvertToRemoteWizardPage
extends ConvertProjectWizardPage {
    private static final String WZ_TITLE = "WizardProjectConversion.title";
    private static final String WZ_DESC = "WizardProjectConversion.description";
    ConvertToRemoteServiceModelWidget fServiceModelWidget = new ConvertToRemoteServiceModelWidget();
    Group remoteServices;

    public ConvertToRemoteWizardPage(String pageName) {
        super(pageName);
        this.fServiceModelWidget.setConfigChangeListener(new Listener(){

            public void handleEvent(Event event) {
                ConvertToRemoteWizardPage.this.setPageComplete(ConvertToRemoteWizardPage.this.validatePage());
            }
        });
    }

    protected String getWzTitleResource() {
        return Messages.getString(WZ_TITLE);
    }

    protected String getWzDescriptionResource() {
        return Messages.getString(WZ_DESC);
    }

    public boolean isCandidate(IProject project) {
        boolean a = false;
        boolean b = false;
        boolean c = false;
        a = !project.isHidden();
        try {
            b = !project.hasNature("org.eclipse.ptp.rdt.core.remoteNature");
            c = !project.hasNature("org.eclipse.rse.ui.remoteSystemsTempNature");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return a && b && c;
    }

    public void convertProject(IProject project, String bsId, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.getString("WizardProjectConversion.monitor.convertingToRemoteProject"), 3);
        try {
            try {
                RemoteNature.addRemoteNature((IProject)project, (IProgressMonitor)monitor);
                this.configureServicesForRemoteProject(project);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                monitor.done();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public void convertProject(IProject project, IProgressMonitor monitor, String projectID) throws CoreException {
        monitor.beginTask(Messages.getString("WizardProjectConversion.monitor.convertingToRemoteProject"), 3);
        try {
            try {
                RemoteNature.addRemoteNature((IProject)project, (IProgressMonitor)monitor);
                this.configureServicesForRemoteProject(project);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                monitor.done();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void addToMainPage(Composite container) {
        this.remoteServices = new Group(container, 4);
        this.remoteServices.setText(Messages.getString("WizardProjectConversion.servicesTableLabel"));
        this.remoteServices.setLayout((Layout)new FillLayout());
        this.remoteServices.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fServiceModelWidget.createContents((Composite)this.remoteServices);
        this.fServiceModelWidget.emptyTable();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IProject project = (IProject)((IStructuredSelection)e.getSelection()).getFirstElement();
                if (project != null) {
                    ConvertToRemoteWizardPage.this.fServiceModelWidget.addServicesToTable(project);
                    ConvertToRemoteWizardPage.this.remoteServices.setText(MessageFormat.format(Messages.getString("WizardProjectConversion.servicesTableForProjectLabel"), project.getName()));
                }
            }
        });
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                IProject project = (IProject)e.getElement();
                if (e.getChecked() && project != null) {
                    ConvertToRemoteWizardPage.this.fServiceModelWidget.addServicesToTable(project);
                    ConvertToRemoteWizardPage.this.remoteServices.setText(MessageFormat.format(Messages.getString("WizardProjectConversion.servicesTableForProjectLabel"), project.getName()));
                }
            }
        });
    }

    private void configureServicesForRemoteProject(IProject project) throws InvocationTargetException, InterruptedException {
        Map<IProject, Map<String, String>> projectToServices = this.fServiceModelWidget.getProjectToServices();
        Map<IProject, Map<String, IServiceProvider>> projectToProviders = this.fServiceModelWidget.getProjectToProviders();
        Map<String, String> serviceIDToProviderIDMap = projectToServices.get(project);
        Map<String, IServiceProvider> providerIDToProviderMap = projectToProviders.get(project);
        ConfigureRemoteServices.configure(project, serviceIDToProviderIDMap, providerIDToProviderMap, (IProgressMonitor)new NullProgressMonitor());
    }

    protected boolean validatePage() {
        return super.validatePage() && this.fServiceModelWidget.isConfigured(this.getCheckedElements());
    }
}

