/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.perf.parallel;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.IModelManager;
import org.eclipse.ptp.core.PTPCorePlugin;
import org.eclipse.ptp.core.elements.IPUniverse;
import org.eclipse.ptp.core.elements.IResourceManager;
import org.eclipse.ptp.launch.messages.Messages;
import org.eclipse.ptp.launch.ui.ApplicationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ParallelPerfRecompMainTab
extends ApplicationTab {
    private Combo buildConfCombo = null;
    private Combo resourceManagerCombo = null;
    private IResourceManager resourceManager = null;
    private final Map<Integer, IResourceManager> resourceManagers = new HashMap<Integer, IResourceManager>();
    private final HashMap<IResourceManager, Integer> resourceManagerIndices = new HashMap();
    protected WidgetListener listener = new WidgetListener();

    private void createResourceControl(Composite comp) {
        Composite rmComp = new Composite(comp, 0);
        rmComp.setLayout((Layout)this.createGridLayout(2, false, 0, 0));
        rmComp.setLayoutData((Object)new GridData(768));
        IModelManager modelManager = PTPCorePlugin.getDefault().getModelManager();
        IPUniverse universe = modelManager.getUniverse();
        IResourceManager[] rms = modelManager.getStartedResourceManagers(universe);
        new Label(rmComp, 0).setText(Messages.ApplicationTab_RM_Selection_Label);
        this.resourceManagerCombo = new Combo(rmComp, 8);
        int i = 0;
        while (i < rms.length) {
            this.resourceManagerCombo.add(rms[i].getName());
            this.resourceManagers.put(i, rms[i]);
            this.resourceManagerIndices.put(rms[i], i);
            ++i;
        }
        this.resourceManagerCombo.addSelectionListener((SelectionListener)this.listener);
        this.resourceManagerCombo.deselectAll();
    }

    private void createProjectControl(Composite mainComp) {
        Label projLabel = new Label(mainComp, 0);
        projLabel.setText(Messages.ApplicationTab_Project_Label);
        projLabel.setLayoutData((Object)this.spanGridData(-1, 2));
        this.projText = new Text(mainComp, 2052);
        this.projText.setLayoutData((Object)new GridData(768));
        this.projText.addModifyListener((ModifyListener)this.listener);
        this.projButton = this.createPushButton(mainComp, Messages.Tab_common_Browse_1, null);
        this.projButton.addSelectionListener((SelectionListener)this.listener);
    }

    private void createAppControl(Composite mainComp) {
        Label appLabel = new Label(mainComp, 0);
        appLabel.setText("C/C++/Fortran Build Configuration");
        appLabel.setLayoutData((Object)this.spanGridData(-1, 2));
        this.buildConfCombo = new Combo(mainComp, 2060);
        this.buildConfCombo.setLayoutData((Object)new GridData(768));
        this.buildConfCombo.addModifyListener((ModifyListener)this.listener);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout());
        this.createVerticalSpacer(comp, 1);
        this.createResourceControl(comp);
        this.createVerticalSpacer(comp, 1);
        Composite mainComp = new Composite(comp, 0);
        mainComp.setLayout((Layout)this.createGridLayout(2, false, 0, 0));
        mainComp.setLayoutData((Object)new GridData(768));
        this.createProjectControl(mainComp);
        this.createVerticalSpacer(comp, 1);
        this.createAppControl(mainComp);
    }

    private void initializeConfCombo(ILaunchConfiguration configuration) {
        try {
            this.projText.setText(configuration.getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", ""));
            this.initConfCombo();
            String programName = configuration.getAttribute("ATTR_PERFORMANCEBUILD_CONFIGURATION_NAME", "");
            this.buildConfCombo.select(this.buildConfCombo.indexOf(programName));
            if (!programName.equals("")) {
                this.buildConfCombo.select(this.buildConfCombo.indexOf(programName));
            } else {
                this.buildConfCombo.select(0);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.projText.setText(configuration.getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", ""));
            this.resourceManager = this.getResourceManager(configuration);
            if (this.resourceManager == null) {
                this.setErrorMessage(Messages.ApplicationTab_No_Resource_Manager_Available);
                return;
            }
            this.setResourceManagerComboSelection(this.resourceManager);
        }
        catch (CoreException coreException) {
            this.setErrorMessage(Messages.CommonTab_common_Exception_occurred_reading_configuration_EXCEPTION);
        }
        this.initializeConfCombo(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.resourceManager != null) {
            configuration.setAttribute("org.eclipse.ptp.launch.RESOURCE_MANAGER_NAME", this.resourceManager.getUniqueName());
        }
        configuration.setAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", this.getFieldContent(this.projText.getText()));
        configuration.setAttribute("ATTR_PERFORMANCEBUILD_CONFIGURATION_NAME", this.buildConfCombo.getText());
    }

    protected ICProject getCProject() {
        String projectName = this.projText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return CoreModel.getDefault().getCModel().getCProject(projectName);
    }

    protected void initConfCombo() {
        this.buildConfCombo.removeAll();
        ICProject project = this.getCProject();
        if (project == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)LaunchMessages.getString((String)"CMainTab.Project_required"), (String)LaunchMessages.getString((String)"CMainTab.Enter_project_before_searching_for_program"));
            return;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project.getResource());
        if (info == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)LaunchMessages.getString((String)"CMainTab.Project_required"), (String)LaunchMessages.getString((String)"CMainTab.Enter_project_before_searching_for_program"));
            return;
        }
        IConfiguration[] confs = info.getManagedProject().getConfigurations();
        int i = 0;
        while (i < confs.length) {
            this.buildConfCombo.add(confs[i].getName());
            ++i;
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.resourceManager == null) {
            this.setErrorMessage(Messages.ApplicationTab_No_Resource_Manager_Available);
            return false;
        }
        String name = this.getFieldContent(this.projText.getText());
        if (name != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateName(name, 4);
            if (status.isOK()) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                if (!project.exists()) {
                    this.setErrorMessage(NLS.bind((String)Messages.ApplicationTab_Project_not_exist, (Object[])new Object[]{name}));
                    return false;
                }
                if (!project.isOpen()) {
                    this.setErrorMessage(NLS.bind((String)Messages.ApplicationTab_Project_is_closed, (Object[])new Object[]{name}));
                    return false;
                }
            } else {
                this.setErrorMessage(NLS.bind((String)Messages.ApplicationTab_Illegal_project, (Object[])new Object[]{status.getMessage()}));
                return false;
            }
        }
        if ((name = this.getFieldContent(this.buildConfCombo.getText())) == null) {
            this.setErrorMessage("Build configuration not specified");
            return false;
        }
        return true;
    }

    private IResourceManager getResourceManagerDefault() {
        IModelManager modelManager = PTPCorePlugin.getDefault().getModelManager();
        IPUniverse universe = modelManager.getUniverse();
        if (universe != null) {
            IResourceManager[] rms = modelManager.getStartedResourceManagers(universe);
            if (rms.length == 0) {
                return null;
            }
            return rms[0];
        }
        return null;
    }

    private IResourceManager getResourceManagerFromCombo() {
        if (this.resourceManagerCombo != null) {
            int i = this.resourceManagerCombo.getSelectionIndex();
            return this.resourceManagers.get(i);
        }
        return null;
    }

    private void rmSelectionChanged() {
        this.resourceManager = this.getResourceManagerFromCombo();
    }

    private void setResourceManagerComboSelection(IResourceManager rm) {
        Integer results = this.resourceManagerIndices.get(rm);
        int i = 0;
        if (results != null) {
            i = results;
        }
        this.resourceManagerCombo.select(i);
        this.rmSelectionChanged();
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            ParallelPerfRecompMainTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == ParallelPerfRecompMainTab.this.resourceManagerCombo) {
                ParallelPerfRecompMainTab.this.rmSelectionChanged();
            } else if (source == ParallelPerfRecompMainTab.this.projButton) {
                ParallelPerfRecompMainTab.this.handleProjectButtonSelected();
                int bDex = ParallelPerfRecompMainTab.this.buildConfCombo.getSelectionIndex();
                String bString = ParallelPerfRecompMainTab.this.buildConfCombo.getText();
                ParallelPerfRecompMainTab.this.initConfCombo();
                if (bDex >= 0 && ParallelPerfRecompMainTab.this.buildConfCombo.getItemCount() > bDex && ParallelPerfRecompMainTab.this.buildConfCombo.getItem(bDex).equals(bString)) {
                    ParallelPerfRecompMainTab.this.buildConfCombo.select(bDex);
                } else if (ParallelPerfRecompMainTab.this.buildConfCombo.getItemCount() > 0) {
                    ParallelPerfRecompMainTab.this.buildConfCombo.select(0);
                }
            } else if (source == ParallelPerfRecompMainTab.this.appButton) {
                ParallelPerfRecompMainTab.this.handleApplicationButtonSelected();
            } else {
                ParallelPerfRecompMainTab.this.handleProjectButtonSelected();
            }
        }
    }
}

