/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.cell.environment.cellsimulator.core.local;

import java.io.IOException;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ptp.cell.environment.cellsimulator.CellSimulatorTargetPlugin;
import org.eclipse.ptp.cell.environment.cellsimulator.conf.Parameters;
import org.eclipse.ptp.cell.environment.cellsimulator.core.local.AddressesKeeper;
import org.eclipse.ptp.cell.environment.cellsimulator.core.local.PortsKeeper;
import org.eclipse.ptp.remotetools.utils.network.MacAddress;

public class LocalLaunchAutomaticAttributeGenerator {
    static LocalLaunchAutomaticAttributeGenerator autoAttrKeeper = null;
    private HashMap portsMap;
    private HashMap addressesMap;
    static final int host_offset = 1;
    static final int simulator_offset = 2;
    static final int MAC_RADIX = 16;
    public static final String ATTR_BASE_NETWORK = "attribute-generator-base-ip";
    public static final String ATTR_BASE_NETMASK = "attribute-generator-base-netmask";
    public static final String ATTR_BASE_MACADDRESS = "attribute-generator-base-macaddress";
    public static final String ATTR_MIN_PORTVALUE = "attribute-generator-min-portvalue";
    public static final String ATTR_MAX_PORTVALUE = "attribute-generator-max-portvalue";
    Inet4Address currentNetworkAddress;
    Inet4Address netmask;
    int currentPortValue;
    int maxPortValue;
    MacAddress currentMacAddress;

    LocalLaunchAutomaticAttributeGenerator() {
        IPreferenceStore store = CellSimulatorTargetPlugin.getDefault().getPreferenceStore();
        this.addressesMap = new HashMap();
        this.portsMap = new HashMap();
        try {
            this.currentNetworkAddress = (Inet4Address)Inet4Address.getByName(store.getString(ATTR_BASE_NETWORK));
            this.netmask = (Inet4Address)Inet4Address.getByName(Parameters.SIMULATOR_NETMASK);
            this.currentMacAddress = MacAddress.createMacAddress((String)store.getString(ATTR_BASE_MACADDRESS));
            this.currentPortValue = store.getInt(ATTR_MIN_PORTVALUE);
            this.maxPortValue = store.getInt(ATTR_MAX_PORTVALUE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static LocalLaunchAutomaticAttributeGenerator getAutomaticAttributeGenerator() {
        if (autoAttrKeeper == null) {
            autoAttrKeeper = new LocalLaunchAutomaticAttributeGenerator();
        }
        return autoAttrKeeper;
    }

    public int getJavaAPIPort(String id) {
        return this.getPortAttribute((String)id).apiPort;
    }

    public int getConsolePort(String id) {
        return this.getPortAttribute((String)id).consolePort;
    }

    public String getHostAddress(String id) {
        return this.getAddressAttribute((String)id).hostAddress;
    }

    public String getSimulatorAddress(String id) {
        return this.getAddressAttribute((String)id).simulatorAddress;
    }

    public String getMacAddress(String id) {
        return this.getAddressAttribute((String)id).macAddress;
    }

    public String getNetmask(String id) {
        return ATTR_BASE_NETMASK;
    }

    public int getAnotherJavaAPIPort(String id) {
        int newPort;
        this.getPortAttribute((String)id).apiPort = newPort = this.generatePortValue();
        return newPort;
    }

    public int getAnotherConsolePort(String id) {
        int newPort;
        this.getPortAttribute((String)id).consolePort = newPort = this.generatePortValue();
        return newPort;
    }

    private String[] generateAddressPair() {
        BigInteger addr = new BigInteger(this.currentNetworkAddress.getAddress());
        BigInteger mask = new BigInteger(this.netmask.getAddress());
        BigInteger currentNet = addr.and(mask);
        int netindex = mask.getLowestSetBit();
        BigInteger nextNet = currentNet.add(BigInteger.ONE.shiftLeft(netindex));
        BigInteger currentHostAddr = currentNet.add(BigInteger.valueOf(1L));
        BigInteger currentSimAddr = currentNet.add(BigInteger.valueOf(2L));
        Inet4Address host = null;
        Inet4Address sim = null;
        try {
            host = (Inet4Address)Inet4Address.getByAddress(currentHostAddr.toByteArray());
            sim = (Inet4Address)Inet4Address.getByAddress(currentSimAddr.toByteArray());
            this.currentNetworkAddress = (Inet4Address)Inet4Address.getByAddress(nextNet.toByteArray());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        String[] addrPair = new String[]{host.getHostAddress(), sim.getHostAddress()};
        return addrPair;
    }

    private String generateMacAddress() {
        String macStr = this.currentMacAddress.getStringRepresentation();
        BigInteger nextMac = this.currentMacAddress.getBigIntegerRepresentation();
        this.currentMacAddress.setValue(nextMac.add(BigInteger.ONE));
        return macStr;
    }

    private int generatePortValue() {
        boolean validPort = false;
        int chosenPort = this.currentPortValue;
        if (this.currentPortValue == -1) {
            return this.currentPortValue;
        }
        if (chosenPort > this.maxPortValue) {
            this.currentPortValue = -1;
            return this.currentPortValue;
        }
        Socket lockSocket = new Socket();
        InetAddress localAddr = null;
        try {
            localAddr = Inet4Address.getLocalHost();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        while (true) {
            InetSocketAddress sAddr = new InetSocketAddress(localAddr, chosenPort);
            try {
                lockSocket.bind(sAddr);
                lockSocket.close();
            }
            catch (IOException iOException) {
                ++chosenPort;
                if (!validPort) continue;
            }
            break;
        }
        this.currentPortValue = chosenPort + 1;
        return chosenPort;
    }

    private PortsKeeper getPortAttribute(String id) {
        if (this.portsMap.containsKey(id)) {
            return (PortsKeeper)this.portsMap.get(id);
        }
        return this.generateAndStorePorts(id);
    }

    private AddressesKeeper getAddressAttribute(String id) {
        if (this.addressesMap.containsKey(id)) {
            return (AddressesKeeper)this.addressesMap.get(id);
        }
        return this.generateAndStoreAddresses(id);
    }

    private synchronized AddressesKeeper generateAndStoreAddresses(String id) {
        String[] addrPair = this.generateAddressPair();
        String macAddr = this.generateMacAddress();
        AddressesKeeper ak = new AddressesKeeper(addrPair[0], addrPair[1], macAddr);
        this.addressesMap.put(id, ak);
        return ak;
    }

    private synchronized PortsKeeper generateAndStorePorts(String id) {
        int apiPort = this.generatePortValue();
        int consolePort = this.generatePortValue();
        PortsKeeper ak = new PortsKeeper(consolePort, apiPort);
        this.portsMap.put(id, ak);
        return ak;
    }

    public synchronized void removeAddresses(String id) {
        this.addressesMap.remove(id);
    }

    public synchronized void removePorts(String id) {
        this.portsMap.remove(id);
    }
}

